/* iNomads.js -- Javascript for iNomads
 * 
 * (C) copyright 2007-2022, PVX Plus Technologies Ltd., Ontario, Canada
 * All rights reserved worldwide.
 * Unauthorized use of this code is strictly prohibited.
 */

var bFireFox = false;
var bOpera = false;
var bSafari = false;
var bBerry = false;
var bChrome = false;
var bTouchScrn = false;
var bAndroid = false;
var biPad = false;
var sRev = 'inomads.js Rev: Mar 31/2022';
var sTruSeq = null;

var chg_id = '';
var chg_val = '';
var sig_id = '';

var wdwParent = null;

var oFcs;	// Object that has focus
var oTrap = null;
var oTraps = null;
var oChg = null;
var oScan = null;
var sFcsId;  // Ctl id for focus
var sFcsPend = '';
var sFullVal = null;

var bPopOkay = false;
var oPopWdw = null;
var sPopUrl = null;
var sPopTarget = null;
var sPopOpt = null;
var oPopMask = null;

var cur_kc = 0;
var sFmt = '';
var bIgnoreFcs = 0;
var bSkipOnFocus = 0;	// Set when no need to send focus to host
var bIsCommon = false;
var oCellEdit = null;
var nNumber = 0;
var bDrawn = false;

var sPending = '';
var sPendLast = '';

var nSubmit = 0;
var sSubmit = '';

var iNmd_is_ie = 0;
var iNmd = null;

var nMseX = 0;
var nMseY = 0;
var nMseDwnX;
var nMseDwnY;
var nOrigX;
var nOrigY;
var nMinX;
var nMinY;
var oMse = null;
var oMseOnTop = null;

var oMnuDiv = null;

var wdwWd;
var wdwHi;
var bdyWd;
var bdyHi;
var pnlWd;
var pnlHi;
var divWd;
var divHi;
var OrigWd;
var OrigHi;

var oStamp;
var nPoll = 0;
var nPollTime = 60;
var idTimeout = null;
var idInputTmr = null;
var nTimeout = 0;

var bSettled = false;
var bSetSize = false;
var bShrink = false;
var bResizable = true;
var bRClick = false;
var oRClick = null;

var nPendSize = 0;
var bMaskResize = false;

var oFocusGlow = null;
var bAutoFolder = false;
var nMaxFolder = 11101;
var nMinFolder = 11001;

var bHdrResize = false;
var bIgnUnload = false;
var bIgnUnload2 = false;
var sTabFcs = null;
var bTrapped = false;
var bRefocus = false;
var bIdleReqd = false;
var bFldrPend = false;

var nDblClkMS = 1000;
var nClickMS = 0; 
var oClick = null;

var sMsgBar = '';
var oMsgBar = null;
var bMsgBar = false;

var n2YrMax;
var aOpts = new Array();
var aScrolls = new Array();

var oMbxBtn = null;
var oMbxFcs = false;
var oMbxFcsIgn = false;
var sMbx = '';

var nLogIdx = 0;
var nLogMax = 200;
var sLogTxt = new Array();
var sLogKey = new Array();
var infoIframe = null;
var rcMain = null;
var b3Lines = false;

function submitform(ctl_id) { iNmd_Send(ctl_id); } /* Old */
function iNmd_Send(ctl_id)
{	if (oChild)
	{	if (oChild.closed)
			oChild = null;
		else
			return;			/* No submits while I have a child */
	}

	if (bIdleReqd)
	{	bIdleReqd = false;
		AjxSend('I', 1);
	}

	document.inomads._ctl_id.value = ctl_id;

	window.onbeforeunload = null;
	window.onunload = null;
	bIgnUnload = true;

	location.replace(window.location.pathname +
				'?_session=' + document.inomads._session.value +
				'&_seq=' + document.inomads._seq.value + 
				'&_ctl_id=' + ctl_id + 
				'&_id=' + Math.round(Math.random() * 100000000) +
				'&_eom=' + document.inomads._eom.value);

	return;
}

/* Generic focus handling and signalling logic */

function iNmd_focus(oFcsNew)
{	if (oDivMbox) return;
	if (oDivMask)
	{	i_Id('id_Dead').focus();
		return;
	}
	if (bIgnoreFcs) 
	{	bIgnoreFcs = 0;
		return;
	}

	if (bPopup) return;

	if (oMnuDiv) iMnu_Clear();

	if (oFcs && (oFcs == oFcsNew)) return;	/* No change */

	/* If Server didn't send us here check current focus
		- Check rules to see if focus chg ok
		- Set pending new focus to go to host
		- Process any changes
	 */
	
	if ((oFcs) && (oFcs != oFcsNew))
	{	if (!iNmd_Valid()) return; 
	}

	sFcsPend = oFcsNew.id.substr(3);	

	if (oFcs)
	{	var oFcsHold;
		
		if (oFcs.in_autopend) iNmd_Auto();
		
		if (oFcs.in_blur) oFcs.in_blur(oFcs);
		
		if (!oChg && oFcs.in_oldval)
		{	if (oFcs.in_oldval != iNmd_Val(oFcs)) oChg = oFcs;
		}
		
		oFcsHold = oFcs;
		
		oFcs = null;
		if (oChg) iNmd_Chg(oChg);
	
		if ((oFcsHold._null) && (oFcsHold.value == ''))
		{	oFcsHold.value = oFcsHold._null;
			oFcsHold._null_showing = true;
		}
	}

	iNmd_SetFcs(oFcsNew, false);

	if (sFcsPend != '')  AjxSend('', 0);

	return;
}

function iNmd_SetFcs(oFcsNew, bRetry)
{	oChg = null;

	document.inomads._eom.value = '';
	oFcs = oFcsNew;
	
	if (oMsgBar) iNmd_Msg();
	
	if (bRetry || (oFcs.in_sigexit == 1)) 
	{	oChg = oFcs;
	}
	
	if (iNmd_is_ie && sFocusGlow && (sFocusGlow.length > 0))
	{	if (oFocusGlow)
		{	oFocusGlow.style.backgroundImage = oFocusGlow.orig_Img;
			oFocusGlow.style.backgroundRepeat = oFocusGlow.orig_Rpt;
			oFocusGlow = null;
		}

		if (oFcs.type && ((oFcs.type == 'checkbox') || (oFcs.type == 'radio')) )
		{	oFcs.orig_Rpt = oFcs.style.backgroundRepeat;
			oFcs.orig_Img = oFcs.style.backgroundImage;

			oFcs.style.backgroundRepeat = "no-repeat";
			oFcs.style.backgroundImage = "url(" + sFocusGlow + ")";
			oFocusGlow = oFcs;
		}
	}
	
	if (oFcs.in_fmt)
	{	sFmt = oFcs.in_fmt;
	}
	else
	if (oScan)
	{	if (oFcs.type == 'text')
			oScan.style.display = oScan.i_display;
		else
			oScan.style.display = 'none';
	}

	var sSigFull = oFcs.getAttribute('data-SigFull');
	if (sSigFull) 
	{	if (sSigFull == '1') 
		{	oFcs.setAttribute('oninput','iNmd_Full(this);');
			sFullVal = null;
		}
		else
			oFcs.removeAttribute('oninput');
	}
	
	sFcsId = oFcs.id.substr(3);
	document.inomads._fcs_id.value =  sFcsId;

	if (oFcs.className == 'iCmnVal')
	{	bIsCommon = true;
	}
	else
	{	bIsCommon = false;
	}

	oFcs.in_oldval = iNmd_Val(oFcs);
}

function iNmd_SetVal(sId, sVal)
{	var oObj = i_Id(sId);
	if (oObj)
	{	oObj.value = sVal;
		oObj.in_oldval = ':' + sVal;
	}
	return;
}

function iNmd_SetNull(sId, sVal)
{	var oObj = i_Id(sId);
	if (!oObj) return;
	
	if (oObj._null_showing) 
	{	oObj.value = '';
		oObj._null_showing = false;
	}
	
	if (sVal == '') 
	{	oObj._null = null;
		return;
	}
	
	oObj._null = sVal;
	if (oObj.value == '')
	{	oObj.value = sVal;
		oObj._null_showing = true;
	}
	return;
}

function iNmd_SigExit(sId, bSig)
{	var oObj = i_Id(sId);
	if (oObj)
	{	oObj.in_sigexit = bSig;
		if (bSig && (oFcs == oObj)) oChg = oFcs;
	}
	return;
}
	
function iNmd_Auto()
{	if (!oFcs.in_autopend) return;
	oFcs.in_autopend = false;
	
	var sVal = iNmd_Val(oFcs);
	if (oFcs.in_oldval == sVal) return;
	
	if (!oFcs.in_auto)
	{	if (oFcs.in_NullChg)
		{	if (sVal == ':')
			{	if (oFcs.in_oldval == ':') return;
			}
			else
			{	if (oFcs.in_oldval != ':') return;
			}
		}
	}
		
	oFcs.in_oldval = sVal;

	if (oFcs.in_fcsId) sVal += '#' + oFcs.in_fcsId;
	
	AjxSend('C' + oFcs.id.substr(3) + ',0' + sVal, 0);
	oChg = null;
	return;
}

function iKey(e)
{	if (!iNmd_is_ie)
		return e.which;
	else
		return e.keyCode;
}			
	
function iNmd_Chg(oCtl, cType)
{	var sVal;
    var chEom;
    var nEom;
    
	if (!oCtl) return;
	if (!cType) cType = 'C';

	if (cType != 'U') oChg = null;
	
    chEom = document.inomads._eom.value;
    if (chEom == '') 
		nEom = 0;
    else
		nEom = chEom.charCodeAt(0);

    if (oCtl.id.substr(0,3) == 'rb_') oCtl = iNmd_RbtVal(oCtl);

	sVal = iNmd_Val(oCtl);
	oCtl.in_oldval = sVal;
	
	if(oCtl.in_fmt) sVal = i_StpFmt(oCtl, sVal);
			
    if (oCtl.in_fcsId) sVal += '#' + oCtl.in_fcsId;
    
	AjxSend(cType + oCtl.id.substr(3) + ',0' + nEom + sVal, 1);
	return;
}

function i_FFChg(oPswd)
{	if ((bFireFox) && (oFcs != oPswd)) AjxSend("C" + oPswd.id.substr(3) + ",00" + iNmd_Val(oPswd));
}

function i_StpFmt(oCtl, sVal)
{	return sVal;
	var sFmt = oCtl.in_fmt;
	if (!sFmt) return sVal;

	var chVal;
	var nOfs;
	var bIsNum = false;
	
	for (nOfs = 0; nOfs < sFmt.length; nOfs++)
	{	chVar = sFmt.substr(nOfs,1);
		if (chVar == '#')
		{	bIsNum = true;
			break;
		}
		if (chVar == '0')
		{	break;
		}
	}

	var sValTru = sVal.substr(0,1);
	for (nOfs = 1; nOfs < sVal.length; nOfs++)
	{	chVal = sVal.substr(nOfs,1);
		if (bIsNum)
		{	if (chVal == chDecimal)
				sValTru += '.';
			else
			if ('0123456789-'.indexOf(chVal) != -1)
				sValTru += chVal;
		}
		else
		{	if ('0#AaXxZz'.indexOf(sFmt.substr(nOfs,1)) != -1) sValTru += chVal;
		}
	}
	return sValTru;
}

function iNmd_TabOut(e)
{	if (e.shiftKey)
		document.inomads._eom.value = '\x19';
	else
		document.inomads._eom.value = '\t';

	sTabFcs = '*';
	setTimeout(iNmd_TabSnd, 50);
	
	if (oFcs)
	{	iNmd_TabTrap(oFcs);
		if (iNmd_is_ie) iNmd_IE_deselect();
	}

	if (e.stopPropagation) e.stopPropagation();
	if (e.preventDefault) e.preventDefault();
	e.cancelBubble = true;
    e.cancel = true;
	e.returnValue = false;
		 
	return false;
}

function iNmd_TabTrap(oCurFcs)
{	if (!oTrap)
	{	oTrap = i_Id("id_Trap");
		if (!oTrap) return;
		oTraps = i_Id("id_Traps");
	}
	
	if (oCurFcs)
	{	var rcDiv = oCurFcs.getBoundingClientRect();
		var top = rcDiv.top;
		var left = rcDiv.left;
	
		if (window.pageYOffset)
			top += window.pageYOffset;
		else
		if (document.documentElement.scrollTop) 
			top += document.documentElement.scrollTop;

		if (window.pageXOffset)
			left += window.pageXOffset;
		else
		if (document.documentElement.scrollLeft)
			left += document.documentElement.scrollLeft;

		oTraps.style.position = 'absolute';
		oTraps.style.left = (left - oTraps.offsetWidth - 4) + 'px';
		oTraps.style.top = top + 'px';
	}
	
	oTrap.focus();
	bTrapped = true;
}

function iNmd_TabSnd()
{	if (!oFcs) alert('Tab with no focus');

	if (!iNmd_Valid())
	{	document.inomads._eom.value = '';
		sTabFcs = null;
		return;
	}

	if (!oChg && oFcs.in_oldval)
	{	if (oFcs.in_oldval != iNmd_Val(oFcs)) oChg = oFcs;
	}
	
	if (oChg)
	{	iNmd_Chg(oChg);
	}
	else
	{	var cTab = document.inomads._eom.value;
		if (cTab == '') cTab = '\t';
		AjxSend('C,' + cTab.charCodeAt(0), 0);
	}
	return;
}
	
function iNmd_KdnChkTab(e)
{	if (window.event) e = window.event;

	var cKey = iKey(e);
	
	if (cKey == 9)
	{	return iNmd_TabOut(e);
	}
	
	if (cKey == 112+8)
	{	iNmd_Send('RENEW');
		e.returnValue = false;
		return false;
	}
	if (cKey == 27)
	{	AjxSend('C-1999,27');
		e.returnValue = false;
		return false;
	}		

	return true;
}

function iNmd_IE_deselect()
{	if (oFcs.type == 'text') document.selection.empty();
	return;
}	

function iNmd_Val(oObj)
{	if (!oObj.type) return '';

	if (oObj.getAttribute("data-ipadEmul")) return ':' + iPadDbVal(oObj);

	if ((oObj.type == 'text') || (oObj.type == 'textarea') || (oObj.type == 'hidden') || (oObj.type == 'password'))
		return ':' + oObj.value;
	
	if (oObj.type.substr(0,6) == 'select')
	{	var sVal = ':';
  
		var  nIdx = 0;
		while (nIdx < oObj.length)
		{	if (oObj.options[nIdx++].selected) sVal = sVal + nIdx + ',';
		}
		return sVal;
	}
	return '';
}

function iNmd_Restore(oObj)
{	oChg = null;			/* Toss any pending */

	if (!oObj.in_oldval) return;
	if (!oObj.type) return;

	if ((oObj.type == 'text') || (oObj.type == 'textarea') || (oObj.type == 'hidden') || (oObj.type == 'password'))
	{	oObj.value = oObj.in_oldval.substr(1);
	}
	else
	if (oObj.type.substr(0,6) == 'select')
	{	iNmd_LbxSel(oObj.id, oObj.in_oldval.substr(1));
	}
	return;
}
	
function iNmd_Pend()
{	if (oMnuDiv) iMnu_Clear();

	iNmd_Send(sPending);
	sPendLast = '';
	sPending = '';
}

function iNmd_Submit(msg_id)
{	if (oMnuDiv) iMnu_Clear();

	nSubmit++;
	sSubmit = msg_id;

	if (bFldrPend && (msg_id == 'RESET')) return;
	
	if (sPending == '')
	{	iNmd_Send(msg_id);
	}
	else
	{	iNmd_Queue(msg_id);
	}
}

function iNmd_Queue(msg_id)
{ if (sPendLast == msg_id) return;
  sPendLast = msg_id;

  if (sPending == '')
   { sPending = msg_id;
     setTimeout(iNmd_Pend, 350);
   }
   else
   { sPending += ';' + msg_id;
   }
}

function i_RMseClk(event)
{	if (window.event) event = window.event;

	if ((event.altKey) || (bRClick))
	{	var oNode = (event.target ? event.target : event.srcElement);
		var oHtml;
		var nOfs; 
	    
	    if (bRClick) i_RClk(null);

		if (oNode == window) return iNmd_Context(event);

		while (oNode)
		{	oHtml = oNode.oncontextmenu;
			if (oHtml || (oNode.id == 'id_Main')) break;
			oNode = oNode.parentNode;
		}
		
		if (oHtml) oHtml(event);
		return i_IgnEvent(event);
	}
	return true;
}

function iNmd_init(idStrt, nPollTm)
{	var oStart;
	if (nPollTm) nPollTime = nPollTm;
	
	iNmd = document.inomads;
	oStamp = i_Id('iNmdScript');
	
	try
	{	if (window.opener)
			wdwParent = window.opener.iNmd_HiMom(window);
	}
	catch(err)
	{	wdwParent = null;
	}
	
	if (window.focus) window.focus();

	iNmd_is_ie = 0;
	document.cookie = "_session=; Path=/; Expires=Thu, 01 Jan 1970 00:00:01 GMT;";

	if (window.opera)
	{	sRev += '(Opera)';
		window.addEventListener('mousedown', i_RMseClk, false);
		bOpera = true;
	}
	else 
	if (navigator.appName == 'Microsoft Internet Explorer')
	{	var sAgent = window.navigator.userAgent;
		var nOfsMSIE = sAgent.indexOf("MSIE ");
		if (nOfsMSIE > 0)
		{	sAgent = sAgent.substring(nOfsMSIE+5);
			iNmd_is_ie = parseInt(sAgent);
		}

		if (!iNmd_is_ie) iNmd_is_ie = 1;
		
		sRev += '(MSIE-' + iNmd_is_ie+')';
		document.onkeydown = function()
		{	var e = event || window.event;
			if (e.keyCode != 8) return true;
			if (oCellEdit) return true;

			if ((e.srcElement == oFcs) && (oFcs.type))
			{	if ((oFcs.type == 'text') || (oFcs.type == 'textarea') || (oFcs.type == 'password'))
				{	if (!oFcs.readOnly)	return true;
				}
			}
			return false;
		}
	}
	else
	if (navigator.userAgent.indexOf("Firefox") != -1)
	{	sRev += '(Firefox)';
		bFireFox = true;
		
		for (var nElm = 0; nElm < document.inomads.elements.length; nElm++)
		{	if (document.inomads.elements[nElm].type.substr(0,6) == 'select')
			{	document.inomads.elements[nElm].in_oldval = iNmd_Val(document.inomads.elements[nElm]);
			}
		}
		
	}
	else
	if (navigator.userAgent.indexOf("Android") != -1)
	{	bChrome = true;
		sRev += '(Android)';
		nDblClkMS = 3000;
		bAndroid = true;
	}
	else
	if (navigator.userAgent.indexOf("Chrome") != -1)
	{	bChrome = true;
		sRev += '(Chrome)';
		nDblClkMS = 3000;
	}
	else
	if (navigator.userAgent.indexOf("Apple") != -1)
	{	bSafari = true;
		if (navigator.userAgent.indexOf("iPhone") != -1)
		{	sRev += '(iPhone)';
			bTouchScrn = true;
			bIpad = true;
			nDblClkMS = 5000;
		}
		else
		if (navigator.userAgent.indexOf("iPad") != -1)
		{	sRev += '(iPad)';
			bTouchScrn = true;
			bIpad = true;
			nDblClkMS = 5000;
		}
		else
		{	sRev += '(Safari)';
		}
	}
	else
	if (navigator.userAgent.indexOf("BlackBerry") != -1)
	{	bSafari = true;
		bBerry = true;
		if (navigator.userAgent.indexOf("erry95") == -1)
			sRev += '(BlackBerry)';
		else
		{	sRev += '(BB-Storm)';
			bTouchScrn = true;
			nDblClkMS = 5000;
		}
	}
	
	oScan = i_Id('rc_scan');
	if (oScan) oScan.i_display = oScan.style.display;
	
	if ("ontouchstart" in window) bTouchScrn = true;
		
	window.onbeforeunload = iNmd_B4Unload;
	
	if (!bSafari) window.onunload = iNmd_Unload;

	if (!bOpera)i_Id('id_Main').oncontextmenu = iNmd_Context;

	if (oStamp)
	{	oStamp.innerHTML = '<a href="#" onclick="AjxDump();">' + sRev + '</a>' +
				'<span id="id_Traps"><a class="iCmnVal" href="#" tabindex=1000 onfocus="iNmd_TabTrap(null);">&nbsp;</a>' +
				'<a class="iCmnVal" id="id_Trap" href="#" tabindex=1001>&nbsp;</a>' +
				'<a class="iCmnVal" href="#" tabindex=1002 onfocus="iNmd_TabTrap(null);">&nbsp;</a></span>';
	}
	
	/* Disable autocomplete */
	
	if (document.getElementsByTagName)
	{	var inputElements = document.getElementsByTagName('input');
		for (var i=0; inputElements[i]; i++)
		{	if (inputElements[i].type == 'text') inputElements[i].setAttribute("autocomplete","off");
		}
	}
	
	/* Div initializations */
	
	var divs = document.getElementsByTagName('div');
	for (var i = 0; i < divs.length; i++)
	{	switch(divs[i].className)
		{	case 'iLv':
				iLvInit(divs[i]);
				break;
		}
	}

	/* Start scroll monitor */

	setInterval(iScrollChk, 100);
	
	if (infoIframe) iNmd_Push2Init();

	/* Grow/Resize window if reqd */

	if (oStamp && window.opener && bSetSize)
	{	iNmd_GetSize();
		if (wdwWd > 0)
		{	var hiReqd = divHi + 8;
			var oRoot = i_Id('id_Root');
			var wdReqd;

			if (oRoot)
				wdReqd = oRoot.offsetWidth;
			else
				wdReqd = pnlWd;
				
			wdReqd += 8;
			if (bChrome) wdReqd += 12;

			wdReqd -= wdwWd;
			hiReqd -= wdwHi;

			if (!bShrink) 
			{	if (wdReqd < 0) wdReqd = 0;
				if (hiReqd < 0) hiReqd = 0;
			}
				
			if (wdReqd || hiReqd) window.resizeBy(wdReqd, hiReqd);
		}
	}

	oMsgBar = i_Id('Msgbar');
	
	i_AddEvent(window, 'mousemove', iNmd_MseTrack, true);
	if (idStrt != '')
	{	var oFld = i_Id(idStrt);
	
		if (oFld)
		{	iNmd_SetFcs(oFld, false);
			if (oFld.focus)	oFld.focus();
			iNmd_Select(oFld);
		}
	}
	
	if (bTouchScrn) window.scrollTo(0,1);

	setTimeout(iNmd_Settled,50);
}

function iScrollChk()
{	var		oDs;
	for (var n=0; n < aScrolls.length; n++)
	{	oDs = aScrolls[n];
		if ((oDs.scrollLeft != oDs.iOldLeft) || (oDs.iOldTop != oDs.scrollTop)) iLvScrlUpd(oDs);

		oDs.iOldLeft = oDs.scrollLeft;
		oDs.iOldTop = oDs.scrollTop; 
	}
	return;
}

function i_Open(sUrl, sTarget, sOpt)
{	oPopWdw = null;

	if (navigator.userAgent.endsWith("pxplus app"))
	{	bIgnUnload2 = true;
		window.open(window.location.protocol + "//" + window.location.hostname + (window.location.port ? ":" + window.location.port : "") + sUrl);
		bPopOkay = true
		return true;
	}

	bPopOkay = false;
	
	sPopUrl = sUrl;
	sPopTarget = sTarget;
	sPopOpt = sOpt;

	oPopWdw = window.open("/syshtml/sys_popup.htm", sPopTarget, sPopOpt).focus();
	
	return true;
}

function i_OpenChk()
{	if (!bPopOkay)
	{	if (!oPopWdw || oPopWdw.closed || (typeof oPopWdw.closed == 'undefined') ||
			oPopWdw.outerHeight == 0 || oPopWdw.outerWidth == 0)
			{	if (!oPopMask)
				{	oPopMask = document.createElement('div');
					oPopMask.style.position='absolute';
					oPopMask.style.left = 0;
					oPopMask.style.top = 0;
					oPopMask.style.width = '100%';
					oPopMask.style.height = '100%';
					oPopMask.className = 'iPopMask';
					oPopMask.innerHtml = '&nbsp;';
					i_AddNode(oPopMask);
				}	
				return false;
			}
	}
		
	if (oPopMask)
	{	oPopMask.parentNode.removeChild(oPopMask);
		oPopMask = null;
	}
	
	sPopUrl = null;
	return true;
}

function i_PopClk(sUrl, sTarget, sOpt)
{	if (sUrl != '')window.open(sUrl, sTarget, sOpt).focus();
	iNmd_MbxDrop();
	AjxSend('C0,0',1);
}

function iNmd_IEDblClk(e)		/* Future */
{	if (window.event) e = window.event;
	var oFld = (e.target ? e.target : e.srcElement);
	while (oFld)
	{	if (oFld.onclick)
		{	alert("Dbl:"+oFld.id+" Event="+oFld.onclick);
			return false;
		}
		oFld = oFld.parentNode;
	}
	return false;
}	

var sMseId = '';

function iNmd_MseTrack(e)
{	if (window.event) e = window.event;
	var oFld = (e.target ? e.target : e.srcElement);
	while (oFld)
	{	if (oFld.id) 
		{	sMseId = oFld.id;
			
			if ((oFld.type == 'select') && (oFld.size > 1))
			{	iNmd_MseXY(e);
				
				var itemHeight = Math.floor(oFld.offsetHeight / oFld.size);
				var itemNo = Math.floor((nMseY - iNmd_Top(oFld) + oFld.scrollTop) / itemHeight);
				
				if ((itemNo >= 0) && (itemNo < oFld.length)) 
					sMseId += '_' + (itemNo + 1);
			}
			break;
		}
		oFld = oFld.parentNode;
	}
	return;
}
	
function iNmd_Tab(e)
{	if (oFcs && oFcs.focus) 
	{	if (!oCellEdit) oFcs.focus();
	}
	return;
}

function iNmd_Context(e)
{	if (window.event) e=window.event;
	var oFld = (e.target ? e.target : e.srcElement);

	while (oFld)
	{	if (oFld.id) 
		{	if ((oFld.id.substr(0,8) == 'id_Panel') | (oFld.id == 'id_Folder')) break;
			
			if (oFld.id.substr(0,6) != 'iFrame')
			{	if (oFld.id.substr(0,2) != 'd_')  return true;
			}

		}
		else
		if ((oFld.nodeName == 'TD') && (oFld.className == 'iPnl')) break;

		oFld = oFld.parentNode;
	}

	if (e.stopPropagation) e.stopPropagation();
	if (e.preventDefault) e.preventDefault();

	iNmd_MseXY(e);

	if (oChg != null) iNmd_Chg(oChg);

	var sWdw = null;
	if (oFld) sWdw = oFld.getAttribute("data-wdwobj");
	if (!sWdw) sWdw = sWdwObj;

	iNmd_Signal(sWdw, 'RClk:' + (oFld ? oFld.id : ""));
	return i_IgnEvent(e);
}	

function iNmd_B4Unload()
{	if (bIgnUnload) return;
	if (bIgnUnload2) 
	{	bIgnUnload2 = false;
		return;
	}

	if (window.location.href.indexOf("_session=") == -1) 
	{	var d = new Date();
		d.setTime(d.getTime() + (5*60*1000));		/* Allow five minutes only */
		document.cookie = "_session=" + document.inomads._session.value + ";expires=" + d.toUTCString() + ";Path=/;";
	}

	if ((oChild) && (!oChild.closed))
	{	setTimeout(window.blur,2500);
		if (typeof user_B4Unload == 'function')
			return user_B4Unload(oChild.document.title);
		else
			return "Please close the child window '"+ oChild.document.title + "' first.";
	}
	
	if (!wdwParent)
	{	if (typeof user_B4Unload == 'function')
			return user_B4Unload(null);
		else
			return "Please use the 'Close' option in the window to assure proper shutdown.";
	}

	if (bSafari) iNmd_Unload();
	return;
}

function iNmd_Unload()
{	if (bIgnUnload) return;
	bIgnUnload = true;			/* So we don't come here ever again */

	if (oChild && (!oChild.closed))
	{	try { oChild.wdwParent = wdwParent;	}
			catch(err) {}
	}
	
	oChild = null;
	
	if (wdwParent && (!wdwParent.closed))
	{	wdwParent.iNmd_ByeMom(document.inomads._seq.value);
	}
	else
	{	AjxSend('QGone', 0);
	}
}

var sChildSeq = null;

function iNmd_ByeMom(sSeq)
{	if (sChildSeq == null)
	{	sChildSeq = sSeq;
		setTimeout(iNmd_ByeMom,100);
		return;
	}

	oChild = null;
	sTruSeq = document.inomads._seq.value;
	
	document.inomads._seq.value = sChildSeq;
	AjxSend('Q' + sChildSeq,0);
	sChildSeq = null;
	
	document.inomads._seq.value = sTruSeq;
	sTruSeq = null;
}

function iNmd_HiMom(wdwChild)
{	if (wdwChild != oChild) 
		return null;
	else
		return window;
}

function iNmd_Settled()
{	if (bResizable)
	{	iNmd_GetSize();
		OrigWd = wdwWd;
		OrigHi = wdwHi;
		i_AddEvent(window, "orientationchange", iNmd_Rotate, false);
		if (!bTouchScrn) window.onresize = iNmd_Rotate;
	}
	
	nPoll = 0;
	bSettled = true;
	setInterval(iNmd_Poll, 60 * 1000);
}	

function iNmd_Poll()
{	if (idMbxTimer || oChild) return;

	nPoll++;
	if (nPoll >= nPollTime) 
	{	AjxSend('*',0);
	}
}

var idTimer = null;
var curTimer = 0;
var cntTimer = 0;

function iTimerFnc()
{	curTimer++;
	if (curTimer == cntTimer)
	{	curTimer = 0;
		AjxCtl(-1900);
	}
}

function iTimer(nSec)
{	if (idTimer) clearInterval(idTimer);
	idTimer = null;
	
	cntTimer = nSec;
	curTimer = 0;
	
	if (cntTimer > 0) idTimer = setInterval(iTimerFnc, 1000);
	return;
}
	

/* iNmd_GetSize -- set size */
function iNmd_GetSize()
{	pnlWd = pnlHi = -1;
	divWd = divWd = -1;
	wdwWd = wdwHi = -1;
	bdyWd = bdyHi = -1;
	
	var oSz = i_Id('id_Panel');
	if (oSz)
	{	pnlWd = oSz.offsetWidth;
		pnlHi = oSz.offsetHeight;
	}
	
	oSz = i_Id('id_Main');
	if (oSz)
	{	divWd = oSz.offsetWidth;
		divHi = oSz.offsetHeight;
	}
	
	bdyWd = document.body.offsetWidth;
	bdyHi = document.body.offsetHeight;

	if (document.body && document.body.offsetWidth)
	{	wdwWd = document.body.offsetWidth;
		wdwHi = document.body.offsetHeight;
	}
	if (document.compatMode == 'CSS1Compat' && document.documentElement && document.documentElement.offsetWidth)
	{	wdwWd = document.documentElement.offsetWidth;
		wdwHi = document.documentElement.offsetHeight;
	}
	if (window.innerWidth && window.innerHeight)
	{	wdwWd = window.innerWidth;
		wdwHi = window.innerHeight;
	}
	wdwWd -= document.body.offsetLeft;
	wdwHi -= document.body.offsetTop;

}

function iNmd_Rotate()
{	bMaxMin = 3;
	iNmd_Resize();
}

/* iNmd_Resize -- send resize to the host */

function iNmd_Resize()
{	if (oDivMask)
	{	bMaskResize = true;
		return;
	}
	if (oChild) return;	/* Should not occur since there s/b Mask */
	if (sPopUrl != null) return;	/* IE Popup block change screen size */
	
	if (nPendSize != 3)
	{	if (nPendSize == 0) setTimeout(iNmd_SendSize, 200);
		nPendSize = 1;
	}
	return;
}
	
var bMaxMin = 0;
var OnInomadsSize = null;

function iNmd_SendSize()
{	if (bMaxMin == 0)
	{	if (nPendSize == 3) return;

		if (nPendSize == 1)	
		{	setTimeout(iNmd_SendSize, 200);
			nPendSize = 2;
			return;
		}
			
		nPendSize = 3;
	}

	/* If bMaxMin=3 then Full screen resize */
	
	if (bMaxMin == 3)
	{	top.window.moveTo(0,0); 
		if (document.all) 
		{	top.window.resizeTo(screen.availWidth,screen.availHeight);
		}
		else
		if (document.layers || document.getElementById)
		{	if ((top.window.outerHeight < screen.availHeight) || (top.window.outerWidth < screen.availWidth))
			{	top.window.resizeTo(top.screen.availWidth, top.screen.availHeight);
			} 
		}
		bMaxMin = 1;
		setTimeout(iNmd_SendSize, 200);
		return;
	}
		
	iNmd_GetSize();
	if ((OrigWd == wdwWd) && (OrigHi == wdwHi))
	{	nPendSize = 0;
		return;
	}
	
	if (!i_Id('iMaxBtn') && !i_Id('iRstrBtn')) return;
	
	if (OnInomadsSize) OnInomadsSize();

	if (wdwWd < 0) return;

	if (bMaxMin == 2)
	{	iNmd_Signal(sWdwObj, "Rstr");
	}
	else
	{	var newWd;
		var newHi;

		if (rcMain)
		{	rcMain = parent.iNmd_Push2Rect();	/* Get updated */
			newHi = (rcMain.bottom - rcMain.top) - 10;
			newWd = (rcMain.right - rcMain.left) - 10;
		}
		else
		{	var oPnl = i_Id('id_Panel');
			var rcPnl = oPnl.getBoundingClientRect();

			newHi = rcPnl.bottom - rcPnl.top;
			newHi += wdwHi - bdyHi - 4;

			var oDiv = i_Id('Sect_Pnl');
			if (!oDiv) oDiv = i_Id('id_Main');
			if (!oDiv) oDiv = i_Id('iDiv');
			var rcDiv = oDiv.getBoundingClientRect();
				
			newWd = Math.min(wdwWd, (rcDiv.right - rcDiv.left)) - 15;
		}
				
		iNmd_Signal(sWdwObj, "Max:" + wdwWd + ',' + wdwHi + ',' + 
						bdyWd + ',' + bdyHi + ',' + 
						pnlWd + ',' + pnlHi + ',' + 
						newWd + ',' + newHi);

	}
	return;
}

function iShowMnm(nType)
{	setTimeout(function(){iNmd_MaxMin(nType);}, 200);
}
 
function iNmd_MaxMin(nType)
{	bMaxMin = nType;
	OrigWd = -1;
	iNmd_SendSize();
    if (window.event) window.event.returnValue = false;
    return false;
}
	
/* iNmd_ChkChr(InputChar, FormatChar)
 * Returns: 0 = Reject, 1=Accept, 2=This is a formating char
 */

function iNmd_ChkChr(cInp, cFmt)
{	if (cFmt == 'x') return 1;
	if (cFmt == cInp) return 1;

	if (cFmt == '0')
	{	if ((cInp >= '0') && (cInp <= '9')) return 1;
		return 0;
	}
	if (cFmt == 'a')
	{	if ((cInp >= 'a') && (cInp <= 'z')) return 1;
		if ((cInp >= 'A') && (cInp <= 'Z')) return 1;
		return 0;
	}
	if (cFmt == 'z')
	{	if ((cInp >= 'a') && (cInp <= 'z')) return 1;
		if ((cInp >= 'A') && (cInp <= 'Z')) return 1;
		if ((cInp >= '0') && (cInp <= '9')) return 1;
		return 0;
	}
	if (cFmt == '#')
	{	if ((cInp >= '0') && (cInp <= '9')) return 1;
		if (cInp == ' ') return 1;
		return 0;
	}
	return 2;
}

function iNmd_fmtchr(e, cNew)
{	var nStrt;
	var nLeng;
	var nOfst;

	var oRng;

	var oFld; 
	var sFld;

	var nOfsHash;
	var nOfsZero;

	var cNewOrig = cNew;

	if ((cNew < 32) && (cNew != 8)) return true;
	    
	if (e.target) oFld = e.target; else oFld = e.srcElement;
	if (oFld.nodetype == 3) oFld = oFld.parentNode;

	sFld = oFld.value;

	if (sFld.length > sFmt.length) // Force correction
	{	oFld.value = sFld.substr(0,sFmt.length);
		return false;
	}

	if ('selectionStart' in oFld)
	{	nStrt = oFld.selectionStart;
		nLeng = oFld.selectionEnd - nStrt;
	}
	else
	if (document.selection)
	{	oRng = document.selection.createRange();

		nLeng = oRng.text.length;

		nOfst = oRng.moveEnd("character", sFld.length);
		nStrt = sFld.length - oRng.text.length;

		if (nOfst != 0) oRng.moveEnd("character", 0 - nOfst);
	}

	if (e.stopPropagation) e.stopPropagation();
	if (e.preventDefault) e.preventDefault();
	e.cancelBubble = true;
    e.cancel = true;
	e.returnValue = false;

	nOfst = nStrt + nLeng;

	if (cNew == 8)
	{	if (nLeng == 0)
		{	if (nStrt == 0) return false;
			nStrt--;
		}
	}

	nOfsHash = sFmt.indexOf('#');
	nOfsZero = sFmt.indexOf('0');
	if (nOfsZero == -1) nOfsZero = sFmt.length + 1;

	if (nOfsHash != -1)
	{	if (nOfsHash < nOfsZero)
		{	return iNmd_numchr(cNew, oFld, oRng, nStrt, nLeng);
		}

		/* We have a # after a zero */

		if (nOfst == sFld.length)
		{	if ((nLeng == 0) || (nStrt == 0)) 
			return iNmd_digapnd(cNew, sFmt, oFld, oRng);
		}
	}

	if (nLeng == 0) nLeng = 1;

	var sRepl = '';
	var nRepl = 0;
	var chRepl = '';
	var bSts = 0;
	var nChrAdj = 1;
	
	for (nOfst = 0; nOfst < nLeng; nOfst++)
	{	var chFmt = sFmt.charAt(nOfst + nStrt);

		if ((cNew == 127) || (cNew == 8))
		{	if ((chFmt == '0') || (chFmt == '#'))
				chRepl = '0';
			else
			if ('AaXxZz'.indexOf(chFmt) == -1)
				chRepl = chFmt;
			else
			{	var nOfst2;
				for(nOfst2 = nOfst + nStrt; nOfst2 < sFmt.length; nOfst2++)
				{	if (sFmt.charAt(nOfst2) != chFmt) break;
				}
				if (nOfst2 < sFmt.length)
					chRepl = ' ';
				else
					chRepl = '';
			}
		}
		else
		{	chRepl = String.fromCharCode(cNew);
    
			if ('AXZ'.indexOf(chFmt) != -1) 
			{	chFmt = chFmt.toLowerCase();
				chRepl = chRepl.toUpperCase();
			}

			bSts = iNmd_ChkChr(chRepl,chFmt);

			if (bSts == 0) return false; // Bad character
			if (bSts == 2)
			{	chRepl = chFmt;
				nChrAdj++;       
				if (nLeng < sFmt.length) nLeng++;
			}
			else
				cNew = 127; // Delete reset rest of selection
				
			nRepl++;
		}
		sRepl += chRepl;
	}

	sRepl = oFld.value.substring(0, nStrt) + sRepl + oFld.value.substring(nStrt + nLeng, oFld.value.length);

	if ((cNewOrig == 8) || (cNewOrig == 127)) nChrAdj = 0;

	if (oRng)
	{	oRng.expand("textedit");
		oRng.text = sRepl;
		oRng.moveEnd("character", 0 - sRepl.length);
		oRng.moveStart("character", nStrt + nChrAdj);
		oRng.select();
	}
	else
	{	oFld.value = sRepl;
		oFld.selectionStart = nStrt + nChrAdj;
		oFld.selectionEnd = nStrt + nChrAdj;
	}
	return false; 
}

function iNmd_numchr(cNew, oFld, oRng, nStrt, nLeng)
{	var sNew;
	var nSign;
	var nValue;
	var nScale;
	var nOfst;
	var chNew;
	var chFmt;
	var nPos;
	var nReqScale;
	var nDigit;
	var bImpliedDP = false;

	if ((cNew == 8) || (cNew == 127)) 
	{	sNew = '';
		if (nLeng == 0) 
		{	if (oFld.value.charAt(nStrt) == chDecimal) nStrt--;
			nLeng = 1;
		}
	}
	else
	{	sNew = String.fromCharCode(cNew);
		if (nLeng <= 1)
		{	if (sNew == oFld.value.charAt(nStrt))
			return iNmd_FmtPos(oRng, oFld, nStrt+1, oFld.value);
		}

		if ((sNew == chDecimal) && (oFld.value.charAt(nStrt + nLeng) == chDecimal)) nLeng++;
	}

	nReqScale = 0;

	nOfst = sFmt.indexOf('.');
	
	if (nOfst != -1)
	{ for (;nOfst < sFmt.length;)
		{	chFmt = sFmt.charAt(nOfst++);
			if ((chFmt == '0') || (chFmt == '#')) nReqScale++;
		}
	}

	if (sFmt.charAt(0) == '\t')
	{	if ((nStrt + nLeng) == oFld.value.length) bImpliedDP = true;
	}

	sNew = oFld.value.substring(0, nStrt) + sNew + oFld.value.substring(nStrt + nLeng, oFld.value.length);

	nScale = -1000;
	nSign = 0;
	nValue = 0;
	nPos = 0;

	for (nOfst = 0; nOfst < sNew.length;)
	{	chNew = sNew.charAt(nOfst++);

		if (chNew == ' ') continue;
		if (chNew == chCurrency) continue;
		if (chNew == chThousand) continue;
		if (chNew == chDecimal)
		{	if (nScale >= 0) return false;
			nScale = 0;
			
			if (nOfst <= nStrt) nPos++;
			continue;
		}

		if ((chNew >= '0') && (chNew <= '9'))
		{	nValue = nValue * 10 + parseInt(chNew);
			nScale++;
			if (nOfst <= nStrt)
			{	if ((nPos != 0) || (chNew != '0')) nPos++;
			}
			continue;
		}

		if (chNew == '+')
		{	nSign = 1;
			continue;
		}

		if ((chNew == '-') || (chNew == '(') || (chNew == ')'))
		{	nSign = -1;
			continue;
		}
			
		continue;	/* return false; */
	}

	if (((cNew >= 48) && (cNew <= 57)) || (cNew == 46)) nPos++;

	if (cNew == 43) nSign = 1;   // Plus sign forces positive

	if (nScale < 0) nScale = 0;
 
	if (!bImpliedDP)
	{	while (nScale < nReqScale)
		{	nValue *= 10;
			nScale++;
		}
		while (nScale > nReqScale)
		{	nDigit = nValue % 10;
			nValue = (nValue - nDigit) / 10;
			nScale--;
		}
	}

	sNew = '';

	for (nOfst = sFmt.length; nOfst > 0;)
	{	chFmt = sFmt.charAt(--nOfst);
		if ((nOfst == 0) && (chFmt == '\t')) break;
		
		if (chFmt == '-')
		{	if (nSign == -1)
			{	sNew = '-' + sNew;
			}
			else  
			{	sNew = ' ' + sNew;
			}
			continue;
		}

		if (chFmt == '+')
		{	if (nSign == -1)
			{ sNew = '-' + sNew;
			}
			else  
			{ sNew = '+' + sNew;
			}
			continue;
		}

		if (chFmt == ',')
		{	if (nValue != 0) sNew = chThousand + sNew;
			continue;
		}

		if (chFmt == '.')
		{	sNew = chDecimal + sNew;
			continue;
		}

		if (chFmt == '0')
		{	nDigit = nValue % 10;
			sNew = nDigit + sNew;
			nValue = (nValue - nDigit) / 10;
			continue;
		}

		if ((chFmt == '(') || (chFmt == ')'))
		{	if (nSign == -1) sNew = chFmt + sNew;
			continue;
		}

		if (chFmt == '#')
		{	if (nValue != 0) 
			{	nDigit = nValue % 10;
				sNew = nDigit + sNew;
				nValue = (nValue - nDigit ) / 10;
			} 
			continue;
		}
		
		if (chFmt == '$') chFmt = chCurrency;

		sNew = chFmt + sNew;
	}

	if (nValue != 0) return false;

	if (bImpliedDP)
	{	nStrt = sNew.length;
	}
	else
	if ((nPos == 0) || (chNew == chDecimal))
	{	nStrt = sNew.indexOf(chDecimal);
		if (nStrt == -1)
			nStrt = sNew.length;
		else
		if (chNew == chDecimal) 
			nStrt++;
	}
	else
	{	var nDigit = 0;
		for (nStrt = 0; nStrt < sNew.length;nStrt++)
		{	chNew = sNew.charAt(nStrt);
			if ((chNew == chDecimal) || ((chNew >= '0') && (chNew <= '9')))
			{	nDigit++;
				if ((chNew == '0') && (nDigit == 1)) continue;
				if (nPos == 0) break;
				nPos--;
			}
		}
	}
	
	return iNmd_FmtPos(oRng, oFld, nStrt, sNew);
}

function iNmd_FmtPos(oRng, oFld, nStrt, sNew)
{	if (oRng)
	{	oRng.expand("textedit");
		oRng.text = sNew;
		oRng.moveEnd("character", 0 - sNew.length);
		oRng.moveStart("character", nStrt);
		oRng.select();
	}
	else
	{	oFld.value = sNew;
		oFld.selectionStart = nStrt;
		oFld.selectionEnd = nStrt;
	}
	return false; 
}
 
function iNmd_digapnd(cNew, sFmt, oFld, oRng)
{ var sStrip;
  var nOfst;
  var nOfsNew;
  var sFld = oFld.value;
  var sNew;
  var chFmt;
    
  sStrip = '';  
  for (nOfst = 0 ;nOfst < sFld.length; nOfst++)
  { chFmt = sFmt.charAt(nOfst);
    if ((chFmt == '0') || (chFmt == '#')) sStrip += sFld.charAt(nOfst);
  }
 
  if ((cNew == 8) || (cNew == 127))
  { sStrip = '0' + sStrip;
  }
  else
  { if ((cNew < 48) || (cNew > 57)) return false;
    sStrip = sStrip.substr(1) + String.fromCharCode(cNew);
  }

  sNew = '';

  nOfsNew = 0;

  for (nOfst = 0 ;nOfst < sFld.length; nOfst++)
  { chFmt = sFmt.charAt(nOfst);
    if ((chFmt == '0') || (chFmt == '#'))
      sNew += sStrip.charAt(nOfsNew++);
    else
      sNew += sFld.charAt(nOfst);
  }

  if (oRng)
  { oRng.expand("textedit");
    oRng.text = sNew;

    oRng.moveEnd("character", sNew.length);
    oRng.moveStart("character", sNew.length);
    oRng.select();
  }
  else
  { oFld.value = sNew;
  
    oFld.selectionStart = sNew.length;
    oFld.selectionEnd = sNew.length;
  }

  return false; 
}      
  
function iNmd_Valid()
{	if (!oFcs.in_rules) return true;
	
	var sRule = oFcs.in_rules;
	if (sRule == '') return true;

	var nValue;
	var bValue; 	// Input is numeric
	var sMin;
	var sMax;
	var nOfst;
	var sCur;

	bValue = iNmd_ToNum(oFcs.value, 1);
	nValue = nNumber;

	if (oFcs.style.textTransform && (oFcs.style.textTransform == 'uppercase'))
	{	sCur = oFcs.value.toUpperCase();
		oFcs.value = sCur;
	}

	while (sRule != '')
	{	nOfst = sRule.indexOf(',');
		if (nOfst == -1)
		{	sCur = sRule;
			sRule = '';
		}
		else
		{	sCur = sRule.substring(0, nOfst);
			sRule = sRule.substring(nOfst + 1, sRule.length);
		}

		nOfst = sCur.indexOf('-', 1);
		if (nOfst == -1)
		{	sMin = sCur;
			sMax = sMin;
		}
		else
		{	sMin = sCur.substring(0, nOfst);
			sMax = sCur.substr(nOfst+1);
		}

		if (bValue == true)
		{	if (iNmd_ToNum(sMin, 0))
			{	if (nValue < nNumber) continue;
				if (iNmd_ToNum(sMax, 0))
				{	if (nValue <= nNumber) return true;
					continue;
				}
			}
		}

		if (sMin > oFcs.value) continue;
		if (sMax >= oFcs.value) return true;
	}
	
	bIgnoreFcs = 1;
	if (oFcs.focus) oFcs.focus();

	alert('"' + oFcs.value + '"' + sInvalid + oFcs.in_rules);

	bIgnoreFcs = 0;
	if (oFcs.focus) oFcs.focus();
			
	return false;
}

function iNmd_ToNum(sVal, bExternal)
{ var nOfst;
  var chVal;

  var chPoint;  
  var nSign = 0;
  var nScale = -1000;
  nNumber = 0;

  if (bExternal)
   chPoint = chDecimal;
  else
   chPoint = '.';

  for (nOfst = 0; nOfst < sVal.length;)
  { chVal = sVal.charAt(nOfst++);

    if (bExternal)
    { if (chVal == chCurrency) continue;
      if (chVal == chThousand) continue;
      if (chVal == ' ') continue;
    }

    if (chVal == chPoint)
    { if (nScale >= 0) return false;
      nScale = 0;
      continue;
    }

    if ((chVal >= '0') && (chVal <= '9')) 
    { nNumber = (nNumber * 10) + parseInt(chVal,10);
      nScale++;
      continue;
    }

    if (nSign == 0)
    { if (chVal == '-') 
      { nSign = -1;
        continue;
      }

      if (chVal == '+')
      { nSign = 1;
        continue;
      }
    }
    return false;
  }
  
  while (nScale > 0)
  { nNumber /= 10;
    nScale--;
  }
  
  if (nSign != 0) nNumber *= nSign;
  return true;
}
   
// Keydown events

function iNmd_kdn(e)
{	cur_kc = (!iNmd_is_ie) ? e.which : e.keyCode ;
	var	oInput = e.target ? e.target : e.srcElement;

	if (oCellEdit && (oCellEdit != oInput)) oCellEdit = null;
	
	if (cur_kc == 112+8)	/* F8 */
	{	iNmd_Send('RENEW');
		e.returnValue = false;
		return false;
	}
	if (cur_kc == 27)		/* Escape */
	{	AjxSend('C-1999,27');
		if (window.event) e.returnValue = false;
		return false;
	}		
	
	/* Function keys */
	
	if ((e.altKey) && (cur_kc >= 112) && (cur_kc <= 123))
	{	cur_kc -= 111;
		if (oCellEdit)
		{	iNmd_CellEdtEnd(240 + cur_kc);
		}
		else
		if (oChg)
		{	var sVal = iNmd_Val(oFcs);

			oFcs.in_oldval = sVal;
			AjxSend('C' + sFcsId + ',' + (128 + cur_kc) + sVal, 1);
		}
		
		AjxSend('K' + cur_kc,0);
		return i_IgnEvent(e)
	}		

	if ((cur_kc >= 16) && (cur_kc <= 19)) return true;	/* Ctrl/Alt/Shft/pause keys */

	if (bAndroid && (cur_kc == 0))
	{	if (oCellEdit)
		{	if (oCellEdit.readOnly) return true;
			oCellEdit.in_Chged = true;
			oCellEdit.parentNode.setAttribute("data-sts","E");
		}
		else
		{	if (oFcs.readOnly) return true;
			oChg = oFcs;
		}
		return true;
	}

	if (oCellEdit)
	{	if (oCellEdit.parentNode.in_Dbx)
		{	if (iGdDbxKdn(cur_kc)) return false;
		}

		if (!oCellEdit.in_Chged)
		{	if (oCellEdit.parentNode.getAttribute("data-sts") == "E")
			{	if ((cur_kc == 37) && ('selectionStart' in oCellEdit)) oCellEdit.selectionStart = oCellEdit.value.length;
				if ((cur_kc == 37) || (cur_kc == 39))
				{	oCellEdit.in_Chged = true;
					return true;			/* Left right after Enter */
				}
			}
			
			if (cur_kc == 13 && e.shiftkey) cur_kc = 10;	/* Change CR to LF */
			
			if (oFcs.in_enterMode && (cur_kc == 13)) return iNmd_CmnKdn(e);
			if ((cur_kc >= 37) && (cur_kc <= 40)) return iNmd_CmnKdn(e);	/* Arrow keys */
			if ((cur_kc == 33) || (cur_kc == 34)) return iNmd_CmnKdn(e);	/* Pgup/PgDn keys */
			if ((cur_kc == 9) || (cur_kc == 27)) return iNmd_CmnKdn(e);		/* Tab/Esc keys */
			if ((cur_kc == 35) || (cur_kc ==36)) return iNmd_CmnKdn(e);		/* Ctrl Home/End */

			if (oCellEdit.readOnly)	/* Space on a Check box */
			{	if ((cur_kc == 32) || (cur_kc == 13))
				{	var sId= oCellEdit.parentNode.id.substr(3);
					AjxSend('S' + sId.substr(0,5) + ',Btn:' + sId.substr(6), 0);
				}
				return i_IgnEvent(e);
			}

			if ((cur_kc == 2213) || (cur_kc == 45) || (cur_kc == 13) )							/* Enter/Ins */
			{	if (oCellEdit.in_Val) oCellEdit.value = oCellEdit.in_Val;
				
				oCellEdit.parentNode.setAttribute("data-sts","E");
				oCellEdit.select();
				oCellEdit.in_Chged = true;
				return i_IgnEvent(e);
			}
			return true;
		}

		if ((cur_kc == 9) || (cur_kc == 27) || (cur_kc == 38)|| (cur_kc == 40))
		{	iNmd_CellEdtEnd(cur_kc, e.shiftKey);
			return i_IgnEvent(e);
		}

		return true;
	}

	if (oFcs.readOnly) return true;
		
	if (oFcs._null_showing)
	{	oFcs.value = '';
		oFcs._null_showing = false;
	}

	if (oFcs.in_auto || oFcs.in_NullChg)
	{	oFcs.in_autopend = true;
		setTimeout(iNmd_Auto,50);
		return true;
	}
	
	if ((cur_kc == 8) || (cur_kc == 46)) oChg = oFcs;

	if (cur_kc == 9)
	{	return iNmd_KdnChkTab(e);
	} 

	return true;
}

function iNmd_kdn_FMT(e)
{	if (!iNmd_kdn(e)) return false;
	
	sFmt = oFcs.in_fmt;
	if (!sFmt || sFmt == '') return true;
	
	if (cur_kc == 46)
	{ cur_kc = 127;
	}
	else
	if (cur_kc != 8) 
		return true;

	if (iNmd_fmtchr(e, cur_kc)) return true;
	
	if (window.event) e.returnValue = false;
	return false;
}

// Keypress events

function iNmd_key(e)
{	var cNew = (!iNmd_is_ie) ? e.which : e.keyCode ;

	if (oCellEdit)
	{	if (oCellEdit.parentNode.in_Dbx) return false;
		if (oCellEdit.readOnly) return false;
		
		if (!oCellEdit.in_Chged)
		{	oCellEdit.in_Chged = true;
			oCellEdit.parentNode.setAttribute('data-sts','E');
		}

		if ((oCellEdit.type == 'textarea') && (cNew == 13) && (e.shiftKey)) cNew = 10;
		
		if (cNew == 13)
		{	iNmd_CellEdtEnd(13, e.shiftKey);
			return i_IgnEvent(e);
		}

		if (oCellEdit.parentNode.getAttribute('data-num') && (cNew >= 32))
		{	if (!iNmd_IsNumeric(oCellEdit, String.fromCharCode(cNew))) return i_IgnEvent(e);
		}
	}
	else
	if (oFcs.readOnly) return false;
	
	if ((cNew >= 32) && (cNew != 127)) oChg = oFcs;
		
	if ((oFcs.type) && (oFcs.type == 'textarea')) 
	{	oChg = oFcs;
		return true;
	}
	
	if (cNew == 13)
	{	if (iNmd_Valid())
		{	if (iNmd_is_ie) iNmd_IE_deselect();
		
			var sVal = iNmd_Val(oFcs);
			oChg = null;
			oFcs.in_oldval = sVal;

			if(oFcs.in_fmt) sVal = i_StpFmt(oFcs, sVal);
			AjxSend('C' + sFcsId + ',13' + sVal, 1);
		}
		return i_IgnEvent(e);		
	}

	return true;
}

function iNmd_IsNumeric(oFld, sNewCh)
{	var sVal;

	sVal = "+-0123456789" + chCurrency + chThousand + chDecimal;
	if (sVal.indexOf(sNewCh) == -1) return false;

	sVal = oFld.value;	
	var nStrt = oFld.selectionStart;
	var nLeng = oFld.selectionEnd - nStrt;

	sVal = sVal.substring(0, nStrt) + sNewCh + sVal.substring(nStrt + nLeng, sVal.length);

	var bComma = false;
	var bDecimal = false;
	var bCurrency = false;
	var bSign = false;
	var nLen = sVal.length;
	var nOfs = 0;
	var nStage = 0;			/* 0 = before digtis; 1=digits/comma/decimal; 2=After */

	for (;nOfs < sVal.length;nOfs++)
	{	sNewCh = sVal.charAt(nOfs);

		if ((nStage == 0) || (nStage == 2))
		{	if ((sNewCh == chCurrency) && !bCurrency)
			{	bCurrency = true;
				continue;
			}
			if (((sNewCh == '+') || (sNewCh == '-')) && !bSign)
			{	bSign = true;
				continue;
			}
			
			if (nStage == 2) return false;
			nStage = 1;
		}

		if (sNewCh == chThousand) continue;
		if ((sNewCh == chDecimal) && !bDecimal)
		{	bDecimal = true;
			continue;
		}
		if ((sNewCh >= '0') && (sNewCh <= '9')) continue;
		nOfs--;
		nStage++
	}

	return true;
}



function iNmd_key_FMT(e)
{	if (!iNmd_key(e)) return false;
	if (!sFmt || sFmt == '') return true;
	
	var cNew = (!iNmd_is_ie) ? e.which : e.keyCode ;

	if (cNew != 8)
	{	if (iNmd_fmtchr(e, cNew)) return true;
	}

	if (window.event) e.returnValue = false;
	return false;
}

function iNmd_Full(oInp)
{	if (sFullVal == oInp.value) return;
	sFullVal = oInp.value; 
	
	if (sFullVal.length == oInp.maxLength)
	{	iNmd_Chg(oInp);
		oInp.in_oldval = iNmd_Val(oInp);
		if (oInp.in_sigexit != 1) oChg = null;
	}
}

function iNmd_Menu(e, nCtl)
{	if (window.event) e = window.event;
	iNmd_MseXY(e);

	if (oChg != null)
	{	iNmd_Chg(oChg);
	}

	if (nCtl)
	{	AjxSend('C' + nCtl + ',0', 0);
	}
	else
	{	var sId = sMseId.substr(3);
		var nOfs = sId.indexOf('_');
		if (nOfs == -1)
			iNmd_Signal(sId, 'RClk:' );
		else
			iNmd_Signal(sId.substring(0, nOfs), 'RClk:' + sId.substr(nOfs+1));
	}

	if (bRClick) i_RClk(null);
	return i_IgnEvent(e);
}
	
function iNmd_Spin(nCtl, e)
{	if (window.event) e = window.event;
	var oSpin =  e.target ? e.target : e.srcElement;
	
	if (oSpin && !oSpin.disabled)
	{	var oObj = i_Id(oSpin.getAttribute('iML'));
		if (oObj && !oObj.disabled)
		{	if (iNmd_is_ie) oSpin.ondblclick = Function('iNmd_Spin(' + nCtl + ',event);');
			
			if (oObj != oFcs) iNmd_focus(oObj);
			oObj.focus();
			
			AjxSend('S' + nCtl + ',' + oSpin.className.substr(5));
		}

	}
	return e.returnValue = false;
}
	
function iNmd_BtnDClk()
{ var e = window.event;
  var oBtn =  e.target ? e.target : e.srcElement;
  var sId = oBtn.id.substr(3);

  if (window.event) e.returnValue = false;    
  if (AjxSend('C' + sId + ',2', 1)) return false;
  iNmd_Submit(sId);
  return false;
}

function iNmd_BtnFcs(e)
{	var oBtn = null;
	if (window.event) e = window.event;
	if (e)
		oBtn =  e.target ? e.target : e.srcElement;
	
	if (!oBtn) return false;

	oBtn.onkeydown = iNmd_KdnChkTab;
	oBtn.onkeypress = iBtnKey;

	var sSts = oBtn.getAttribute('data-bt-sts');
	if (sSts && (sSts.indexOf("S") != -1)) return;

	if (!bFireFox) iNmd_focus(oBtn);
}

function iBtnKey(e)
{	if (window.event) e = window.event;
	var chKey = (!iNmd_is_ie) ? e.which : e.keyCode ;
	
	if (chKey == 13) 
	{	var oBtn =  e.target ? e.target : e.srcElement;
		if (!oBtn.id) oBtn = oBtn.parentNode;
		
		AjxSend('C' + oBtn.id.substr(3) + ',0', 0);
		return e.returnValue = false;
	}
	return true;
}

function iDivBkg(oDiv, sBkg)
{	if (oDiv.style.backgroundImage != sBkg) oDiv.style.backgroundImage = sBkg;
}

function iNmd_BtnX(e, oBtn)
{	if (!oBtn.disabled) AjxSend('C' + oBtn.id.substr(3) + ',88', 0);
	return i_IgnEvent();
}

function iNmd_BtnClk(e)
{	var oBtn = null;
	if (window.event) e = window.event;
	if (e) oBtn =  e.target ? e.target : e.srcElement;
		
	if (iNmd_BtnClk.arguments.length == 2) 
		oBtn = iNmd_BtnClk.arguments[1];

	if (!oBtn) return i_IgnEvent(e);

	if (!oBtn.id) oBtn = oBtn.parentNode;

	if ((oBtn.disabled) || (oBtn.className.substr(oBtn.className.length - 3) == 'Dis') || (oBtn.szrType))
	{	oBtn.szrType = null;
		return i_IgnEvent(e);
	}

	var sUrl = oBtn.getAttribute("data-URL");

	if (sUrl)
	{	bIgnUnload2 = true;
		window.location = sUrl;
		return i_IgnEvent(e);
	}

	if (e) iNmd_MseXY(e);

	var sSts = oBtn.getAttribute('data-bt-sts');
	if (sSts && (sSts.indexOf("S") != -1))
	{	if (oChg) iNmd_Chg(oChg, 'U');
	}
	else
	{	if (oFcs != oBtn) iNmd_focus(oBtn);
		if (oBtn.focus)
		{	try { oBtn.focus(); } catch(err) { }
		}
	}

	var sId = oBtn.id.substr(3);

	if (iNmd_is_ie) oBtn.ondblclick = iNmd_BtnDClk; 
	
	var sEom = '1';
	if (oBtn.in_eom)
	{	sEom = oBtn.in_eom;
		oBtn.in_eom = 0;
	}
	
	if (AjxSend('C' + sId + ',' + sEom, 0))
	{	if (oFcs && oFcs.focus)
		{	try { oFcs.focus(); }
			catch(err) { } 
		}
	}
	else
	{	iNmd_Submit(sId);
	}

	return i_IgnEvent(e);
}

/* Sizer Button */
var oSzr;

function iSzrDown(e, szrType, szrMin, szrMax)
{	if (window.event) e = window.event;
	if (e) oSzr =  e.target ? e.target : e.srcElement;
	
	while (!oSzr.id)
	{	oSzr = oSzr.parentNode;
	}

	iNmd_MseXY(e);
	
	nMseDwnX = nMseX;
	nMseDwnY = nMseY;

	var rcPanel = i_Id('id_Panel').getBoundingClientRect();
	oSzr.szrMinH = oSzr.szrMinV = 0;
	oSzr.szrMaxV = rcPanel.height - oSzr.offsetHeight;
	oSzr.szrMaxH = rcPanel.width - oSzr.offsetWidth;

	oSzr.szrType = szrType;

	if (szrMax > szrMin)
	{	if (szrType == 'H')
		{	oSzr.szrMinH = szrMin;
			oSzr.szrMaxH = szrMax;
		}

		if (szrType == 'V')
		{	oSzr.szrMinV = szrMin;
			oSzr.szrMaxV = szrMax;
		}
	}

	oSzr.szrZ = oSzr.parentNode.style.zIndex;
	oSzr.parentNode.style.zIndex = 50;

	oSzr.szrTop = parseInt(oSzr.parentNode.style.top, 10);
	oSzr.szrLeft = parseInt(oSzr.parentNode.style.left, 10);

	if (e.type == 'touchstart')
	{	i_AddEvent(window, 'touchmove', iSzrMove, true);
		i_AddEvent(window, 'touchend', iSzrUp, true);
	}
	else
	{	i_AddEvent(window, 'mousemove', iSzrMove, true);
		i_AddEvent(window, 'mouseup', iSzrUp, true);
	}

	oSzr.szrMoved = false;
	return i_IgnEvent(e);
}

function iSzrMove(e)
{	if (window.event) e = window.event;
	iNmd_MseXY(e);

	var top, left;	
	var diffX, diffY;

	diffX = nMseX - nMseDwnX;
	diffY = nMseY - nMseDwnY;
 
	left =  diffX + oSzr.szrLeft;
	if (left < oSzr.szrMinH) left = oSzr.szrMinH;
	if (left > oSzr.szrMaxH) left = oSzr.szrMaxH;

	top = diffY + oSzr.szrTop;
	if (top < oSzr.szrMinV) top = oSzr.szrMinV;
	if (top > oSzr.szrMaxV) top = oSzr.szrMaxV;
		
	if ((oSzr.szrType == 'B') && (oSzr.szrMoved == false))
	{	if ((Math.abs(diffX) < 4) && (Math.abs(diffY) < 4)) return i_IgnEvent(e);

		oSzr.szrMoved = true;
		oSzr.setAttribute('data-bt-move','Y');
	}

	/* If not vertcial then set horizontal, if not horiz adjust vertical */

	if (oSzr.szrType != 'V') oSzr.parentNode.style.left = left + 'px';
	if (oSzr.szrType != 'H') oSzr.parentNode.style.top = top + 'px';

	return i_IgnEvent(e);
}

function iSzrUp(e)
{	if (window.event) e = window.event;

	if (e.type == 'touchend')
	{	i_RmvEvent(window, 'touchmove', iSzrMove, true);
		i_RmvEvent(window, 'touchend', iSzrUp, true)	
	}
	else
	{	i_RmvEvent(window, 'mousemove', iSzrMove, true);
		i_RmvEvent(window, 'mouseup', iSzrUp, true);
	}

	var top, left;
	left = parseInt(oSzr.parentNode.style.left, 10);
	top = parseInt(oSzr.parentNode.style.top, 10);

	var sId = oSzr.id.substr(3);

	if ((oSzr.szrType == 'B') && (oSzr.szrMoved == false))
	{	AjxSend('C' + sId + ',1', 0); 
	}
	else
	{	iNmd_Signal(sId, 'Szr:' + oSzr.szrType + ":" + left + ":" + top);
		oSzr.removeAttribute('data-bt-move');
	}

	oSzr.parentNode.style.zIndex = oSzr.szrZ;
	oSzr = null;

	return i_IgnEvent(e);
}

/* Check box */

function iNmd_CbxFcs(oCbx)
{	oCbx.onkeydown = iNmd_KdnChkTab;
	oCbx.onclick = iNmd_CbxEvt;
	oCbx.onkeypress = iNmd_CbxEvt;

	if ((oFcs != oCbx) && (!bFireFox)) iNmd_focus(oCbx);
	return true;
}

function iNmd_CbxEvt(e)
{	if (window.event) e = window.event;
	var oCbx = e.target ? e.target : e.srcElement;

	while (oCbx)
	{	if (oCbx.id) break;
		oCbx = oCbx.parentNode;
	}
	if (!oCbx) return;
	
	if (oCbx.disabled) return e.returnValue = false;
	
	if (oCbx != oFcs) iNmd_focus(oCbx);
	if (oCbx.focus) oCbx.focus();

	if (e.type == 'keypress')
	{	var cKey = iKey(e);
	
		if (cKey != 13) return true;
		AjxSend('C,13');
	
		return e.returnValue = false;
	}	
	
	var oVal;
	var sVal;

	oVal = i_Id('v' + oCbx.id);
	sVal = oVal.value;

	if (sVal == '0')
	{	sVal = '1';
	}
	else
	if (sVal == '2')
	{	sVal = '0';
	}
	else
	if (oVal.in_type == '3') 
	{	sVal = '2';
	}
	else
	{	sVal = '0';
	}

	iNmd_CbxChg(oCbx, sVal, oVal);
	AjxSend('C' + oCbx.id.substr(3) + ',1:' + sVal, 0);
	
	if (oCbx.type && (oCbx.type == 'checkbox')) return true;
	return i_IgnEvent(e);
}

function iNmd_CbxSet(idCbx, sVal)
{	var oVal;
	var oCbx;

	oCbx = i_Id(idCbx);
	oVal = i_Id('v' + idCbx);

	if (!oVal) { alert("Cannot find: v" + idCbx); return; }

	iNmd_CbxChg(oCbx, sVal, oVal);
}

function iNmd_CbxChg(oCbx, sVal, oVal)
{	oVal.value = sVal;

	if (oCbx.nodeName == 'BUTTON')
	{	oCbx.setAttribute("data-cb-s", sVal);

		if (oVal.in_h0)
		{	if (sVal == '0')
				oCbx.innerHTML = oVal.in_h0;
			else
			if (sVal == '1')
				oCbx.innerHTML = oVal.in_h1;
			else
				oCbx.innerHTML = oVal.in_h2;
		}
		else
		{	if (sVal == '0')
				oCbx.innerHTML = sCbxCssVal0;
			else
			if (sVal == '1')
				oCbx.innerHTML = sCbxCssVal1;
			else
				oCbx.innerHTML = sCbxCssVal2;
		}
	}
	else
	{	if (sVal == '0')
			oCbx.checked = false;
		else
			oCbx.checked = true;
	}
	
	oTbl = i_Id('grp' + oCbx.id.substr(2));
	if (oTbl) oTbl.setAttribute("data-cb-s", sVal);
	return;
}

/* List/Drop box */

function iNmd_LbxFcs(oLbx)
{	if (oLbx.size)
		oLbx.onkeydown = iNmd_KdnChkTab;
	else
		oLbx.onkeydown = iNmd_LbxEvt;
	
	oLbx.onkeypress = iNmd_LbxEvt;
	oLbx.onmouseup = iNmd_LbxEvt;
	
	if (oFcs == oLbx) return true;

	if (bFireFox) var sOld = oLbx.in_oldval;
	iNmd_focus(oLbx);

	if (bFireFox) 
	{	oLbx.in_oldval = sOld;
		
		if (oLbx.in_auto)
		{	oLbx.in_autopend = true;
			setTimeout(iNmd_Auto,50);
		}
	}
}

function iNmd_LbxEvt(e)
{	if (window.event) e = window.event;
	var oLbx = (e.target ? e.target : e.srcElement);
	if (!oLbx.id) oLbx = oLbx.parentNode;

	if (oLbx != oFcs) return e.returnValue = false;
	
	if (e.type == 'keydown')
	{	oLbx.in_autopend = true;
		setTimeout(iNmd_Auto,50);
		return iNmd_KdnChkTab(e);
	}

	var bSts = true;
		
	if (e.type == 'keypress')
	{	var cKey = iKey(e);
		if (cKey == 13)
		{	var sVal = iNmd_Val(oLbx);
			oChg = null;

			oLbx.in_oldval = sVal;
			AjxSend('C' + oLbx.id.substr(3) + ',13' + sVal,0);

			bSts = false;
		}
		else
		if (cKey == 9)
		{	return e.returnValue = false;
		}	
	}

	if ((oLbx.in_auto) || (!oLbx.size))
	{	oLbx.in_autopend = true;
		setTimeout(iNmd_Auto,50);
	}
	else
	if ((e.type == 'mouseup') && (oLbx.value))
	{	if (oLbx.in_dbltmr)
		{	var sVal = iNmd_Val(oLbx);
			oChg = null;
			oLbx.in_oldval = sVal;
			AjxSend('C' + oLbx.id.substr(3) + ',2' + sVal,0);
			oLbx.in_dbltmr = false;
		}
		else
		{	oLbx.in_dbltmr = true;
			setTimeout(function () { oLbx.in_dbltmr = false; }, 500);
		}
	}
					
	return e.returnValue = bSts;
}
  
function iNmd_LbxClr(idLbx)
{	var oLbx = i_Id(idLbx);
	if (!oLbx) { alert("LbxClr: Cant find-" + idLbx); return; }

	if (oLbx.getAttribute("data-ipadEmul"))	
	{	var oList = i_Id('ip_' + oLbx.id.substr(3));
		if (oList) oList.innerHtml = "";
	}
	else
	{	oLbx.length = 0;
	}
}

function iNmd_LbxUpd(idLbx, nIdx, sVal)
{	var oLbx = i_Id(idLbx);
	if (!oLbx) { alert("LbxUpd: Cant find-" + idLbx); return; }

	if (oLbx.getAttribute("data-ipadEmul"))	
	{	var oList = i_Id('ip_' + oLbx.id.substr(3));
		oList.children[nIdx-1].innerText = sVal;
	}
	else
	{	if (oLbx.type == 'text') oLbx = i_Id('vdl_' + idLbx.substr(3));
		oLbx.options[nIdx-1].text = sVal;
	}
}

function iNmd_LbxDel(idLbx, nIdx)
{	var oLbx = i_Id(idLbx);
	if (!oLbx) { alert("LbxDel: Cant find-" + idLbx); return; }

	if (oLbx.getAttribute("data-ipadEmul"))	
	{	var oList = i_Id('ip_' + oLbx.id.substr(3));
		if (nIdx <= oList.children.length) oList.children[nIdx-1].remove();
	}
	else
	{	if (oLbx.type == 'text') oLbx = i_Id('vdl_' + idLbx.substr(3));

		oLbx.remove(nIdx-1);

		while (nIdx < oLbx.length)
		{	oLbx.options[nIdx].value = (nIdx + 1).toString(10);
			nIdx++;
		}
	}

	oLbx.in_oldval = iNmd_Val(oLbx);
}

function iNmd_LbxAdd(idLbx, nIdx, sVal)
{	var oLbx = i_Id(idLbx);
	var oOpt;
	var sIdx;

	if (!oLbx) { alert("LbxAdd: Cant find-" + idLbx); return; }

	if (oLbx.getAttribute("data-ipadEmul"))	
	{	var oList = i_Id('ip_' + oLbx.id.substr(3));
		var oDiv = document.createElement('div');
		oDiv.innerText = sVal;

		oList.insertBefore(oDiv, oList.children[nIdx-1]);
		
		oLbx.in_oldval = iNmd_Val(oLbx);
		return;
	}

	if (oLbx.type == 'text') oLbx = i_Id('vdl_' + idLbx.substr(3));

	if (nIdx > oLbx.length) { alert("Index invalid:" + idLbx + "," + nIdx); return; }

	if (nIdx == 0) 
		sIdx = (oLbx.length + 1).toString(10);
	else
		sIdx = nIdx.toString(10);
	    
	oOpt = new Option(sVal, sIdx);

	if (iNmd_is_ie)
	{	if (nIdx == 0)
			oLbx.add(oOpt);
		else
			oLbx.add(oOpt, nIdx-1);
	}
	else
	{	if (nIdx == 0)
			oLbx.add(oOpt, null);
		else
			oLbx.add(oOpt, oLbx.options[nIdx-1]);
	}

	while (nIdx < oLbx.length)
	{	oLbx.options[nIdx].value = (nIdx + 1).toString(10);
		nIdx++
	}

	oLbx.in_oldval = iNmd_Val(oLbx);
	return;
}

function iNmd_LbxSel(idLbx, sOpts)
{	var nStrt;
	var nFini;
	var nSel;
	var nOfs;
	var nCnt;	
	if (idLbx == '') return;
	
	var oLbx = i_Id(idLbx);
	if (!oLbx) { alert("LbxSel: Cant find-" + idLbx); return; }

	if (oLbx.getAttribute("data-ipadEmul"))	
	{	iPadDbSel(oLbx, sOpts);
		return; 
	}

	nStrt = 0;
	nIdx = 0;
	nCnt = 0;
	
	oLbx.selectedIndex = -1;

	while (1)
	{	nFini = sOpts.indexOf(',', nStrt);
		if (nFini == -1) break;
	    
		nSel = parseInt(sOpts.substring(nStrt, nFini),10) - 1;
		if (nSel > oLbx.length) break;
		
		nCnt++;
		
		if (!oLbx.multiple)
		{	oLbx.selectedIndex = nSel;
			break;
		}

		while (nIdx < nSel)
		{	oLbx.options[nIdx++].selected = false;
		}

		if (nIdx == nSel) oLbx.options[nIdx++].selected = true;
		nStrt = nFini + 1;
	}

	if ((nCnt == 1) && (oLbx.size > 1))
	{	if (iNmd_is_ie || oLbx.multiple)
			setTimeout(function () {oLbx.scrollTop = Math.floor(oLbx.offsetHeight / oLbx.size) * nSel;}, 100);
	}
	
	oLbx.in_oldval = iNmd_Val(oLbx);
	return;
}
  
function iNmd_LbxLoad(idLbx)
{ 	var oLbx = i_Id(idLbx);

	if (!oLbx) { alert("LbxLoad: Cant find-" + idLbx); return; }

	/* Have to do this here to access all args */

	if (oLbx.getAttribute("data-ipadEmul"))
	{	var oDiv;

		var oList = i_Id('ip_' + oLbx.id.substr(3));
		if (!oList) return;

		oList.innerHTML = '';		/* Clear contents */

		for (var i = 1; i< iNmd_LbxLoad.arguments.length; i++)
		{	oDiv = document.createElement('div');
			oDiv.innerText = iNmd_LbxLoad.arguments[i];
			oList.appendChild(oDiv);
		}

		oLbx.in_oldval = ':';		/* No selections */
		return;
	}

	if (oLbx.type == 'text') oLbx = i_Id('vdl_' + idLbx.substr(3));

	oLbx.length = 0;
	oLbx.selectedIndex = -1;

	var oOpt;
  
	for (var i = 1; i< iNmd_LbxLoad.arguments.length; i++)
	{	oOpt = new Option(iNmd_LbxLoad.arguments[i], i.toString(10));
		if (iNmd_is_ie)
			oLbx.add(oOpt);
		else
			oLbx.add(oOpt, null);
	} 
	
	oLbx.in_oldval = iNmd_Val(oLbx);
}

function iNmd_LbxChg(e)
{	if (window.event) e = window.event;

	var oLbx = (e.target ? e.target : e.srcElement);

	if ((oLbx.in_auto) || (!oLbx.size))
	{	oLbx.in_autopend = true;
		setTimeout(iNmd_Auto,50);
	}
	else
		oChg = oLbx;
		
	return true;
}

/* iPad/iPhone emulated drop boxes */

function iPadDbVal(oLbx)
{	var oList = i_Id('ip_' + oLbx.id.substr(3));
	var oItem;
	var sVal = '';

	if (oList)
	{	var oItems = oList.children;
		for (var i = 0; i < oItems.length;)
		{	oItem = oItems[i++];
			if (oItem.getAttribute('selected')) sVal = sVal + i + ',';
		}
	}
	return sVal;
}

function iPadDbSel(oLbx, sOpts)
{	var oList = i_Id('ip_' + oLbx.id.substr(3));
	var sList = ','+sOpts+',';

	oLbx.value = '';

	if (oList)
	{	var oItems = oList.children;
		for (var i = 0; i < oItems.length;)
		{	oItem = oItems[i++];
			if (sList.indexOf(',' + i + ',') >= 0) 
			{	oItem.setAttribute('selected','1');
				oLbx.value = oItem.innerText;
			}
			else
			{	oItem.removeAttribute('selected');
			}
		}
	}

	oLbx.in_oldval = iNmd_Val(oLbx);
	return;
}

function iPadDbOpen(e, sId)
{	if (window.event) e = window.event;

	var oLbx = i_Id('id_' + sId);
	if (oLbx)
	{	if (oFcs != oLbx) iNmd_focus(oLbx);
	}

	var oList =  i_Id('ip_' + sId);
	if (oList)
	{	oList.style.display = 'block';
		oList.i_Parent = oList.parentNode;
		document.body.appendChild(oList);
	}
	return i_IgnEvent(e);
}

function iPadDbClick(e, sId)
{	if (window.event) e = window.event;
	var oList =  i_Id('ip_' + sId);

	if (oList)
	{	var oItem = (e.target ? e.target : e.srcElement);

		if (oItem != oList)
		{	if (oList)
			{	var oLbx = i_Id('id_'+sId);
				oLbx.value = oItem.innerText;

				oItems = oList.children;
				for (var i = 0; i < oItems.length;i++)
				{	if (oItem == oItems[i])
						oItems[i].setAttribute('selected','1');
					else
						oItems[i].removeAttribute('selected');
				}
								
				oLbx.in_oldval = iNmd_Val(oLbx);
				AjxSend('C' + sId + ',1' + oLbx.in_oldval);
			}
		}
	
		if (oList)
		{	oList.style.display = 'none';
			oList.i_Parent.appendChild(oList);
		}
	}
	return i_IgnEvent(e);
}

/* Radio Buttons */

function iNmd_RbtFcs(oBtn)
{	oBtn.onkeydown = iNmd_RbtEvt;
	oBtn.onkeypress = iNmd_RbtEvt;

	if (oFcs == oBtn) return true;
	iNmd_focus(oBtn);
	
	return true;
}

function iNmd_RbtEvt(e)
{	if (window.event) e = window.event;
	var oBtn = e.target ? e.target : e.srcElement;

	while (oBtn)
	{	if (oBtn.id) break;
		oBtn = oBtn.parentNode;
	}
	
	if (oBtn.disabled) return e.returnValue = false;
	
	if (oFcs != oBtn) iNmd_RbtFcs(oBtn);
	if (oBtn.focus) oBtn.focus();

	if (e.type == 'keydown') 
	{	return iNmd_RbtKdn(oBtn,e);
	}
	
	if (e.type == 'keypress')
	{	var cKey = iKey(e);
	
		if (cKey != 13) return true;
		AjxSend('C,13');
	
		return e.returnValue = false;
	}	
	
	var sId;
	var sVal;
	var nOfsScore;

	if (oBtn.getAttribute('data-rb-s') == '1') return e.returnValue = false;

	sId = oBtn.id.substr(3);
	nOfsScore = sId.indexOf('_',0);

	sVal = sId.substr(nOfsScore + 1);
	sId = sId.substring(0, nOfsScore);


	iNmd_RbtSet(sId, sVal);
	AjxSend('C' + sId + ',1:' + sVal, 0);

	if (bSafari || (oBtn.nodeName == 'BUTTON'))
	{	if (e.stopPropagation) e.stopPropagation();
		if (e.preventDefault) e.preventDefault();
		return e.returnValue = false;
	}
}

function iNmd_RbtKdn(oBtn, e)
{	var	cKey = iKey(e);
	var nDir;

	if ((cKey == 37) || (cKey == 38))
		nDir = -1;
	else
	if ((cKey == 39) || (cKey == 40))
		nDir = 1;
	else
		return iNmd_KdnChkTab(e);

	var nOfs = oBtn.id.indexOf('_', 4);
	if (nOfs < 0) return true;

	sId = oBtn.id.substr(0,nOfs+1);	
	nOfs = parseInt(oBtn.id.substr(nOfs+1,10));

	while (1)
	{	nOfs += nDir;
		oBtn = i_Id(sId + nOfs);
		if (!oBtn) break;
		if (!oBtn.disabled)
		{	if (oBtn.focus) oBtn.focus();
			break;
		}
	}
	return e.returnValue = false;		
}
	
function iNmd_RbtSet(sId, sVal)
{	var oBtn;
	var oRbt;
  
	oRbt = i_Id('id_' + sId);
	if (!oRbt) { alert('RbtSet: Cant find-id_'+sId); return; }
  
	if (oRbt.value != '')
	{	oBtn = i_Id('rb_' + sId + '_' + oRbt.value);
		if (oBtn)
		{	if (oBtn.in_h0)
			{	oBtn.setAttribute('data-rb-s', '0');
				oBtn.innerHTML = oBtn.in_h0;
			}
			else
			{	oBtn.checked = false;
			}
		}
	}
	
	if (sVal == 0) sVal = "";
	oRbt.value = sVal;
  
	if (sVal == "") return;
  
	oBtn = i_Id('rb_' + sId + '_' + sVal);
	if (!oBtn) { alert('RbtSet: Cant find rb_' + sId + '_' + sVal); return; }
 
	if (oBtn.in_h1)
	{	oBtn.setAttribute('data-rb-s', '1');
		if (oBtn.in_h1) oBtn.innerHTML = oBtn.in_h1;
	}
	else
	{	oBtn.checked = true;
	}
}

function iNmd_RbtVal(oBtn)
{ var sId;
 
  sId = oBtn.id.substr(3);
  sId = 'id_' + sId.substring(0, sId.indexOf('_',0));
  
  return i_Id(sId);
}

var sDbx_id;
var sDbx_val;

function iNmd_DbxClk(e)
{	if (window.event) e = window.event;
	if (bRClick) return i_IgnEvent(e);
	
	var oFld = (e.target ? e.target : e.srcElement);
	if (oFld)
	{	var bInDbx = true;

		if (oFld.id == "") bInDbx = false;
		if (e.offsetY && ((e.offsetY < 0) || (e.offsetY > oFld.offsetHeight))) bInDbx = false;

		if (bInDbx)
		{	sDbx_id = oFld.id;
			sDbx_val = oFld.value;
		}
		else
		{	setTimeout(iNmd_DbxChg, 100);
		}
	}
	return true;
}

function iNmd_DbxChg()
{	var oDbx = i_Id(sDbx_id);
	if (oDbx && (oDbx.value == sDbx_val)) AjxSend('C' + sDbx_id.substr(3) + ',1:' + oDbx.value);
}

/* Variable LIST box (Emulated) */

function iNmd_VlbEvt(e)
{	if (window.event) e = window.event;
	var oList = (e.target ? e.target : e.srcElement); 
	
/*	if (e.type == 'click')
	{	document.inomads._eom.value = '\x01';
		return true;
	}
*/	
	while(oList)
	{	if (oList.id) break;
		oList = oList.parentNode;
	}
	
	if (oList.selectedIndex == -1) return true;

	var sId = oList.id.substr(4);
	var oLbx = i_Id('id_' + sId);

	oLbx.value = oList.options[oList.selectedIndex].text;
	iNmd_Chg(oLbx);

	if ('selectionStart' in oLbx)
	{	oLbx.selectionStart = 0;
		oLbx.selectionEnd = oLbx.value.length;
	}
	else
	if (document.selection)
	{	var oRng = document.selection.createRange();
		{	if (oRng)
			{	oRng.moveStart("character", -100000);
				oRng.moveEnd("character", 100000);
				oRng.select();
			}
		}
	}
	return true;
}

/* Variable DROP box (Emulated) */

function iNmd_VdbShow(oImg)
{	var sId = oImg.id.substr(3);
	var oList = i_Id('vdl_' + sId);

	if (!oList) { alert('Unable to find: vdl_' + sId); return false; }

	var oDbx = i_Id('id_' + sId);
	if (oDbx.disabled) return false;

	if (oList.style.display != 'block')
	{	var wd;
		var oText = i_Id('spn_' + sId);
		
		iNmd_focus(oDbx);
		
		wd = oText.offsetWidth;
		
		if (!oList.i_div)
		{	oList.i_div = oText.parentNode;
			oList.i_zIndex = oList.i_div.style.zIndex;
		}
		oList.i_div.style.zIndex = oList.i_zIndex + 5;
		
		oList.style.top = (oText.offsetHeight + 1) + 'px';
		oList.style.left = 0;
		
		if (oList.offsetWidth < wd) oList.style.width = wd + 'px';
	
		oList.style.display = 'block';
		
		oList.onblur = iNmd_VdbEvt;
		oList.onchange = iNmd_VdbEvt;
		oList.onkeypress = iNmd_VdbEvt;
		oList.onclick = iNmd_VdbEvt;

		oList.tabIndex = oDbx.tabIndex;
		oDbx.tabIndex = 0;

		oList.focus();
	}
	else
	{	oList.style.display = 'none';
		if (oList.i_div) oList.i_div.style.zIndex = oList.i_zIndex;
		
		oDbx.tabIndex = oList.tabIndex;
		oList.tabIndex = 0;
		 
		oDbx.focus();
	}
	
	return false;
}

function iNmd_VdbEvt(e)
{	if (window.event) e = window.event;
	var oList = (e.target ? e.target : e.srcElement); 
	if (oList.style.display == 'none') return;
	
	if (e.type == 'keypress')
	{	var cKey = (!iNmd_is_ie) ? e.which : e.keyCode;
		if (cKey == 9) document.inomads._eom.value = '\t';
		if (cKey != 13) return true;
		
		document.inomads._eom.value = '\r'; 
	}
	
	if (e.type == 'click')
		document.inomads._eom.value = '\x01';
	
	while(oList)
	{	if (oList.id) break;
		oList = oList.parentNode;
	}
	
	var sId = oList.id.substr(4);
	var oDbx = i_Id('id_' + sId);

	if (oList.selectedIndex >= 0)
	{	oDbx.value = oList.options[oList.selectedIndex].text;
	
		if (e.type == 'change')
		{	if (oDbx.in_auto)
			{	oDbx.in_autopend = true;
				setTimeout(iNmd_Auto,50);
			}
			return true;
		}
	}
	else
	{	if (e.type == 'change') return true;
	}

	oDbx.tabIndex = oList.tabIndex;
	oList.tabIndex = 0;
	
	oList.style.display = 'none';
	if (oList.i_div) oList.i_div.style.zIndex = oList.i_zIndex;
	
	iNmd_Chg(oDbx);
	
	if (document.inomads._eom.value != '\t') oDbx.focus();

	if ('selectionStart' in oDbx)
	{	oDbx.selectionStart = 0;
		oDbx.selectionEnd = oDbx.value.length;
	}
	else
	if (document.selection)
	{	var oRng = document.selection.createRange();
		{	if (oRng)
			{	oRng.moveStart("character", -100000);
				oRng.moveEnd("character", 100000);
				oRng.select();
			}
		}
	}

	if (e.type == 'keypress')
		return e.returnValue = false;
		
	return true;
}

function iNmd_VdbKdn(e)
{ var cur_kc = (!iNmd_is_ie) ? e.which : e.keyCode ;

  if (cur_kc == 40)
  { iNmd_VdbShow(oFcs);

    if (window.event) e.returnValue = false;
    return false;
  }
  
  return iNmd_kdn(e);
}

/* List view specifics */

function iNmd_LvuFcs(oLbx)
{	iNmd_focus(oLbx);

	oLbx.in_blur = iNmd_LvuBlr;
	oLbx.onkeydown = iNmd_LvuKdn;	
	oLbx.onkeypress = iNmd_LvuKey;
	iNmd_LvuRowFcs(oLbx, null);

	return true;
}

function iNmd_LvuRowFcs(oLbx, oRow)
{	var sId = oLbx.id.substr(3);
	i_Id("dv_"+sId).setAttribute('data-fcs', '1');	

	if (oRow && (oRow.getAttribute('data-fcs') == '1')) return;

	iNmd_LvuBlrRow(oLbx);

	if (!oRow)
	{	if (!oLbx.in_fcsId) oLbx.in_fcsId = '1';
		oRow = i_Id('lr_' + sId + '_' + oLbx.in_fcsId);
		if (!oRow) return;
	}

	oRow.setAttribute('data-fcs', '1');
	oLbx.in_fcsId = oLbx.in_fcsNo = oRow.id.substr(9);
}

function iNmd_LvuBlr(oLbx)
{	var sId = oLbx.id.substr(3);
	var oRow = i_Id("dv_"+sId);
	if (oRow) oRow.removeAttribute('data-fcs');

	iNmd_LvuBlrRow(oLbx);
	return;
}
function iNmd_LvuBlrRow(oLbx)
{	if (oLbx.in_fcsNo)
	{	var oRow = i_Id('lr_' + oLbx.id.substr(3) + '_' + oLbx.in_fcsNo);
		if (oRow) oRow.removeAttribute('data-fcs');
		oLbx.in_fcsNo = null;
	}
}

function iNmd_LvuKey(e)
{	if (window.event) e = window.event;
	
	var chKey = iKey(e);
	
	if (chKey != 13)
	{	if ((chKey >= 31) && oFcs.in_fcsId) 
		{	if (oChg)
			{	iNmd_Chg(oChg, 'U');
				oChg = null;
			}
		
			var cFcs = 0;
			cFcs = parseInt(oFcs.in_fcsId,10);
	
			if (cFcs) iNmd_Signal(sFcsId, "Key:" + chKey + "," + cFcs);
		}
		return e.returnValue = false;
	}
	
	var oLbx = e.target ? e.target : e.srcElement;

	var sVal = iNmd_Val(oFcs);
	oChg = null;

	oFcs.in_oldval = sVal;
	if (oFcs.in_fcsId) sVal += '#' + oFcs.in_fcsId;

	AjxSend('C' + sFcsId + ',13' + sVal, 1);
	return e.returnValue = false;
}

function iNmd_LvuKdn(e)
{	if (window.event) e = window.event;
	var oLbx = e.target ? e.target : e.srcElement;

	var cKey = iKey(e);
	if ((cKey == 9) || (cKey == 27)) return iNmd_KdnChkTab(e);
	if (cKey == 13) return true;
	
	if (oLbx.i_Paged) return iNmd_CmnKdn(e);
	
	var cFcs = 0;
	if (oLbx.in_fcsId) cFcs = parseInt(oLbx.in_fcsId,10);
	
	var nFcs = cFcs;
	
	/* Determine number of lines per page */
	var oDiv = i_Id('dv_' + sFcsId);
	
	var rcRow = oDiv.i_dd.getBoundingClientRect();
	var nTop = rcRow.top;
	if (oDiv.i_tr) nTop += oDiv.i_tr.offsetHeight;
	
	rcRow = oDiv.i_dd.getBoundingClientRect();
	var nBtm = rcRow.bottom;
	
	var oRow = i_Id('lr_' + sFcsId + '_' + nFcs);
	if (!oRow) return;
	
	rcRow = oRow.getBoundingClientRect();
	var nRowHi = oRow.offsetHeight;
	
	var nPerPage = Math.floor((nBtm - nTop) / nRowHi);
	var nScroll = oDiv.i_ds.scrollTop;
	var nTopRow = Math.ceil(nScroll / nRowHi) + 1;
	
	switch (cKey)
	{	case 33:	/* PgUp */
			if (nFcs == 1) break;
			if (nFcs == nTopRow)
			{	nFcs -= nPerPage;
				if (nFcs < 1) nFcs = 1;
				nScroll = (nFcs - 1) * nRowHi;
			}
			else
				nFcs = nTopRow;

			break;
			
		case 34:	/* PgDn */
			if (nFcs == oLbx.in_tot) break;
			if (nFcs == (nTopRow + nPerPage -1))
			{	nFcs += nPerPage;
				if (nFcs > oLbx.in_tot) nFcs = oLbx.in_tot;
				nScroll = Math.max(0, nFcs - nPerPage) * nRowHi;
			}
			else
			{	nFcs = (nTopRow + nPerPage -1);
				if (nFcs > oLbx.in_tot) nFcs = oLbx.in_tot;
			}				
			break;

		case 38:	/* Up */
			if (nFcs > 1)
			{	nFcs--;
				if ((rcRow.top - nRowHi) < nTop) nScroll = (nFcs - 1) * nRowHi;
			}
			break;
			
		case 40:	/* Down */
			if (nFcs < oLbx.in_tot)
			{	nFcs++;
				if ((rcRow.bottom + nRowHi) > nBtm) nScroll += nRowHi;
			}
			break;
			
		case 35:	/* End */
			nFcs = oLbx.in_tot;
			nScroll = oDiv.i_ds.scrollHeight - oDiv.i_ds.clientHeight; 
			break;
		case 36:	/* Home */
			nFcs = 1;
			nScroll = 0;
			break;
		
		default:
			return iNmd_CmnKdn(e);
	}

	e.returnValue = false;
	if (e.stopPropagation) e.stopPropagation();
	if (e.preventDefault) e.preventDefault();
	e.cancelBubble = true;
    e.cancel = true;
		 
	if (nFcs > oLbx.in_tot) nFcs = oLbx.in_tot;
	if (nFcs < 1) nFcs = 1;
	if (nFcs == cFcs) return false;

	var sVal;
	var sNo = nFcs;
	oLbx.in_fcsId = sNo;
	
	iNmd_LvuSelInt(oLbx, sNo + ',');
	
	if (oLbx.in_multi && e.shiftKey && oLbx.in_1stFcs)
	{	cFcs = oLbx.in_1stFcs;
		while (cFcs != nFcs)
		{	iNmd_LvuOn(oLbx, cFcs);
			if (cFcs < nFcs)
				cFcs++;
			else
			if (cFcs > nFcs)
				cFcs--;
		}
	}
	else
		oLbx.in_1stFcs = nFcs;
	
	if (oLbx.in_auto)
	{	AjxSend('C' + sFcsId + ',0:' + oLbx.value + '#' + sNo, 1);
	}
	else
	{	oChg = oLbx;
	}
	
	oLbx.in_fcsId = sNo;
	oDiv.i_ds.scrollTop = nScroll;

	iNmd_LvuRowFcs(oLbx, null);

	return false;
}

function iNmd_LvuHdrClk(sId, nCol)
{	if (bHdrResize) return;
	
	iNmd_focus(i_Id('id_' + sId));
	if (oChg) iNmd_Chg(oChg);
	AjxSend('S' + sId + ',Srt:' + nCol,0);
}

function iNmd_LvuClk(oRow, e)
{	var sId;
	var sVal;
	var nOfsScore;
	var bDbl;
	var sVarOld;

	sId = oRow.id.substr(3);
	nOfsScore = sId.indexOf('_',0);

	if (nOfsScore > 0)
	{	sVal = sId.substr(nOfsScore + 1);
		sId = sId.substring(0, nOfsScore);
	}
	else 
	{	sVal = '';
		oRow = null;
	}

	var oLbx = i_Id('id_' + sId);
	if (!oLbx) { alert('Cannot find id_' + sId); return false; };

	if (oLbx.in_clkDone)
	{	oLbx.in_clkDone = false;
		if (window.event) e = window.event; 
		return i_IgnEvent(e);
	}
	
	if (!oLbx.disabled)
	{	var sCol = "";

		if (oFcs != oLbx) iNmd_LvuFcs(oLbx);
		if (!bTouchScrn) oLbx.focus();

		if (window.event) e = window.event; 

		bDbl = false;
			
		if (oRow)
		{	if (iNmd_is_ie)
			{	oRow.ondblclick = Function('return iNmd_LvuClk(this, event);');
				setTimeout('document.selection.empty()', 10);
				if (e.type == 'dblclick') bDbl = true;
			}
			else
			{	bDbl = i_DblClk(oRow);
			}
		}

		if ((e.button > 1) || (bRClick))
		{	if (bDbl) return false;
			sValOld = oLbx.value;
		}

		nOfsScore = sVal.indexOf('_',0);
		if (nOfsScore)
		{	sCol = sVal.substring(nOfsScore);
			sVal = sVal.substring(0,nOfsScore);
			oRow = i_Id('lr_' + sId + '_' + sVal);
		}

		if ((oLbx.in_multi) && (e.ctrlKey || e.shiftKey))
		{	if (e.shiftKey && oLbx.in_fcsId)
			{	var		nFrom, nTo;
				nFrom = parseInt(oLbx.in_fcsId, 10);
				nTo = parseInt(sVal, 10);
				
				sVal = '';
				while (1)
				{	sVal += nFrom + ',';
					if (nFrom == nTo) break;
					if (nFrom < nTo)
						nFrom++;
					else
						nFrom--;
				}
				
				iNmd_LvuSelInt(oLbx, sVal);

				oRow = i_Id('lr_' + oLbx.id.substr(3) + '_' + oLbx.in_fcsId);
			}
			else
			if (oRow.getAttribute('data-sel'))
				iNmd_LvuOff(oLbx, sVal);
			else
				iNmd_LvuOn(oLbx, sVal);
		}
		else
		{	iNmd_LvuSelInt(oLbx, sVal + ',');
			oLbx.in_1stFcs = parseInt(sVal, 10);
		}

		iNmd_LvuRowFcs(oLbx, oRow);

		sVal = oLbx.value;
		
		if (e.button > 1 || bRClick)
		{	if (sVal == sValOld) return false;
		}

		sVal += sCol;
		if (oLbx.in_fcsId) sVal += '#' + oLbx.in_fcsId;
		
		oLbx.in_oldval = null;
		oChg = null;

		if (!bDbl)
		{	if (oLbx.in_auto)
			{	AjxSend('C' + sId + ',1:' + sVal, 0);
			}
			else
			{	document.inomads._eom.value = '\x01';
				oChg = oLbx;
			}
		}
		else
		{	AjxSend('C' + sId + ',2:' + sVal, -1);
		}
	}
	
	if (iNmd_is_ie) 
	{	e.returnValue = false;
		oLbx = oChg;
		iNmd_Goto('id_' + sId,0);
		oChg = oLbx;
		return false;
	}
	
	if (e.stopPropagation) e.stopPropagation();
	if (e.preventDefault) e.preventDefault();
	e.cancelBubble = true;
	e.cancel = true;
	e.returnValue = false;

	return false;
}

function iNmd_LvuOff(oLbx, sVal)
{	var sTxt = ',' + oLbx.value;
	var sTxt2 = sTxt.replace(',' + sVal + ',',',')

	if (sTxt != sTxt2) oLbx.value = sTxt2.substr(1);

	var oRow = i_Id('lr_' + oLbx.id.substr(3) + '_' + sVal);
	if (oRow) oRow.removeAttribute('data-sel');
}

function iNmd_LvuOn(oLbx, sVal)
{	var sTxt = ',' + oLbx.value;
	var sTxt2 = sTxt.replace(',' + sVal + ',',',')

	if (sTxt.indexOf(',' + sVal + ',') < 0) oLbx.value += sVal + ',';

	var oRow = i_Id('lr_' + oLbx.id.substr(3) + '_' + sVal);
	if (oRow) oRow.setAttribute('data-sel', '1');
}

function iNmd_LvuIsOn(oLbx, sVal)
{	var sTxt = ',' + oLbx.value;
	if (sTxt.indexOf(',' + sVal + ',') < 0)
		return false;
	else
		return true;
}

function iNmd_LvuSel(sId, sOpts, nPos, nTot, nVScr, nHScr, bPaged)
{	var oLbx = i_Id(sId);
	if (!oLbx) return;
	oLbx.i_Paged = bPaged;

	var oDiv = i_Id('dv_'+sId.substr(3));
	if (!oDiv.i_dd) iLvInit(oLbx);
	
	if (oDiv.i_ds)
	{	oDiv.i_ds.scrollTop = nVScr;
		oDiv.i_ds.scrollLeft = nHScr;
	}
	
	oLbx.in_tot = nTot; /* Item count */
	
	if (nPos == 0) 
		oLbx.in_fcsId = '1';
	else	
		oLbx.in_fcsId = nPos.toString(10);

	iNmd_LvuSelInt(oLbx, sOpts);

	if (oFcs == oLbx)
	{	iNmd_LvuRowFcs(oLbx, null); 
		oFcs.focus();
	}
	if (bPaged) iLvPgScrl(oDiv, nHScr);
}

function iLvPgScrl(oDiv, nHScr)
{	var nWd = 0;
	var sId = oDiv.id.substr(3);
	var oPc = i_Id('pc_' + sId);
	
	if (oDiv.i_bl) nWd += oDiv.i_bl.offsetWidth;
	if (oDiv.i_br) nWd += oDiv.i_br.offsetWidth;

	oDiv.i_ShftMax = nWd - oDiv.i_dd.clientWidth;
	
	if (oDiv.i_ShftMax <= 0)
	{	oDiv.i_br.style.left = '0px';
		oPc.innerHTML = '&nbsp;';
		return;
	}
	
	oDiv.i_br.style.left = '-' + nHScr + 'px';
	oPc.innerHTML = "<a href='#' id='cf_"+sId+"' onclick='iLvShft(event);'>&#9646;&#9664;</a> " +
					"<a href='#' id='cp_"+sId+"' onclick='iLvShft(event);'>&#9664;</a> " +
					"<a href='#' id='cn_"+sId+"' onclick='iLvShft(event);'>&#9654;</a> " +
					"<a href='#' id='cl_"+sId+"' onclick='iLvShft(event);'>&#9654;&#9646;</a>";
	return;
}
function iLvShft(event)
{	if (window.event) event = window.event;

	var oObj = event.target ? event.target : event.srcElement;
	if (!oObj) return false;

	var oDiv = i_Id('dv_'+ oObj.id.substr(3));
	if (!oDiv) return false;
	
	var nShft = 0-parseInt(oDiv.i_br.style.left,10);
	
	switch (oObj.id.substr(1,1))
	{	case 'f':
			nShft = 0;
			break;
		case 'n':
		case 'p':
			var oCol = oDiv.i_br.firstChild.firstChild;
			var nColStrt = 0;
			var nNxtStrt = 0;
			var nLstStrt = 0;
			while (oCol)
			{	if (oCol.offsetWidth)
				{	nLstStrt = nColStrt;
					nColStrt = nNxtStrt;
					nNxtStrt = nNxtStrt + oCol.offsetWidth;
					if ((nColStrt <= nShft) && (nNxtStrt > nShft)) break;
				}
				oCol = oCol.nextSibling;
			}
			
			if (oObj.id.substr(1,1) == 'n')
				nShft = nNxtStrt;
			else
			if (nShft > nColStrt)
				nShft = nColStrt;
			else
				nShft = nLstStrt;

			break;

		case 'l':
			nShft = oDiv.i_ShftMax;
			break;
	}

	if (nShft < 0) nShft = 0;
	if (nShft > oDiv.i_ShftMax) nShft = oDiv.i_ShftMax;
		
	oDiv.i_br.style.left = '-' + nShft + 'px';
	if (oDiv.i_tr) 
	{	oDiv.i_tr.style.left = '-' + nShft + 'px';
		oDiv.i_tr.style.position = 'relative';
	}
	
	return false;
}

function iNmd_LvuSelInt(oLbx, sOpts)
{	var nOfs;
	var sVal;
	var nStrt = 0;
	var nIdx = 0;
	var nFini;

	while (1)
	{	nOfs = oLbx.value.indexOf(',');
		if (nOfs <= 0) break;
		sVal = oLbx.value.substr(0,nOfs);
		iNmd_LvuOff(oLbx, sVal);
	}
	
	while (1)
	{	nFini = sOpts.indexOf(',', nStrt);
		if (nFini == -1) break; 
		    
		sVal = sOpts.substring(nStrt, nFini);
		if (sVal != '') iNmd_LvuOn(oLbx, sVal);

		nStrt = nFini + 1;
	}
	return;
}  

/* Tree view functions */

function iNmd_TvuImg(e)
{	var oImg = e.target ? e.target : e.srcElement;
	var oRow = i_Id('tx_' + oImg.id.substr(3));
	
	if (oRow)
	{	if (iNmd_is_ie)
		{	if (!oImg.ondblclick)
				oImg.ondblclick = Function('return iNmd_TvuImg(event);');
		}
		return iNmd_TvuClk(oRow, e);
	}

	e.returnValue = false;
	return false;
}

function iNmd_TvuClk(oRow, e)
{	var sId;
	var sVal;
	var nOfsScore;
	var bDbl;
	
	sId = oRow.id.substr(3);
	nOfsScore = sId.indexOf('_',0);

	sVal = sId.substr(nOfsScore + 1);
	sId = sId.substring(0, nOfsScore);

	var oLbx = i_Id('id_' + sId);
	if (!oLbx) { alert('Cannot find id_' + sId); return false; }
	
	if (!oLbx.disabled)
	{	if (oFcs != oLbx)
		{	if (!oLbx.tv_sel) oLbx.tv_sel = oRow;
			iNmd_focus(oLbx);
		}
		
		if (!bTouchScrn) oLbx.focus();
			
		oLbx.value = sVal;
		bDbl = false;

		if (iNmd_is_ie)
		{	if (!oRow.ondblclick) oRow.ondblclick = Function('return iNmd_TvuClk(this, event);');
			if ((e) && (e.type != 'click')) bDbl = true;
		}
		else
		{	bDbl = i_DblClk(oRow);
		}

		if (e == null)
		{	AjxSend('S' + sId + ',Sel:' + sVal, 0);
			oLbx.in_chg = true;
			return;
		}

		var sSig;
		
		if (bDbl)
		{	sSig = 'Dbl';	
			oLbx.in_chg = false;
		}
		else
		{	oLbx.in_chg = true;
			var oEvt = e.target ? e.target : e.srcElement;
			if (oEvt && oEvt.id && (oEvt.id.substr(0,2) == 'ts'))
			{	sSig = 'Ste';
			}
			else
			{	sSig = 'Clk';
			}
		}
		
		AjxSend('S' + sId + ',' + sSig + ':' + sVal, 0);
	}
	
	return;
}

function iNmd_TvuSel(sId, nId)
{	var oLbx = i_Id('id_' + sId);
	if (!oLbx) return;

	var oItem = null;
	
	if (nId) oItem = i_Id('tx_' + sId + '_' + nId);
	
	if (oLbx.tv_sel)
	{	oLbx.tv_sel.className = 'iTvText';
		oLbx.tv_sel = null;
	}
	
	if (oItem)
	{	oLbx.tv_sel = oItem;
		oItem.className = 'iTvTextSel';
	}
	
	oLbx.value = nId;

	if (oFcs == oLbx) iNmd_TvuFcs(oLbx);
	
	if (!oItem) return;
	
	var oDiv = i_Id('dv_' + sId);
	if (!oDiv) return;
	return;
}

function iNmd_TvuFcs(oLbx)
{	if (!oLbx.tv_sel)
	{	var oItem = i_Id('tx_' + oLbx.id.substr(3) + '_1');
		if (oItem)
		{	iNmd_TvuClk(oItem, null);
			oLbx.in_chg = null;
		}
	}
	
	if (oLbx.tv_sel)	
	{	if (oLbx.tv_sel.className == 'iTvText')
			oLbx.tv_sel.className = 'iTvTextFcs';
		else
		if (oLbx.tv_sel.className == 'iTvTextSel')
			oLbx.tv_sel.className = 'iTvTextSelFcs';
	}

	iNmd_focus(oLbx);
	oLbx.in_blur = iNmd_TvuBlr;
}

function iNmd_TvuBlr(oLbx)
{	if (oLbx.tv_sel)
	{	if (oLbx.tv_sel.className == 'iTvTextFcs')
			oLbx.tv_sel.className = 'iTvText';
		else
		if (oLbx.tv_sel.className == 'iTvTextSelFcs')
			oLbx.tv_sel.className = 'iTvTextSel';
	}
	
	if ((oLbx.in_chg) && (!oLbx.in_auto))
	{	document.inomads._eom.value = '\x01';
		oChg = oLbx;
		oLbx.in_chg = false;
	}
}

function iNmd_TvuKdn(e)
{	var nKey = (e.which) ? e.which : e.keyCode ;
	if ((nKey == 9) || (nKey == 27))
	{	iNmd_TvuBlr(oFcs);
		return iNmd_KdnChkTab(e);
	}

	var sKey;
	var oItem = oFcs.tv_sel;
	var	bFirst = false;
	var nScroll;
	
	if ((oItem == null) || (oItem.className == 'iTvTextFcs'))
	{	oItem = i_Id('tx_' + sFcsId + '_1');
		bFirst = true;
	}
	
	switch (nKey)
	{	case 33: 	/* PgUp */
			oItem = iNmd_TvuPgup(oItem);
			if (oItem) iNmd_TvuClk(oItem, null);
	
			break;
		case 34: 	/* PgDn */
			oItem = iNmd_TvuPgdn(oItem);
			if (oItem) iNmd_TvuClk(oItem, null);
	
			break;
			
		case 35: 	/* End */
			var oItem2 = oItem;
			while(oItem2) 
			{	oItem = oItem2;
				oItem2 = iNmd_TvuNxt(oItem);
			}
			if (oItem) iNmd_TvuClk(oItem, null);
			break;
			
		case 36:	/* Home */
			if (!bFirst) oItem = i_Id('tx_' + sFcsId + '_1');
			if (oItem) iNmd_TvuClk(oItem, null);
			break;
			
		case 37: 	/* Left */
			iNmd_Signal(sFcsId, "Col:" + oFcs.value);
			break;

		case 39:	/* Right arrow */
			iNmd_Signal(sFcsId, "Exp:" + oFcs.value);
			break;
			
		case 38:	/* Up */
			if (!bFirst) oItem = iNmd_TvuPrv(oItem);
			if (oItem) iNmd_TvuClk(oItem, null);
			break;		
		
		case 40:	/* Down */
			if (!bFirst) oItem = iNmd_TvuNxt(oItem);
			if (oItem) iNmd_TvuClk(oItem, null);
			break;		
		
		case 13:	/* Enter */
			document.inomads._eom.value = '\x0D';
			iNmd_Chg(oFcs);
			break;
			
		default:
			return iNmd_CmnKdn(e);
	}

	if (window.event) e.returnValue = false;
	return false;  
}

function iNmd_TvuNxt(oItem)
{	while(oItem)
	{	oItem2 = oItem.firstChild;
		if (!oItem2) oItem2 = oItem.nextSibling;
		while (!oItem2)
		{	oItem2 = oItem.parentNode;	
			if (oItem2.id)
			{	if (oItem2.id.substr(0,3) == 'dv_') return null;
			}

			oItem = oItem2;
			oItem2 = oItem.nextSibling;
		}
		
		oItem = oItem2;
		if (oItem.id)
		{	if (oItem.id.substr(0,3) == 'tx_') break;
		}
	}
	
	return oItem;
}

function iNmd_TvuPrv(oItem)
{	while (oItem)
	{	oItem2 = oItem.previousSibling;
		if (oItem2)
		{	while (oItem2.firstChild)
			{	oItem2 = oItem2.firstChild;
				while (oItem2.nextSibling)
				{	oItem2 = oItem2.nextSibling;
				}
			}
		}
		else
		{	oItem2 = oItem.parentNode;
			if (oItem2.id)
			{	if (oItem2.id.substr(0,3) == 'dv_')  return null;
			}
		}

		oItem = oItem2;
		if (oItem.id)
		{	if (oItem.id.substr(0,3) == 'tx_') break;
		}
	}

	return oItem;
}

function iNmd_TvuPgdn(oItem)
{	var oDiv = i_Id('dv_' + sFcsId);
	if (!oDiv) return null;

	var nDivTop = iNmd_Top(oDiv); 	
	var nItemTop = iNmd_Top(oItem) - nDivTop;
	if (nItemTop < 0) nItemTop = 0;

	var nDivBtm = oDiv.scrollTop + oDiv.clientHeight;
	var nItemBtm = nItemTop + oItem.offsetHeight;
	
	/* If off the screen just exit to resync */
	
	if ((nItemTop < oDiv.scrollTop) || (nItemBtm > nDivBtm))
		return oItem;
	
	var oItem2;
	var bFirst = true;

	while (1)
	{	oItem2 = iNmd_TvuNxt(oItem);
		if (!oItem2) break;
		
		nItemBtm = iNmd_Top(oItem2) - nDivTop + oItem2.offsetHeight;
		if (nItemBtm > nDivBtm)
		{	if (!bFirst) break;
			nDivBtm = nItemTop + oDiv.clientHeight;
		}
			
		oItem = oItem2;
		bFirst = false;
	}
		
	return oItem;
}
			
function iNmd_TvuPgup(oItem)
{	var oDiv = i_Id('dv_' + sFcsId);
	if (!oDiv) return null;

	var nDivTop = iNmd_Top(oDiv); 	
	var nItemTop = iNmd_Top(oItem) - nDivTop;
	if (nItemTop < 0) nItemTop = 0;

	var nDivBtm = oDiv.scrollTop + oDiv.clientHeight;
	var nItemBtm = nItemTop + oItem.offsetHeight;
	
	if ((nItemTop < oDiv.scrollTop) || (nItemBtm > nDivBtm))
		return oItem;
	
	var oItem2;
	var bFirst = true;
	var nItemPos;
	var	nTop = oDiv.scrollTop;
	
	while (1)
	{	oItem2 = iNmd_TvuPrv(oItem);
		if (!oItem2) break;
		
		nItemPos = iNmd_Top(oItem2) - nDivTop;
		if (nItemPos < 0) nItemPos = 0;
		
		if (nItemPos < nTop)
		{	if (!bFirst) break;
			nTop = Math.max(0, nItemTop - oDiv.clientHeight);
		}
			
		oItem = oItem2;
		bFirst = false;
	}
	
	return oItem;
}

function iNmd_TvuRel(oTvu, oItem)
{	var oDiv = i_Id('dv_' + oTvu.id.substr(3));
	if (!oDiv) return 0;
	
	var nDivTop = iNmd_Top(oDiv);
	var nItemTop = iNmd_Top(oItem) - oDiv.scrollTop;
	
	if (nItemTop < 0) return nItemTop;
	
	nItemTop -= oDiv.offsetHeight;
	if (nItemTop > 0) return nItemTop;
	return 0;
}
	
function iNmd_TvuEdit(sId, nRow, sVal)
{	var oCell = i_Id('tx_' + sId + '_' + nRow);
	if (!oCell) return;

	var oLbx = i_Id('id_' + sId);
	if (oFcs != oLbx)
	{	if (!oLbx.tv_sel) oLbx.tv_sel = oRow;
		iNmd_focus(oLbx);
	}

	oLbx.focus();
	iNmd_CellEdit(oCell);
}

/* Grid functions */

function iGd_CellMseDown(oCell)
{	var sId = oCell.id.substr(3);
	var nOfs = sId.indexOf('_');

	var oInp = i_Id('id_' + sId.substr(0,nOfs));
	if (!oInp || oInp.disabled) return false;

	if (oFcs != oInp)
	{	iNmd_focus(oInp);
		return false;
	}
	
	if (oCellEdit) 
	{	if ((oCellEdit.parentNode == oCell) && !oCellEdit.readOnly && !oCellEdit.in_Chged)
		{	if (oCellEdit.in_Val) oCellEdit.value = oCellEdit.in_Val;
			oCellEdit.in_Chged = true;
			oCellEdit.select();
			oCellEdit.parentNode.setAttribute("data-sts","E");
			return i_IgnEvent();
		}
		iNmd_CellEdtEnd(0);	
	}

	return false;
}

function iGd_CellMseUp(oCell, bShift)
{	var sId = oCell.id.substr(3);
	var nOfs = sId.indexOf('_');
	
	var oGrid = i_Id('id_' + sId.substr(0,nOfs));

	if (!oGrid || oGrid.disabled) return false;

	if (oCell.id.indexOf('_N') == -1) 
		iNmd_CellEdit(oCell);
	else
	if (oGrid.in_Fcs)
		iNmd_CellEdit(oGrid.in_Fcs);
		
	if (oCell.in_Cbox)
		AjxSend('S' + sId.substr(0,nOfs) + ',Btn:' + sId.substr(nOfs+1), 0);
	else
	if (bShift)
		AjxSend('S' + sId.substr(0,nOfs) + ',SClk:' + sId.substr(nOfs+1), 0);
	else
		AjxSend('S' + sId.substr(0,nOfs) + ',Clk:' + sId.substr(nOfs+1), 0);
	return false;
}

function iNmd_GrdMnu(e)
{	if (window.event) e = window.event;
	var oCell = e.target ? e.target : e.srcElement;
	
	while (oCell)
	{	if (oCell.id && (oCell.id.substr(0,3) == 'gc_')) break;
		oCell = oCell.parentNode;
	}
	
	if (!oCell) return true;

	var sId = oCell.id.substr(3);
	var nOfs = sId.indexOf('_');
	
	var oInp = i_Id('id_' + sId.substr(0,nOfs));
	if (!oInp) return true;
	
	if (oInp.disabled) return false;

	if (oFcs != oInp) iNmd_focus(oInp);
	oInp.focus();
	
	AjxSend('S' + sId.substr(0,nOfs) + ',Mnu:' + sId.substr(nOfs+1), -1);
	
	nMseX = iNmd_Left(oCell) + 2;
	nMseY = iNmd_Top(oCell) + oCell.offsetHeight - 3;

	return i_IgnEvent(e);
}

function iNmd_GrdBtn(oObj)
{	var oCell = oObj.parentNode;
	while (oCell)
	{	if (oCell.id.substr(0,3) == 'gc_') break;
		oCell = oCell.parentNode;
	}
	if (!oCell) return false;

	oGridCell = oCell;

	var sId = oCell.id.substr(3);
	var nOfs = sId.indexOf('_');

	var oInp = i_Id('id_' + sId.substr(0,nOfs));
	if (!oInp || oInp.disabled) return false;

	if (oFcs != oInp) iNmd_focus(oInp);
	oInp.focus();

	AjxSend('S' + sId.substr(0,nOfs) + ',Btn:' + sId.substr(nOfs+1), 0);
	return false;
}

function iNmd_GrdPos(sId, nRow, nCol)
{	if (!bSettled)
	{	setTimeout(function () { iNmd_GrdPos(sId, nRow, nCol); }, 200);
		return;
	}

	var oDiv = i_Id('dv_' + sId);
	if (!oDiv) return;
	
	var oCell = i_Id('gc_' + sId + '_' + nRow + '_' + nCol);
	if (!oCell) return;

	var oInp = i_Id('id_' + sId);
	if (!oInp) return;
	
	/* Scroll the cell into view if reqd */

	if (oDiv.i_ds)
	{	var oParent = oCell.parentNode;
		
		while (oParent)
		{	if (oParent.id) break;
			oParent = oParent.parentNode;
		}

		if (oParent)
		{	var rcCell = oCell.getBoundingClientRect();
			var rcBR = oDiv.i_dd.getBoundingClientRect();
			var rcBR_top = rcBR.top;
			var rcBR_left = rcBR.left;
			
			var rcCell_left = rcCell.left;
			var rcCell_top = rcCell.top;

			if (oDiv.i_tl)
			{	rcBR_top += oDiv.i_tl.offsetHeight;
				rcBR_left += oDiv.i_tl.offsetWidth;
			}

			var nScroll = 0;
			
			if (oParent.id.substr(1,1) == 'r')
			{	if (rcCell.right > rcBR.right)
				{	nScroll = rcCell.right - rcBR.right;
					rcCell_left -= nScroll;
				}
				if (rcCell_left < rcBR_left)
				{	nScroll += rcCell_left - rcBR_left;
				}
				if (nScroll) oDiv.i_ds.scrollLeft += nScroll;
			}
			
			nScroll = 0;

			if (oParent.id.substr(0,1) == 'b')
			{	if (rcCell.bottom > rcBR.bottom)
				{	nScroll = rcCell.bottom - rcBR.bottom;
					rcCell_top -= nScroll;
				}
				if (rcCell_top < rcBR_top)
				{	nScroll += rcCell_top - rcBR_top;
				}
				if (nScroll) oDiv.i_ds.scrollTop += nScroll;
			}
		}
	}

	if (oInp == oFcs)
	{	iNmd_CellEdit(oCell);
	}
	else
	{	iGd_GotoCell(oCell);
	}
}

function iNmd_GrdDrp(sId, nRow, nCol, nSelected)
{	var oCell = i_Id('gc_' + sId + '_' + nRow + '_' + nCol);
	if (!oCell) return;

	if (oCell.in_Dbx) iGdDbxEnd(oCell);
	
	var rcCell = oCell.getBoundingClientRect();
	var oGrid = i_Id('dv_' + sId);
	var rcGrid = oGrid.getBoundingClientRect();
	
	var oDiv = document.createElement('div');	/* Main drop box div */
	oDiv.className = 'iGdDrp';
	oDiv.style.top = (rcCell.top - rcGrid.top + oCell.offsetHeight) + 'px';
	oDiv.style.left = (rcCell.left - rcGrid.left) + 'px';
	oDiv.style.width = oCell.offsetWidth + 'px';
	
	var oFrm = document.createElement('div');	/* Frame/background div */
	oFrm.className = 'iGdDrpFrm';
	oDiv.insertBefore(oFrm, null);

	var oList = document.createElement('div');	/* List container */
	oList.className = 'iGdDrpList';
	oFrm.insertBefore(oList, null);
	
	var oElm;
	nSelected += 4;
	
	for (var i = 4; i< iNmd_GrdDrp.arguments.length; i++)
	{	oElm = document.createElement('div');
		if (i == nSelected)
		{	oElm.setAttribute('data-s','Y');
			oList.in_Sel = oElm;
		}
		
		oElm.in_val = iNmd_GrdDrp.arguments[i];
		oElm.innerHTML = iNmd_HTML(iNmd_GrdDrp.arguments[i]);
		oList.insertBefore(oElm, null);
	}

	i_AddNode(oDiv, oGrid);

	oCell.in_Dbx = oList;
	oList.id = 'gl_' + sId;
	oList.in_Div = oDiv;
	oList.in_Cell = oCell;
}

function iGdDbxKdn(nKey)
{	var oCell = oCellEdit.parentNode;
	if (!oCell) return false;
	
	var oList = oCell.in_Dbx;
	if (!oList) return false;

	var oElm = oList.in_Sel;
	switch(nKey)
	{	case 40:	/* Down */
			if (!oElm)
				oElm = oList.firstChild;
			else
				oElm = oElm.nextSibling;
			break;
			
		case 38:	/* Up */
			if (oElm)
				oElm = oElm.previousSibling;
			break;
			
		case 27:	/* Escape */
			iGdDbxEnd(oCell);
			return true;
			
		case 13:	/* Enter */
			iGdDbxSel(oCell, 13);
			return true;
			
		case 9:		/* Tab */
			iGdDbxSel(oCell, 9);
			return false;
		default:
			return true;
	}
	
	if (!oElm) return true;
	if (oList.in_Sel) oList.in_Sel.removeAttribute('data-s');

	oElm.setAttribute('data-s','Y');
	oList.in_Sel = oElm;
	return true;		/* Processed */
}

function iGdDbxMse(oList, e)
{	var oElm = e.target ? e.target : e.srcElement;
	if (!oElm) return false;

	if (oElm.parentNode != oList) return false;

	if (oList.in_Sel) oList.in_Sel.removeAttribute('data-s');
	oElm.setAttribute('data-s','Y');
	oList.in_Sel = oElm;

	if (e.type == 'mousedown') return false;
	iGdDbxSel(oList.in_Cell, 1);
	return true;
}	
	
function iGdDbxSel(oCell, nChar)
{	var sVal = null;

	var oList = oCell.in_Dbx;
	var oElm = oList.in_Sel;
	if (oElm) sVal = oElm.in_val;
	
	iGdDbxEnd(oCell);
	if (sVal != null)
	{	AjxSend('S' + sFcsId + ',Chg:' + nChar + ',' + sVal);
		oCellEdit.in_Val = sVal;
	}
}
	
function iGdDbxEnd(oCell)
{	var oList = oCell.in_Dbx;
	if (!oList) return;

	i_RmvNode(oList.in_Div);
	oCell.in_Dbx = null;
}

/* Folder functions */

function iNmd_TabClk(e)
{	if (window.event) e = window.event;
	var oTab =  e.target ? e.target : e.srcElement;

	while (oTab)
	{	if (oTab.id) 
		{	if ((oTab.className == 'iTabNormal') || (oTab.className == 'iWtbNrm') || (oTab.className == 'iSdTabNrm') )
			{	bFldrPend = true;
				if (oChg != null) iNmd_Chg(oChg);
				bFldrPend = false;
				AjxSend('C' + oTab.id.substr(3) + ',0',0);
				break;
			}
			if ((oTab.id.substr(0,3) == 'ft_') || (oTab.id.substr(0,1) == '1')) break;
		}
		oTab = oTab.parentNode;
	}
    return i_IgnEvent(e);
}

/* Folder tab keydown -- handle left/right arrow */

function iNmd_TabKdn(e, nId, nTabCnt)
{	var oTab = e.target ? e.target : e.srcElement;
	var nKeyCode = (!iNmd_is_ie) ? e.which : e.keyCode;
	if (nKeyCode == 9) return iNmd_KdnChkTab(e);

	if ((nKeyCode == 13) && (oTab.tabIndex != 0))
	{	AjxSend('C,13', 0);
	}
	else
	{	var nDir;

		if (!bAutoFolder && (nKeyCode == 32))
		{	iNmd_Send(nId);
			return true;
		}
		if ((nKeyCode == 37) || (nKeyCode == 33) || (nKeyCode == 38))	/* LeftArw Pgup UpArw */
			nDir = -1;
		else 
		if ((nKeyCode == 39) || (nKeyCode == 34) || (nKeyCode == 40))	/* RightArw PgDown DownArw */
			nDir = 1;
		else
			return true;
		
		var nStrt = nId;
		var nMin = nId - (nId % 100) + 1;
		var nMax = nMin + nTabCnt;
		
		while (1)
		{	nId += nDir;
			if (nId == nStrt) break;
			if (nId >= nMax) nId = nMin;
				
			oTab = i_Id('id_' + nId);
			if (!oTab) oTab = i_Id('ft_' + nId);
			if (!oTab) break;
			
			if (oTab && (!oTab.disabled)) break;
		}

		if (nId != nStrt) 
		{	if (bAutoFolder)
				iNmd_Send(nId);
			else
				oTab.focus();
		}
	}
    return i_IgnEvent(e);
}  

/* Query button */
  
function iNmd_Qry(oQry)
{	if (!oQry) oQry = oFcs;

	var sId = oQry.id.substr(3);
	var oMl = i_Id('id_' + sId);

	if (oMl) 
	{	if (oMl.disabled) return false;
		if (oFcs != oMl)
		{	oMl.focus();
			setTimeout(function (){ iNmd_Qry(oFcs); }, 100);
		}
		else
		{	AjxSend('?' + sId + ',0' + iNmd_Val(oMl), 1);
		}
	}
	else 
		alert('Cannot find id_' + sId);
		
	return false;
}
 
/* Common logic -- header resizes and scroll stuff */

var oResizing = null;
var oDivSize = null;
var sIdSize = '';
var sPosSize = '';
var bWidthResize = false;
var nMseDownX = -1;
var nMseDownY = -1;

function iNmd_GrdInHdr(e)
{	if (oDivSize) return;
  
	var oCell = e.target ? e.target : e.srcElement;
	var nRight;
	var nBottom;
	var nOfsCol;

	iNmd_MseXY(e);

	var oId = oCell; //oCell.parentNode;
	while (oId)
	{	if (oId.id != '') break;
		oId = oId.parentNode;
	}

	var sId = oId.id.substr(3);
	sIdSize = sId.substr(0,sId.indexOf('_',0));
	sPosSize = sId.substr(sId.indexOf('_',0)+1);

	bHdrResize = false;

	var oHs = i_Id('dv_' + sIdSize);
	if (!oHs) { alert("Cannot find oHs id:dv_" + sIdSize); }
	var sCur;

	nRight = iNmd_Left(oCell) - oHs.scrollLeft + oCell.offsetWidth;
	nOfsCol = sPosSize.indexOf('_',0);

	if (nMseX >= nRight-4)
	{	bWidthResize = true;
		sCur = 'e-resize';
		if (nOfsCol > 0) sPosSize = sPosSize.substr(nOfsCol+1);
	}
	else
	{	if ((nOfsCol < 0) || (oId.id.substr(0,1) != 'g'))
		{	if (oResizing) iNmd_GrdOutHdr(e);
			return;
		}

		nBottom = iNmd_Top(oCell) + oCell.offsetHeight;
		if (nMseY >= nBottom-4)
		{	bWidthResize = false;
			sCur = 'n-resize';
			sPosSize = sPosSize.substr(0, nOfsCol);
		}
		else
		{	if (oResizing) iNmd_GrdOutHdr(e);
			return;
		}
	}

	document.body.style.cursor = sCur;

	oCell.onmouseout = iNmd_GrdOutHdr;
	oCell.onmousedown = iNmd_HdrSzStrt;

	oResizing = oCell;
	bHdrResize = true;
}

function iNmd_GrdOutHdr(e)
{	if (oDivSize) return;
	bHdrResize = false;
	
	if (oResizing)
	{	oResizing.onmousedown = null;
		oResizing.onmouseout = null;

		document.body.style.cursor = 'auto';
		oResizing = null;
	}  
	return;
}

function iNmd_HdrSzStrt(e)
{	if (oDivSize) return;
	if (oResizing == null) return;
  
	if (window.event) e = window.event;

	iNmd_MseXY(e);
	nMseDownX = nMseX;
	nMseDownY = nMseY;

	var oDiv = i_Id('dw_' + sIdSize);
	if (!oDiv) { alert('Cannot find dw_' + sIdSize); return; }

	oDivSize = document.createElement('div');

	oDivSize.style.position='absolute';

	if (bWidthResize)
	{	var oHs = oResizing.parentNode;
		var scrollLeft = 0;
		
		while (oHs)
		{	if (oHs.id.substr(0,3) == 'dv_') 
			{	scrollLeft = oHs.scrollLeft;
				break;
			}
			
			if (oHs == oDiv) break;
			oHs = oHs.parentNode;
		}


		oDivSize.style.top = iNmd_Top(oDiv)  + (bSafari ? 1 : 0) + 'px';
		oDivSize.style.left = iNmd_Left(oResizing) - scrollLeft + (bSafari ? 2 : 0) + 'px';

	    oDivSize.style.height = oDiv.offsetHeight + 'px';
		oDivSize.style.width = oResizing.offsetWidth + 'px';

		oDivSize.className = 'iCmnSizeH';
	}
	else
	{	oDivSize.style.top = iNmd_Top(oResizing)  + (bSafari ? 1 : 0) + 'px';
		oDivSize.style.left = iNmd_Left(oDiv)  + (bSafari ? 2 : 0) + 'px';
	
		oDivSize.style.height = oResizing.offsetHeight + 'px';    
		oDivSize.style.width = oDiv.offsetWidth + 'px';

		oDivSize.className = 'iCmnSizeV';
	}
  
	i_AddNode(oDivSize);

	if (window.addEventListener)
	{	window.addEventListener('mouseup', iNmd_HdrSzEnd, true);
		window.addEventListener('mousemove', iNmd_HdrSzChg, true);
	}
	else
	{	document.attachEvent('onmouseup', iNmd_HdrSzEnd);
		document.attachEvent('onmousemove', iNmd_HdrSzChg);
	}

	if (window.event) e.returnValue = false;
	return false;
}

function iNmd_HdrSzChg(e)
{	if (!oDivSize) return;

	var nSize;

	iNmd_MseXY(e);
	if (bWidthResize)
	{	nSize = oResizing.offsetWidth + nMseX - nMseDownX;
		if (nSize < 1) nSize = 1;

		oDivSize.style.width = nSize + 'px';
	}
	else
	{	nSize = oResizing.offsetHeight + nMseY - nMseDownY;
		if (nSize < 1) nSize = 1;

		oDivSize.style.height = nSize + 'px';
	}

	if (window.event)
		window.event.cancelBubble = true;
	else
		e.stopPropagation();

	return false;
}

function iNmd_HdrSzEnd(e)
{	var sAdj;
	if (bWidthResize)
		sAdj = 'Wide:' + oDivSize.offsetWidth;
	else
		sAdj = 'High:' + oDivSize.offsetHeight;

	if (sPosSize.substr(0,1) == 'N') sPosSize = '-' + sPosSize.substr(1);

	if (window.addEventListener)
	{	window.removeEventListener('mouseup', iNmd_HdrSzEnd, true);
		window.removeEventListener('mousemove', iNmd_HdrSzChg, true);
	}
	else
	{	document.detachEvent('onmouseup', iNmd_HdrSzEnd);
		document.detachEvent('onmousemove', iNmd_HdrSzChg);
	}

	if (oDivSize) oDivSize.parentNode.removeChild(oDivSize);
	oDivSize = null;
	bHdrResize = false;
	
	AjxSend('S' + sIdSize + ',' + sAdj + ',' + sPosSize, 0); 

	iFocus(oFcs);
	iNmd_GrdOutHdr(e); 

	if (window.event)
		window.event.cancelBubble = true;
	else
		e.stopPropagation();
	return false;
}

/* Horizontal and vertical scroll bar logic */

function iSbrSet(sId, nVal, nMax)
{	var oSbr = i_Id(sId);
	if (!oSbr) return;

	var sType = oSbr.getAttribute("data-type");
	if (!sType) return;

	var iBarSiz;
	var iThumbSiz;
	var iOffset;

	if (sType == 'H')
		iBarSiz = oSbr.clientWidth;
	else
		iBarSiz = oSbr.clientHeight;

	if (nVal < 1) nVal = 1;
	if (nVal > nMax) nVal = nMax;

	iThumbSiz = iBarSiz / (nMax + 1);
	if (iThumbSiz < 18) iThumbSiz = Math.min(18, 1 + iBarSiz/4);
	
	iThumbSiz = Math.floor(iThumbSiz);
	iBarSiz -= iThumbSiz;

	if (nMax == 1) 
		iOffset = 0;
	else
		iOffset = Math.floor( ((nVal - 1) * iBarSiz) / (nMax - 1));

	oSbr.iOffset = iOffset;
	oSbr.iBarSiz = iBarSiz;
	oSbr.iMax = nMax;

	if (sType == 'H')
	{	oSbr.firstChild.style.width = iThumbSiz + 'px';
		oSbr.firstChild.style.left = iOffset + 'px';
	}
	else
	{	oSbr.firstChild.style.height = iThumbSiz + 'px';
		oSbr.firstChild.style.top = iOffset + 'px';	
	}
}

function iSbrMseDown(e)
{	if (window.event) e = window.event;

	var oSbr = (e.target ? e.target : e.srcElement);
	oSbr = oSbr.parentNode;
	if (!oSbr.id) return i_IgnEvent(e);

	iNmd_focus(oSbr);
	iNmd_MseXY(e);

	if (!oSbr.iMax)
	{	oSbr.iMax = 1000;
		oSbr.iOffset = 0;
	}

	oSbr.iStrtOffset = oSbr.iOffset;
	oSbr.iStrtX = nMseX;
	oSbr.iStrtY = nMseY;

	if (e.type == 'touchstart')
	{	i_AddEvent(window, 'touchmove', iSbrMseMove, true);
		i_AddEvent(window, 'touchend', iSbrMseUp, true);
	}
	else
	{	i_AddEvent(window, 'mousemove', iSbrMseMove, true);
		i_AddEvent(window, 'mouseup', iSbrMseUp, true);
	}
	return i_IgnEvent(e);
}

function iSbrMseMove(e)
{	if (window.event) e = window.event;

	var oSbr = oFcs;
	var iOffset;
	var sType =  oSbr.getAttribute("data-type");	

	iNmd_MseXY(e);
	
	if (sType == 'H')
		iOffset = oSbr.iStrtOffset + nMseX - oSbr.iStrtX;
	else
		iOffset = oSbr.iStrtOffset + nMseY - oSbr.iStrtY;

    if (iOffset < 0) iOffset = 0;
	if (iOffset > oSbr.iBarSiz) iOffset = oSbr.iBarSiz;

	if (sType == 'H')
		oSbr.firstChild.style.left = iOffset + 'px';	
	else
		oSbr.firstChild.style.top = iOffset + 'px';	

	oSbr.iOffset = iOffset;
	return i_IgnEvent(e);
}

function iSbrMseUp(e)
{	if (window.event) e = window.event;

	if (e.type == 'touchend')
	{	i_RmvEvent(window, 'touchmove', iSbrMseMove, true);
		i_RmvEvent(window, 'touchend', iSbrMseUp, true);
	}
	else
	{	i_RmvEvent(window, 'mousemove', iSbrMseMove, true);
		i_RmvEvent(window, 'mouseup', iSbrMseUp, true);
	}

	var oSbr = oFcs;
	var sType =  oSbr.getAttribute("data-type");	
	var iOffset = oSbr.iOffset;

	/* Emulate Windows and return thumb to original position */
	
	oSbr.iOffset = oSbr.iStrtOffset;

	if (sType == 'H')
		oSbr.firstChild.style.left = oSbr.iStrtOffset + 'px';	
	else
		oSbr.firstChild.style.top = oSbr.iStrtOffset + 'px';	

	/* Send/Compute the new offset */

	var iValue = 1 + Math.floor( (iOffset * (oSbr.iMax -1)) / oSbr.iBarSiz);
	AjxSend('S' + oSbr.id.substr(3) + ',' + sType + 'sc:' + iValue + ',' + (iOffset/oSbr.iBarSiz), 0);

	return i_IgnEvent(e);
}

function iSbrClick(e)
{	if (window.event) e = window.event;

	var oSbr = (e.target ? e.target : e.srcElement);
	if (!oSbr.id) return;

	var sType =  oSbr.getAttribute("data-type");	
	
	iNmd_MseXY(e);
	var rcBar = oSbr.getBoundingClientRect();
	var iOffset;

	if (sType == 'H')
		iOffset = nMseX - rcBar.left;
	else
		iOffset = nMseY - rcBar.top;

	AjxSend('S' + oSbr.id.substr(3) + ',Bar:' + (iOffset - oSbr.iOffset), 0);
	
	return i_IgnEvent(e);
}

function iSbrBtn(e, nChg)
{	if (window.event) e = window.event;

	var oSbr = (e.target ? e.target : e.srcElement);
	if (!oSbr.id) return;

	AjxSend('S' + oSbr.id.substr(3) + ',Adj:' + nChg, 0);
	return i_IgnEvent(e);
}

function iNmd_Goto(sId, bRetry)
{	document.inomads._eom.value = '';
	var oCtl = i_Id(sId);

	if (!oCtl) return;
	if (oCtl.disabled) 
	{	sTabFcs = null;
		return;
	}

	if (oFcs)
	{	if (oFcs != oCtl)
		{	iNmd_Restore(oFcs);	/* Not perfect since its possible on focus has occured */
			if (oFcs.in_blur) oFcs.in_blur(oFcs);
		
			if ((oFcs._null) && (oFcs.value == ''))
			{	oFcs.value = oFcs._null;
				oFcs._null_showing = true;
			}
		}
	}
	
	if (!oFcs || (oFcs != oCtl)) iNmd_SetFcs(oCtl, bRetry);
	if (bRetry) oChg = oCtl;

	iFocus(oCtl);
	if (!bTouchScrn) setTimeout("iFocus(i_Id('"+sId+"'))", 10);
	
	if (oCtl.type == 'text') iNmd_Select(oCtl);
	
	bTrapped = false;
}

function iNmd_Select(oCtl)
{	if (oCtl.type != 'text')
	{	if (oCtl.type != 'password') return;
	}

	if (oCtl.className == 'iCmnVal') return;

	if ('selectionStart' in oCtl)
	{	oCtl.selectionStart = 0;
		oCtl.selectionEnd = oCtl.value.length;
	}
	else
	if (document.selection)
	{	var oRng = document.selection.createRange();
		if (oRng)
		{	oRng.moveStart("character", -100000);
			oRng.moveEnd("character", 100000);
			oRng.select();
		}
	}
}

function iLvuSetData(sId, sHtml)
{	var oLvu = i_Id('dv_' + sId);
	if (!oLvu) return;
	
	iLvFree(oLvu);

	var oDiv = document.createElement('div');
	oDiv.innerHTML = sHtml;
	oLvu.replaceChild(oDiv.firstChild, i_Id('dd_' + sId));

	iLvInit(oLvu);

	oDiv = i_Id('ds_' + sId);
	if (oDiv) iLvScrlUpd(oDiv);
}

function iNmd_CmnLoad(sId, sHtml, nAppend)
{	var oTbl = i_Id(sId);
	if (!oTbl)
	{	alert('Cannot find ' + sId + ' (CmnLoad)');
		if (!bAjxDmp) AjxDump();
		return;
	}
	
	nClickMS = 0;
	oClick = null;
	
	var oDiv;

	if (nAppend)
	{	if (nAppend == -1)
		{	oDiv = oTbl.parentNode;
			if (oTbl.className == 'iLv') iLvFree(oTbl);
			i_RmvNode(oTbl);
			oTbl = oDiv;
		}
		
		oDiv = document.createElement('div');
		oDiv.innerHTML = sHtml;
		while (oDiv.firstChild)
		{	oTbl.appendChild(oDiv.firstChild);
		}
		
		oTbl = i_Id(sId);
		if ((oTbl.className == 'iLv') && (nAppend == -1))
			iLvInit(oTbl);
		else
			iLvSetup(oTbl);
	}
	else
	{	if (sHtml != '')
		{	oDiv = i_Id('sh_' + sId.substr(3));
			if (oDiv) 
			{	var nScroll = oDiv.scrollLeft;
				if (nScroll) setTimeout('i_CmnPos("'+sId.substr(3)+'",' + nScroll.toString(), 100);
			}
			
			oTbl.innerHTML = sHtml;
		}
			
		oDiv = i_Id('sv_' + sId.substr(3));
		if (oDiv) 
		{	oDiv.in_ScrollPend = false;
			if (oDiv.in_ScrollMore) iNmd_CmnVs(oDiv);
		}
		
		if (oTbl.className == 'iLv') iLvInit(oTbl);
	}
	
	if ((oFcs == oTbl) && bIsCommon && (!bTouchScrn)) iFocus(oFcs); 
}

function i_CmnPos(sId, nScroll)
{	var oDiv = i_Id('sh_' + sId);
	if (!oDiv) return;
	if (oDiv.scrollLeft != 0) return;
	if (oDiv.scrollLeft == nScroll) return;
	
	try
	{	oDiv.scrollLeft = nScroll;
		oDiv = i_Id('dv_' + sId);
		if (oDiv) oDiv.scrollLeft = nScroll;
	}
	catch(err)
	{
	}
	return;
}
		
function iNmd_CmnChg(sId, sHtml, sClass, sBgClr, sTxClr)
{	var oTbl = i_Id(sId);

	if (!oTbl)
	{	alert('Cannot find ' + sId + ' (CmnChg)' );
		if (!bAjxDmp) AjxDump();
		return;
	}

	if (sClass && (sClass != '')) oTbl.className = sClass;
	if (sBgClr) 
	{	if (sBgClr == 'null') 
			oTbl.style.backgroundColor = null;
		else	
			oTbl.style.backgroundColor = sBgClr;
	}
	if (sTxClr) 
	{	if (sTxClr == 'null') 
			oTbl.style.color = null;
		else	
			oTbl.style.color = sTxClr;
	}

	if (sHtml != '')
	{	if (sHtml.substr(0,1) == '^')
		{	while (oTbl)
			{	if ( (oTbl.nodeName == 'TD') || (oTbl.classname == 'iQry') || (oTbl.id && (oTbl.id.substr(0,2) == 'd_')) )
				{	oTbl.innerHTML = sHtml.substr(1);
					break;
				}
				oTbl = oTbl.parentNode;
			}
		}
		else
		if (sHtml.substr(0,1) == '!')
		{	oTbl = oTbl.parentNode;
			oTbl.innerHTML = sHtml.substr(1);
			oTbl = i_Id(sId);
		}
		else
		{	if (sId.substr(0,3) == 'gc_')
			{	var oDiv;
				oDiv = oTbl.firstChild;
				while(oDiv)
				{	if (oDiv.id && (oDiv.id.substr(0,3) == 'gx_'))
					{	oDiv = oDiv.nextSibling;
					}
					else
					{	oTbl.removeChild(oDiv);
						oDiv = oTbl.firstChild;
					}
				}
				
				oDiv = document.createElement('div');
				oDiv.innerHTML = sHtml;
				while (oDiv.firstChild)	oTbl.appendChild(oDiv.firstChild);
			}
			else
			{	oTbl.innerHTML = sHtml;
			}
		}

		if (sId.substr(0,3) == 'gc_') iGd_CellMseShow(oTbl);
	}

	if ((oFcs == oTbl) && bIsCommon && (!bTouchScrn)) iFocus(oFcs);

}

function iGd_CellMseShow(oCell)
{	var sId = oCell.id.substr(3,5);
	var oGrid = i_Id('id_'+sId);
	if (oGrid.in_FcsId == oCell.id)
	{	
		if (oFcs == oGrid)
		{	var oCellData = oCell.firstChild;		/* Update current focus input value with new value */

			while (oCellData.id) oCellData = oCellData.nextSibling;
			var _val = oCellData.getAttribute("data-v");
			if (_val == null) _val = '';
			oCellFcs.in_Val = decodeURIComponent(_val);

			iNmd_CellEdit(oCell);
		}
		else
			iGd_GotoCell(oCell);
	}
	
	var oDivHS = i_Id('dv_' + sId);
	if (!oDivHS) return;

	var nScroll = oDivHS.scrollLeft;
		
	var	nDivLeft = iNmd_Left(oDivHS);
	var nCellLeft = iNmd_Left(oCell);

	var nDivRight = nDivLeft + oDivHS.offsetWidth;
	var nCellRight = nCellLeft + oCell.offsetWidth;

	if ((nCellRight - nScroll) > nDivRight)
	{	nScroll = nCellRight - nDivRight;
	}
	
	if ((nCellLeft - nScroll) < nDivLeft)
	{	nScroll = nCellLeft - nDivLeft;
	}
	
	
	if (nScroll != oDivHS.scrollLeft)
	{	var oDiv = i_Id('sh_' + sId);
		if (oDiv) oDiv.scrollLeft = oDivHS.scrollLeft = nScroll;
	}
	return;
}

function iNmd_Msg()
{	var sMsg = oFcs.getAttribute('aria-label');
	if (!sMsg) sMsg = oFcs.getAttribute('iMsg');

	if (sMsg) 
	{	if (sMsgBar == '') sMsgBar = '&nbsp;';
		oMsgBar.innerHTML = sMsg;
		bMsgBar = true;
	}
	else
	if (bMsgBar)
	{	if (sMsgBar == '') sMsgBar = '&nbsp;';
		oMsgBar.innerHTML = sMsgBar;
		bMsgBar = false;
	}
	
	return;
}
	
function iNmd_Msgbar(sHtml, nBar)
{	var oHtml;

	if (typeof user_Msgbar == 'function')
	{	if (user_MsgBar(sHtml, nBar)) return;
	}

	if (nBar == 0)
	{	if (!oMsgBar) oMsgBar = i_Id('Msgbar');
		if (!oMsgBar) return;
		sMsgBar = sHtml;
		if (!bMsgBar) oMsgBar.innerHTML = sHtml;
	}
	else
	{	oHtml = i_Id('Msgbar' + nBar.toString(10));
		if (oHtml) oHtml.innerHTML = sHtml;
	}
}

function iNmd_CmnVs(oDiv)
{	if (oDiv.in_ScrollTop == oDiv.scrollTop) return;
	
	if (oDiv.in_ScrollPend)
	{	oDiv.in_ScrollMore = true;
	}
	else
	{	oDiv.in_ScrollPend = true;
		oDiv.in_ScrollMore = false;
		oDiv.in_ScrollTop = oDiv.scrollTop;
		
		AjxSend('S' + oDiv.id.substr(3) + ',Vsc:' + oDiv.scrollTop, 0);
	}

	return;
}

function iNmd_CmnHs(oDiv)
{	var sId = oDiv.id.substr(3);
	var oDiv2 = i_Id('dv_' + sId);

	if (oDiv2)
	{	oDiv2.scrollLeft = oDiv.scrollLeft;
		if (oFcs && bIsCommon) oFcs.focus();
	}
	else
		alert('Cannot find dv_'+sId);
	return;
}

function iNmd_CmnWhl(sId, event)
{	var nChg = 0;
 
	if (!event) event = window.event;

	if (event.wheelDelta)
	{	nChg = event.wheelDelta / 120;
	}
	else
	if (event.detail)
	{	nChg = (0 - event.detail) / 3;
	}

	var oDiv = i_Id('sv_' + sId);
	if (oDiv)
	{	var oRow = (event.target ? event.target : event.srcElement);
	
		while (oRow && !oRow.offsetHeight)
		{	oRow = oRow.parentNode;
		}
		
		if (oRow)
			nChg *= oRow.offsetHeight * 3;
		else
			nChg *= 40;
			
		nChg = oDiv.scrollTop - nChg;
		if (nChg == 0) nChg = 0;
		if (nChg > oDiv.scrollHeight) nChg = oDiv.scrollHeight;
		
		if (!oDiv.in_ScrollPend)
		{	if (nChg != oDiv.scrollTop)
			{	oDiv.scrollTop = nChg;
				iNmd_CmnVs(oDiv);
			}
		}
				
		if (event.stopPropagation) event.stopPropagation();
		if (event.preventDefault) event.preventDefault();
		event.cancelBubble = true;
        event.cancel = true;
		return event.returnValue = false;
	}
}

function iGd_Scrl(sId, nVScr, nHScr)
{	var oDiv = i_Id('dv_'+sId);
	if (!oDiv) return;
	
	if (!oDiv.i_dd) iGdInit(oDiv);
	
	if (oDiv.i_ds)
	{	oDiv.i_ds.scrollTop = nVScr;
		oDiv.i_ds.scrollLeft = nHScr;
	}
	return;
}

function iNmd_CmnKdn(e)
{	if (window.event) e = window.event;

	var nKey = (e.which) ? e.which : e.keyCode;
	var sKey;
	var nMode = 0;
	
	switch (nKey)
	{	case 13: sKey = 'CR'; break;	/* Enter */
		case 33: sKey = 'PGUP'; break;	/* PgUp */
		case 34: sKey = 'PGDN'; break;	/* PgDn */
		case 35: sKey = 'END'; break;	/* End */
		case 36: sKey = 'HOME'; break;	/* Home */
		case 37: sKey = 'LEFT'; break;	/* Left */
		case 38: sKey = 'UP'; break;	/* Up */
		case 39: sKey = 'RIGHT'; break;	/* Right */
		case 40: sKey = 'DOWN'; break;	/* Down */
		case 45: sKey = 'INS'; break;	/* Insert */
		case 46: sKey = 'DEL'; break;	/* Delete */
		case 9:
			iNmd_TabTrap(e.target ? e.target : e.srcElement);  
			bRefocus = true;
			sKey = 'TAB'; 
			nMode = -1;
			break;	/* Tab */
		case 27:
			AjxSend('C-1999,27');
			return e.returnValue = false;					

		case 8:
			if (sFcsId == '0') 
			{	sKey = 'BKSP';
				break;
			}						
		default:
			if (e.altKey)
			{	if ((nKey >= 112) && (nKey <= 123))
				{	AjxSend('K' + (nKey - 111));
					return e.returnValue = false;					
				}
			}
				
			return true;
	}

	sKey += ',' + (e.ctrlKey ? 'C' : '') + (e.shiftKey ? 'S' : ''); 
	if (oFcs && oFcs.in_fcsId) sKey += ',' + oFcs.in_fcsId;
	AjxSend('S' + oFcs.id.substr(3) + ',Kdn:' + sKey, nMode);  

	if (window.event) e.returnValue = false;
	return false;  
}

function iNmd_CmnKey(e)
{	var nKey;

	if (bFireFox)
	{	nKey = e.charCode;	
		if (nKey == 0) if (e.keyCode == 9) return true;
	}
	else
	if (bOpera)
		nKey = e.which;
	else
		nKey = e.keyCode;
		
	if (nKey == 9) return true;
	
	if (window.event) e.returnValue = false;
	
	if ((nKey >= 32) && (nKey != 127)) AjxSend('S' + oFcs.id.substr(3) + ',Key:' + nKey, 0);  
	
	return false;  
}

function iGd_GotoCell(oCell)
{	var sId = oCell.id.substr(3) + '_';
	sId = sId.substr(0,sId.indexOf('_'));
	var oGrid = i_Id('id_' + sId);
	
	var oCellData = oCell.firstChild;		/* Get the child which has all the details */
	while (oCellData.id)
	{	oCellData = oCellData.nextSibling;
	}
	var sType = oCellData.getAttribute('data-t');
	if (!sType) sType = 'normal';

	var sNodeNeeded, sTypeNeeded;
	sNodeNeeded = 'input';
	sTypeNeeded = 'text';
	
	if ((sType.indexOf('button') != -1) && (navigator.userAgent.match(/iPad/i) != null))
	{	sTypeNeeded = 'button';
	}
    else   
	if ((sType == 'multi_line') || (oCell.getAttribute('rowspan') != null))
	{	sNodeNeeded = sTypeNeeded = 'textarea';
	}

	oCellFcs = oGrid.in_Focus;
	if (oCellFcs)
	{	if (oCellFcs.type != sTypeNeeded)
		{	i_RmvNode(oCellFcs);
			oCellFcs = oGrid.in_Focus = null;
		}
	}
	
	if (!oCellFcs)
	{	oCellFcs = document.createElement(sNodeNeeded);
		oGrid.in_Focus = oCellFcs;

		oCellFcs.id = 'gx_' + sId;
		oCellFcs.type = sTypeNeeded;
		oCellFcs.className = 'iGdEdit';

		i_AddEvent(oCellFcs, "keydown", iNmd_kdn_FMT, true);
		i_AddEvent(oCellFcs, "keypress", iNmd_key_FMT, true);
		i_AddEvent(oCellFcs, "blur", iNmd_CellEdtBlur, true);

		oCellFcs.tabIndex = oGrid.tabIndex + 1000;
	}

	if ((oGrid.in_Fcs == oCell) && (oCellFcs.parentNode == oCell)) return oCellFcs;
	
	var oRow, oRowOld, idRow;
	oRow = oCell.parentNode;
	oRowOld = null;
	
	if (oGrid.in_Fcs)
	{	oGrid.in_Fcs.removeAttribute('data-sts');
		iGdDbxEnd(oGrid.in_Fcs);
	}
	
	oGrid.in_NoFcs = false;
	oCellFcs.in_Chged = false;
	
	i_AddNode(oCellFcs, oCell);

	oCell.setAttribute('data-sts','F');

	iGdChgCell(oGrid, oGrid.in_Fcs, oCell);

	oGrid.in_Fcs = oCell;
	oGrid.in_FcsId = oCell.id;

	var sRd = oCellData.getAttribute("data-rd");

	oCellFcs.value = '';
	var _val = oCellData.getAttribute("data-v");
	if (_val == null) _val = '';

	oCellFcs.in_Val = decodeURIComponent(_val);

	if (sRd)
	{	oCellFcs.readOnly = true;
		if (sRd == 'C') oCell.in_Cbox = true;
		oCellFcs.setAttribute('data-rd', 'Y');
	}
	else
	{	oCellFcs.readOnly = false;
		oCellFcs.removeAttribute('data-rd');
	}
	
	oCellFcs.setAttribute('data-t', sType);
	if (sType.indexOf('button') != -1) oCell.in_Cbox = true;

	var nMaxLen = oCellData.getAttribute('data-l');
	if (nMaxLen)
		oCellFcs.maxlength = parseInt(nMaxLen, 10);
	else
		oCellFcs.maxlength = 2147483647;

	oCellFcs.in_fmt = oCellData.getAttribute("data-f");
	return oCellFcs;		
}

function iGdChgCell(oGrid, oOldCell, oNewCell)
{	if (oOldCell == oNewCell) return;

	var sId = oNewCell.id.substr(9);
	var nOfs = sId.indexOf('_');

	var sNewRow = sId.substr(0, nOfs);
	var sNewCol = sId.substr(nOfs+1);

	if (oOldCell)
		sId = oOldCell.id.substr(9);
	else
		sId = 'X_X';    

	nOfs = sId.indexOf('_');

	var sOldRow = sId.substr(0, nOfs);
	var sOldCol = sId.substr(nOfs+1);
	var oDiv;

	if (sNewRow != sOldRow)
	{	oDiv = i_Id('xl_'+oGrid.id.substr(3)+'_'+sNewRow);
		if (oDiv) oDiv.setAttribute('data-cur', '1');

		oDiv = i_Id('xr_'+oGrid.id.substr(3)+'_'+sNewRow);
		if (oDiv) oDiv.setAttribute('data-cur', '1');

		if (oOldCell)
		{	oDiv = i_Id('xl_'+oGrid.id.substr(3)+'_'+sOldRow);
			if (oDiv) oDiv.removeAttribute('data-cur');

			oDiv = i_Id('xr_'+oGrid.id.substr(3)+'_'+sOldRow);
			if (oDiv) oDiv.removeAttribute('data-cur');
		}
	}

	if (sNewCol != sOldCol)
	{	oDiv = i_Id('ch_'+oGrid.id.substr(3)+'_N1_'+sNewCol);
		if (oDiv) oDiv.setAttribute('data-cur', '1');
		
		if (oOldCell)
		{	oDiv = i_Id('ch_'+oGrid.id.substr(3)+'_N1_'+sOldCol);
			if (oDiv) oDiv.removeAttribute('data-cur');
		}
	}
}

function iGdSetTrkClr(sId, sTrkClr)
{	var oGrid = i_Id(sId);
	if (oGrid) oGrid.in_TrkClr = sTrkClr;
}
function iGdSetCurClr(sId, sCurClr)
{	var oGrid = i_Id(sId);
	if (oGrid) oGrid.in_CurClr = sCurClr;
}
	
function iNmd_GdTrk(oGrid, oCell)
{	var sId = oCell.id.substr(9);
	var nOfs = sId.indexOf('_');

	var sRow = sId.substr(0, nOfs);
	var sCol = sId.substr(nOfs+1);

	sId = 'ch_'+oGrid.id.substr(3)+'_';
	
	oCell = i_Id(sId + sRow + '_N1');
	
	if (oCell && (!oGrid.in_oRow || (oGrid.in_oRow != oCell)))
	{	if (oGrid.in_oRow)
		{	oGrid.in_oRow.style.backgroundColor = oGrid.in_oRow.sv_Back;
			oGrid.in_oRow.style.backgroundImage = null;
		}

		oGrid.in_oRow = oCell;
		
		oCell.sv_Back = oGrid.in_oRow.style.backgroundColor;
		oCell.style.backgroundColor = oGrid.in_TrkClr;
		oCell.style.backgroundImage = 'none';
	}

	oCell = i_Id(sId + 'N1_' + sCol);
	if (oCell && (!oGrid.in_oCol || (oGrid.in_oCol != oCell)))
	{	if (oGrid.in_oCol)
		{	oGrid.in_oCol.style.backgroundColor = oGrid.in_oCol.sv_Back;
			oGrid.in_oCol.style.backgroundImage = null;
		}
		
		oGrid.in_oCol = oCell;
		
		oCell.sv_Back = oGrid.in_oCol.style.backgroundColor;
		oCell.style.backgroundColor = oGrid.in_TrkClr;
		oCell.style.backgroundImage = 'none';		
	}
}
	
function iNmd_CellEdit(oCell)
{	var oActiveCell = oCellEdit;
	var sActiveValue;
	var sActiveId = null;

	if (oActiveCell)
	{	if (oCellEdit.parentNode == oCell) 
		{	iGdQueFocus();
			return;
		}
		
		if (oActiveCell.in_Chged)
		{	sActiveId = sFcsId;
			sActiveValue = oActiveCell.value;
		}

		oCellEdit = null;
	}	

	if (oCellEdit) oCellEdit.blur();

	oCellEdit = iGd_GotoCell(oCell);

	if (!oCellEdit)
	{	alert( 'Cannot set focus to '+oCell.id);
		return;
	}

	oFcs.in_fmt = sFmt = oCellEdit.in_fmt;
	
	if (!oCellEdit.readOnly && (oCellEdit.type == 'text'))
	{	if ('selectionStart' in oCellEdit)
		{	oCellEdit.selectionStart = 0;
			oCellEdit.selectionEnd = oCellEdit.value.length;
		}
		else
		if (document.selection)
		{	var oRng = document.selection.createRange();
			if (oRng)
			{	oRng.moveStart("character", -100000);
				oRng.moveEnd("character", 100000);
				oRng.select();
			}
		}
	}

	if (sActiveId) AjxSend('S' + sActiveId + ',Chg:' + 0 + ',' + sActiveValue);
	iGdQueFocus();
}  

/* Needs work for TAB */
var bFcsInQ = false;

function iGdFocus(oCtl)
{	iNmd_focus(oCtl);
	iGdQueFocus();
}

function iGdQueFocus()
{	if (bFcsInQ || oFcs.in_NoFcs || oDivMask) return;
	bFcsInQ = true;
	setTimeout(iGdDoFocus, 30);
}

function iGdDoFocus()
{	bFcsInQ = false;
	if (!oFcs.in_NoFcs)
	{	if (oFcs.in_Focus) oFcs.in_Focus.focus();
	}

	oCellEdit = oFcs.in_Focus;
	return;
}
function iNmd_CellEdtBlur(event)
{	if (!oFcs.in_NoFcs) iNmd_CellEdtEnd(0);
}

function iNmd_CellEdtEnd(nKey, bShift)
{	var oEdit = oCellEdit;
	if (!oEdit) return;
	var oCell = oCellEdit.parentNode;
	
	if (oEdit.in_Chged || (oFcs.in_Focus != oCellEdit)) iGdDbxEnd(oCell);
	
	oChg = null;
	
	if (oCell.getAttribute('data-sts') == 'E') 
		oCell.setAttribute('data-sts', 'F');
	
	/* Add logic for Tab */
			
	if (oEdit.in_Chged)
	{	oEdit.in_Chged = false;

		if (nKey != 27)
		{	var nMode = 0;
			if (nKey == 9)
			{	nMode = -1;
				if (bShift) nKey = -9;
			}

			if (oCell.getAttribute('data-num')) 
			{	var sDig = oEdit.value.match(/[1-9]/);
				if (!sDig) oEdit.value = '0';
			}

			oEdit.in_Val = oEdit.value;
			
			var sMsg = 'S' + sFcsId + ',Chg:' + nKey + ',' + oEdit.value;
		
			if (nMode == -1) iNmd_TabTrap(oEdit);
			AjxSend(sMsg, nMode);
		}
	}
	oEdit.value = '';
}  

/* Popup menu functions */

var bPopup = false;
var oMbar = null;
var oMbarDiv = null;

function iNmd_Popup(sMenu, nX, nY)
{	var oMnu = new iMnu(sMenu);
	bPopup = true;
	
	if (iNmd_Popup.arguments.length == 3)
	{	if ((nX >= 0) && (nY >= 0))
		{	var oPanel = i_Id('id_Panel');
			if (oPanel)
			{	nMseX = nX + iNmd_Left(oPanel);
				nMseY = nY + iNmd_Top(oPanel);
			}
		}
	}

	iMnu_Show(null, oMnu, ''); 
}

function iNmd_Mbar(sMenu)
{	if (b3Lines)
	{	var o3Lines = i_Id('id_3Lines');
		oDiv = i_Id('id_Mbar');
		oDiv.style.display = 'none';
		
		if (sMenu == '' )
		{	oMbar = null;
			o3Lines.style.display = 'none';
		}
		else
		{	oMbar = new iMnu(sMenu);
			o3Lines.style.display = 'inline-block';
		}
		return;
	}
	
	if (!oMbarDiv)
	{	oMbarDiv = i_Id('id_Mbar');
		if (!oMbarDiv) return;
	}
	
	if (sMenu == '')
	{	oMbarDiv.style.display = 'none';
		oMbarDiv.innerHTML = '&nbsp;';
		oMbarDiv = null;
		oMbar = null;
		return;
	}
	
	oMbar = new iMnu(sMenu);
	iMnu_Show(null, oMbar, '');
}

function i_3Lines(o3Lines)
{	if (oMbar) iMnu_Show(o3Lines, oMbar, '');
	return;
}

function iNmd_MbarChg(sId, sSts)
{	var nMnu;
	if (!oMbar) return;

	var subMenu = sId.substr(0,sId.length-1);
	
	for (nMnu = 0; nMnu < oMbar.subMenu.length; nMnu++)
	{	if (oMbar.subMenu[nMnu] == subMenu) break;
	}

	if (nMnu >= oMbar.subMenu.length) { alert('Cannot find menu group'); return; }

	var sText = oMbar.subText[nMnu];
	var sCd = sId.substr(sId.length-1);
	
	var nIdx = sText.toUpperCase().indexOf('&' + sCd,0);
	if (nIdx < 0) { alert('Cannot find sub-menu entry'); return; }
	
	nIdx = sText.indexOf('=',nIdx);
	if (nIdx < 0) { alert('Cannot find ='); return; }
	
	var sPre = sText.substr(0,nIdx);
	var sOpt = sText.substr(nIdx);

	nIdx = sOpt.indexOf(',',0);
	if (nIdx == -1)
	{	sText = '';
	}
	else
	{	sText = sOpt.substr(nIdx);
		sOpt = sOpt.substr(0,nIdx);
	}
	
	nIdx = sOpt.indexOf(sSts.substr(1));
	
	if (sSts.substr(0,1) == '+')
	{	if (nIdx == -1) sOpt += sSts.substr(1);
	}
	else
	{	sOpt = sOpt.substr(0,nIdx) + sOpt.substr(nIdx+1);
	}
	
	oMbar.subText[nMnu] = sPre + sOpt + sText;
	if (!b3Lines && (sId.length <= 1)) iMnu_Show(null, oMbar, '');
	return;	
}

var nZindex = 0;

function iMnu_Show(oNear, oMnu, subMenu)
{	var oDiv;
	var sHtml;
	var sText;
	var sLine;
	var nIdx;
	var nNext;
	var sCol1, sCol2, sCol3, sImg2;
	var lImg, sImg;
	var sOpt;
	var bDisabled;
	var nMnu;
	var nId;
	var sId;
	
	for (nMnu = 0; nMnu < oMnu.subMenu.length; nMnu++)
	{	if (oMnu.subMenu[nMnu] == subMenu) break;
	}

	if (nMnu >= oMnu.subMenu.length) return;
  
	if ((oMbarDiv) && (oMnu == oMbar) && (subMenu == ''))
	{	oDiv = oMbarDiv;
		if (!oDiv) return;
	}
	else
	{	oDiv = document.createElement('div');
		oDiv.className = 'iMenuDiv';
		nZindex++;
		oDiv.style.zIndex = 10 + nZindex;

		//set the inner styling of the div tag 

		oDiv.style.position="absolute";

		if (!oMnuDiv)
		{	if (iNmd_is_ie)
			{	document.attachEvent("onmousedown", iMnu_MseClr);
				document.attachEvent("onkeydown", iMnu_Clear);
			}
			else
			{	window.addEventListener("mousedown", iMnu_MseClr, true);
				window.addEventListener("keydown", iMnu_Clear, true);
			}
		}
		
		if ((!oNear) && (nMseX <= 0)) oNear = oFcs;
		
		if (oNear)
		{	if (oMnuDiv)
			{	oDiv.style.left = (iNmd_Left(oNear) + oNear.offsetWidth - 4) + 'px';
				oDiv.style.top = iNmd_Top(oNear) + 'px';
			}
			else
			{	if (oNear.id && (oNear.id ==  'id_3Lines')) oNear = i_Id('iTitle');
				oDiv.style.left = iNmd_Left(oNear) + 'px';
				oDiv.style.top = iNmd_Top(oNear) + oNear.offsetHeight + 'px';
			}
		}
		else
		{	oDiv.style.left = nMseX + 'px';
			oDiv.style.top = nMseY + 'px';
		}

		oDiv.in_oMnuParent = oMnuDiv;
		oMnuDiv = oDiv;
	}
		
	oDiv.in_oMnu = oMnu;
	oDiv.in_nMnu = nMnu;

	sText = oMnu.subText[nMnu] + ',';

	sHtml = '';
	nIdx = 0;

	nNext = -1;

	while (1)
	{	nIdx = nNext + 1;

		nNext = sText.indexOf(',', nIdx);
		if (nNext < 0) break;

		sLine = sText.substring(nIdx, nNext);

		if (sLine == '') 
		{	if (oDiv != oMbarDiv) sHtml += '<tr><td colspan=\'3\'><hr></td></tr>';
			continue;
		}

		sCol1 = '';
		sCol2 = '';
		sImg2 = '&nbsp;&#10003;';

		nIdx = sLine.indexOf('{');
		if (nIdx != -1)
		{	sImg = sLine.substr(nIdx + 1);
			lImg = sImg.indexOf('}');
			if (lImg != -1)
			{	sLine = sLine.substr(0, nIdx) + sImg.substr(lImg+1);	/* Remove image */
	
				sImg =  sImg.substr(0,lImg);

				nIdx = sImg.indexOf('|');
				if (nIdx != -1)
				{	sImg2 = '<img src="' + sImg.substr(nIdx + 1) + '">';
					sImg = sImg.substr(0, nIdx);
				}

				sCol1 = '<img src="' + sImg + '">';
				
			}
		}
		
		sCol3 = '&nbsp;&nbsp;';
		bDisabled = false;

		nIdx = sLine.indexOf('=',0);
		if (nIdx < 0)
		{	sCol2 = sLine;
			sOpt = '';
		}
		else
		{	sCol2 = sLine.substr(0,nIdx);
			sOpt = sLine.substr(nIdx+1).toUpperCase();
		}

		nIdx = sCol2.indexOf('&');

		nId = 0;

		if (nIdx < 0) 
			sId = 'Err';
		else
		{	sId = oMnu.subMenu[nMnu] + sCol2.charAt(nIdx+1).toUpperCase();
			for (var i = 0; i < oMnu.length; i++)
			{	if (sId == oMnu.subMenu[i])
				{	sCol3 = '&nbsp;&#9658;&nbsp;';
					break;
				}
			}
		}

		sCol2 = iNmd_HTML(sCol2.substr(0,nIdx) + sCol2.substr(nIdx+1));
		
		if (sOpt != '')
		{	var nIdx = sOpt.indexOf('C');
			if (nIdx != -1)
			{	sCol1 = sImg2;
				sOpt = sOpt.substr(0, nIdx) + sOpt.substr(nIdx+1);
			}
		    
			nIdx = sOpt.indexOf('B');
			if (nIdx != -1)
			{	sCol2 = '<strong>' + sCol2 + '</strong>';
				sOpt = sOpt.substr(0, nIdx) + sOpt.substr(nIdx+1);
			}
		    
			nIdx = sOpt.indexOf('G');
			if (nIdx != -1)
			{	sCol3 = '&nbsp;&#9658;&nbsp;';
				sOpt = sOpt.substr(0, nIdx) + sOpt.substr(nIdx+1);
			}
		    
			nIdx = sOpt.indexOf('D');
			if (nIdx != -1)
			{	bDisabled = true;
				sOpt = '';
			}
		    
			nId = parseInt(sOpt, 10);
		}

		nIdx = sCol2.indexOf('\t');
		if (nIdx != -1)
		{	sCol3 = sCol2.substr(nIdx+1) + sCol3;
			sCol2 = sCol2.substr(0, nIdx);
		}
		
		if (oDiv == oMbarDiv)
		{	if (bDisabled)
			{	sHtml += '<span class=\'iMenuDis\'>&nbsp;' + sCol2 + '&nbsp;</span>';
			}
			else
			{	sHtml += '<span class=\'iMenu\' onclick=\'iMnu_Click(event,"' + sId + '",' + nId + ');\'>&nbsp;' + sCol2 + '&nbsp;</span>';
			}
		}
		else
		{	if (bDisabled)
			{	sHtml += '<tr class=\'iMenuDis\'>';
			}
			else
			{	sHtml += '<tr class=\'iMenu\' onclick=\'iMnu_Click(event,"' + sId + '",' + nId + ');\'>';
			}

			sHtml += '<td width=\'20\'>' + sCol1 + '</td><td>' + sCol2 + '</td><td class="iMenuCol3">' + sCol3 + '</td></tr>';
		}
	}

	if (oDiv == oMbarDiv)
	{	oDiv.innerHTML = sHtml;
		oDiv.className = 'iMenuDiv';
		oDiv.style.display = 'block';
		return;
	}
	
	oDiv.innerHTML = '<table cellspacing=\'0\' cellpadding=\'0\'>' + sHtml + '</table>';
	
	i_AddNode(oDiv);
	setTimeout(iMnu_Pos, 10);
}

function iMnu_Pos()
{	var nLeft, nTop;
	if (!oMnuDiv) return;
	
	iNmd_GetSize();
	
	nLeft = iNmd_Left(oMnuDiv);
	nTop = iNmd_Top(oMnuDiv);

	if ((nLeft + oMnuDiv.offsetWidth + 10) >  wdwWd)
	{	if (oMnuDiv.in_oMnuParent) nLeft = iNmd_Left(oMnuDiv.in_oMnuParent);
		nLeft -= oMnuDiv.offsetWidth;
			
		oMnuDiv.style.left = nLeft + 'px';
	}

	if ((nTop + oMnuDiv.offsetHeight + 4) >  wdwHi)
	{	nTop = Math.max(0,wdwHi - oMnuDiv.offsetHeight - 4);
		oMnuDiv.style.top = nTop + 'px';
	}
}

function iMnu_Click(e, sId, nId)
{	var oTr;
	var oDiv;

	if (window.event)
	{	e = window.event;
		e.returnValue = false;
	}

	if (e.target) oTr = e.target; else oTr = e.srcElement;

	while (oTr)
	{	if (oTr.className == 'iMenu') break;
		oTr = oTr.parentNode;
	}

	if (!oTr) return false;

	oDiv = oTr.parentNode;

	while (oDiv)
	{	if (oDiv.in_oMnu) break;
		oDiv = oDiv.parentNode;
	}

	if (!oDiv) { alert('Cannot find div'); return false; }

	var oMnu = oDiv.in_oMnu;

	for (var nMnu = 0; nMnu < oMnu.length; nMnu++)
	{	if (oMnu.subMenu[nMnu] == sId) break;
	}

	if (nMnu >= oMnu.length)
	{	bPopup = false;
		AjxSend('M' + nId + ',' + sId);

		iMnu_Pop(null);
		return false;
	}

	if (oDiv.in_hilite) oDiv.in_hilite.className = 'iMenu';
	oDiv.in_hilite = oTr;
	oTr.className = 'iMenuOpen';

	iMnu_Pop(oDiv);
	iMnu_Show(oTr, oMnu, sId);

	return false;
}

function iMnu_MseClr(e)
{ var oObj;
  if (window.event) e = window.event;
  if (e.target) oObj = e.target; else oObj = e.srcElement;
  
  while (oObj)
  { if (oObj.in_oMnu) return;
    oObj = oObj.parentNode;
  }
  
  iMnu_Clear();
}

function iMnu_Clear()
{	iMnu_Pop(null);
	if (bPopup)
	{	AjxSend('M0,');
		bPopup = false;
	}
}
  
function iMnu_Pop(oDiv)
{	var oNxtDiv;
	
	if ((oDiv == null) && oMbarDiv)
	{	if (oMbarDiv.in_hilite)
		{	oMbarDiv.in_hilite.className = 'iMenu';
			oMbarDiv.in_hilite = null;
		}
	}
	
	while (oMnuDiv)
	{	if (oMnuDiv == oDiv) break;

		oNxtDiv = oMnuDiv.in_oMnuParent;
		oMnuDiv.parentNode.removeChild(oMnuDiv);
		oMnuDiv = oNxtDiv;
		if (oMnuDiv == null)
		{	if (iNmd_is_ie)
			{	document.detachEvent("onmousedown", iMnu_MseClr);
				document.detachEvent("onkeydown", iMnu_Clear);
			}
			else
			{	window.removeEventListener("mousedown", iMnu_MseClr, true);
				window.removeEventListener("keydown", iMnu_Clear, true);
			}
		}
	}

  return;
}

/* ============ iMnu object definition ========= */

function iMnu(sMenu)
{ var nStrt;
  var nFini;
  var nNext;
  var nImg;
  var lImg;
    
  var sMnu;
  var chMnu;
  var sImg;
  
  this.subMenu = new Array();
  this.subText = new Array();
  
  this.length = 0;
  
  nStrt = 0;
  while (1)
  { nNext = sMenu.indexOf('[', nStrt);
    if (nNext < 0) break;
    
    nFini = sMenu.indexOf(']', nNext);
    if (nFini < 0)
    { alert('Bad menu: ' + sMenu);
      break;
    }
  
	sMnu = sMenu.substring(nNext+1, nFini);
    this.subText[this.length] = sMnu;
    
    sMnu = '';
    if ((nNext > 0) && (sMenu.charAt(nNext-1) == ':'))
    { nNext--;
      while (nNext > 0)
      { chMnu = sMenu.charAt(--nNext);
        if ((chMnu == ',') || (chMnu == ']')) break;
        sMnu = chMnu + sMnu;
      }
    }
    
    this.subMenu[this.length] = sMnu.toUpperCase();
    
    this.length++;
    nStrt = nFini + 1;
  }
} 

/* *** Utility functions *** */

function iNmd_Signal(nId, sId)
{	AjxSend('S' + nId + ',' + sId,0);
}

function PropLog(objectname, oLog)
{	for (var prop in oLog)
	{	LOG(" " + oLog[prop], objectname + "." + prop)
	}
	return;
}

function PropDump(objectname, object) 
{	var wNew = window.open('','','height=600,width=800,toolbar=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=yes,location=no');
	var sVal;
	
	wNew.document.writeln('<html><body>');

	wNew.document.writeln("<table border=1 bgcolor=wheat><tr>");
	wNew.document.writeln("<td style='font-size: 18pt; font-weight: bold' colspan=2 align=center>");
	wNew.document.writeln("Properties of the <code>"+objectname+"</code> object</td></tr>");

	for (prop in object)
	{	if ((prop == 'innerHTML') || (prop == 'outerHTML'))
			sVal = "..suppressed..";
		else
			sVal =  object[prop];

		wNew.document.writeln("<tr><th>"+prop+"</th><td>" +  sVal +"</td></tr>");
	}

	wNew.document.writeln("</table><p>");
	wNew.document.writeln('</body></html>');
	wNew.document.close();
	return;
}

function iNmd_Top(oElm)
{	var y = parseInt(oElm.offsetTop);

	while (oElm = oElm.offsetParent)
	{	y += parseInt(oElm.offsetTop);
	}
	return y;
}

function iNmd_Left(oElm)
{	var x = parseInt(oElm.offsetLeft);
	while (oElm = oElm.offsetParent)
	{	x += parseInt(oElm.offsetLeft);
	}
	return x;
}

/* Window management */

var oChild;
var oDivMask = null;
var nBlocked = 0;

function iNmd_push(sSeq, nX, nY, nWd, nHi, sOpts)
{	iNmd_MaskScrn();

	if (bModalClose) oDivMask.onclick = iNmd_pop;
	if (oChild && oChild.closed) oChild = null;
	
	if (sSeq == 'Push')
	{	if (oChild) return;
	}
	
	AjxSeq++;

	if (sOpts.substr(0,3)== 'id=')
	{	iNmd_PopFrm(sSeq, nWd, nHi, sOpts);
		return;
	}
	
	if (nY < 0)
	{	nY = 0 - nY;
		
		if (nX < 0)
		{	nX = 0;
			if (oFcs)
			{	nY += iNmd_Top(oFcs);
				nX += iNmd_Left(oFcs);
			}
		}
				
		if (window.screenTop)
		{	nY = window.screenTop + nY;
			nX = window.screenLeft + nX;
		}
		else
		{	nY = window.screenY;
			nX = window.screenX + nX;
		}
	}
	else
	if (nX < 0)
	{	nX = (window.screen.availWidth - nWd) / 2;
		nY = (window.screen.availHeight - nHi - 20) / 2;
	}

	var oWdw = window.open(window.location.pathname + 
							'?_session=' + document.inomads._session.value +
							'&_seq=' + sSeq + '&_ajx=' + AjxSeq,
							'',	'top=' + nY +
							',left=' + nX +
							',height=' + nHi +
							',width=' + nWd +
							',modal' + (sOpts ? ',' + sOpts : '') );
/*							
							',toolbar=no,directories=no,location=0,status=0,menubar=no,scrollbars=yes,resizable=yes');
*/
	if (!oWdw)
	{	nBlocked++;
		iNmd_UnMask();
		if ((nBlocked % 10) == 1)
		{	alert("Unable to launch window.  Please disable your popup blocker for this site.");
		}
		
		setTimeout('iNmd_push("'+sSeq+'",'+nX+','+nY+','+nWd+','+nHi+');', 1000);
	}
	else
		nBlocked = 0;
	
	if (sSeq == 'Push') oChild = oWdw;
	
	return;
}

function iNmd_push2()
{	var oFrame = document.createElement('iframe');
	oFrame.style.position='absolute';
	oFrame.setAttribute('allowtransparency','true');
	oFrame.className = 'iPush2';
	oFrame.id = 'i_Push2';
	i_AddNode(oFrame);
	
	oFrame.src = window.location.pathname + 
			'?_session=' + document.inomads._session.value +
			'&_seq=' + 'Push' +
			'&_ajx=' + AjxSeq +
			'&_rnd=' + Math.round(Math.random() * 100000000);

	oChild = oFrame;
}

function iNmd_Push2Init()
{	var oDiv = i_Id('ch_' + sWdwObj);
	if (!oDiv) return;
	
	rcMain = parent.iNmd_Push2Rect();
	
	if (infoIframe.maximize)
	{	infoIframe.top  = rcMain.top - 1;
		infoIframe.left = (((rcMain.right - rcMain.left) - oDiv.offsetWidth) / 2) + rcMain.left;
	}
	else
	if (infoIframe.pos == "center")
	{	/* Use same logic as Maximize to center in Panel section if desired */
		/* Use this logic for full window center */
		infoIframe.top  = (window.innerHeight - oDiv.offsetHeight) / 2;
		infoIframe.left = (window.innerWidth - oDiv.offsetWidth) / 2;
	
	}
	else
	if (infoIframe.pos == "relative")
	{	var rcPanel = parent.i_Id('id_Panel').getBoundingClientRect();
		infoIframe.top = rcPanel.top + infoIframe.top;
		infoIframe.left = rcPanel.left + infoIframe.left;
	}
	else
	if (infoIframe.pos == "absolute")
	{	infoIframe.top = infoIframe.top;
		infoIframe.left = infoIframe.left;
	}
	else
	{	infoIframe.top = rcMain.top + infoIframe.top;
		infoIframe.left = rcMain.left + infoIframe.left;
	}

	var maxTop = window.innerHeight - oDiv.offsetHeight - 12;	/* Leave room for copyright */
	var maxLeft = window.innerWidth - oDiv.offsetWidth - 2;
	
	oDiv.style.top = Math.max(0, Math.min(infoIframe.top,maxTop) ) + 'px';
	oDiv.style.left = Math.max(0,Math.min(infoIframe.left,maxLeft) ) + 'px';
	
	oDiv.style.visibility = 'visible';
	
	i_Id('iTtlBlk').setAttribute('onmousedown','iNmd_Mve(event,"'+oDiv.id+'")');
}

function i_Move(top, left)
{	var oDiv = i_Id('ch_' + sWdwObj);
	if (!oDiv) return;

	rcMain = parent.iNmd_Push2Rect();
	
	infoIframe.top = rcMain.top + top;
	infoIframe.left = rcMain.left + left;

	oDiv.style.top = infoIframe.top + 'px';
	oDiv.style.left = infoIframe.left + 'px';
	return;
}

function iNmd_Push2Rect()
{	if (parent && (parent != window)  && parent.infoIframe) return parent.iNmd_Push2Rect();

	var rcRect = i_Id('id_Main').getBoundingClientRect();
	return {top: rcRect.top, left: rcRect.left, bottom:window.innerHeight, right: window.innerWidth};
}

function iNmd_Push2Exit(sSeq)
{	document.inomads._seq.value = sSeq;
	i_RmvNode(oChild);
	oChild = null;

	AjxSend('X',0);
	return;
}

function iNmd_PopFrm(sSeq, nWd, nHi, sOpts)	/* Under test */
{	var oDiv = i_Id(sOpts.substr(3));
	if (!oDiv) { alert("Cannot find:"+sOpts.substr(3)); return; }
	var rcDiv = oDiv.getBoundingClientRect();
	
	var oFrm = 	document.createElement('iframe');
	oDivMask.i_frme = oFrm;

	i_AddNode(oFrm);

	oFrm.className = 'iPopFrm';

	oFrm.style.top = rcDiv.bottom + 'px';
	oFrm.style.left = rcDiv.left + 'px';

	oFrm.src = window.location.pathname + '?_session=' + document.inomads._session.value + '&_seq=' + sSeq + '&_ajx=' + AjxSeq;

	if (sSeq == 'Push') oChild = oFrm;
}

function iNmd_pop()
{	if (oChild)
	{	if (oChild.closed)
		{	iNmd_resume('');
		}
		else
		{	if (!(oChild.oChild)) oChild.AjxSend('C-1999,0');
		}
	}
	
	return;
}

function iNmd_Rscu()
{	window.onunload = null;
	window.onbeforeunload = null;
	bIgnUnload = true;

	if (window.opener)
	{	window.close();
	}
	else
	{	window.location = 'syshtml/sys_rescued.htm';
	}
}

function iNmd_Rescue()
{	window.location = window.location.pathname + '?_session=' + document.inomads._session.value + '&_seq=Rscu';
	window.onunload = null;
	window.onbeforeunload = null;
	bIgnUnload = true;

	return;
}

function iNmd_resume(sSeq)
{	if (sSeq != '')
	{	document.inomads._seq.value = sSeq;
	}
	
	iNmd_UnMask();

	if (oChild)
	{	if (!oChild.closed) oChild.close();
	
		oChild = null;
	}

	AjxSend('X',0);
	return;
}

function iNmd_close(sSeq)
{	if (infoIframe)
	{	window.onbeforeunload = null;
		window.onunload = null;
		bIgnUnload = true;

		parent.iNmd_Push2Exit(sSeq);
		return;	
	}

	if (sTruSeq || (document.inomads._seq.value != sSeq))
	{	iNmd_UnMask();
		AjxSend('X',1);
		
		document.inomads._seq.value = sSeq;
		return;
	}
	
	try
	{	if (window.opener.oChild == window)
		{	window.onunload = null;
			window.onbeforeunload = null;
			bIgnUnload = true;

			window.close();
			
			window.opener.iNmd_resume(sSeq);
			return;
		}
	}
	catch(err)
	{
	}
	
	document.inomads._seq.value='Exit';
	iNmd_Submit('Exit');
	return;
}

function iNmd_Disable(sId, nSts, sClass)
{	var oObj = i_Id(sId);
	if (oObj)
	{	if ((nSts) && (oFcs == oObj)) iNmd_TabTrap(oFcs);

		if (oObj.disabled != nSts)
		{	var oDiv = i_Id('dw_'+sId.substr(3));
			if (!oDiv) oDiv = i_Id('dv_'+sId.substr(3));
			if (oDiv)
			{	if (nSts)
					oDiv.setAttribute('data-disabled','true');
				else
					oDiv.removeAttribute('data-disabled');
			}
		}
		
		if ((oObj.nodeName == 'DIV') || (oObj.nodeName == 'TABLE'))
		{	if (nSts)
				oObj.setAttribute('data-disabled','true');
			else
				oObj.removeAttribute('data-disabled');
		}
						
		oObj.disabled = nSts;
		if (sClass)	oObj.className = sClass;
	}
}

function iNmd_Lock(sId, nSts)
{	var oObj = i_Id(sId);
	if (oObj)
	{	if (nSts)
		{	oObj.readOnly = true;
			if (oObj.getAttribute('nmdLock')) oObj.setAttribute('nmdLock', 'true');
		}
		else
		{	oObj.readOnly = false;
			if (oObj.getAttribute('nmdLock')) oObj.setAttribute('nmdLock', 'false');
		}
	}
}

var oDivMbox;
var nMbxTimer;
var idMbxTimer = null;
var nBarSts = 0;
var nBarMax = -1;
var nBarCur = 0;

function iNmd_Msgbox(sHtml, nFocus, nTimer, sAlign)
{	if (oPopMask)
	{	oPopMask.parentNode.removeChild(oPopMask);
		oPopMask = null;
	}
	
	var oDiv = i_Id('pb_Bar');

	iNmd_MaskScrn();
	
	oDivMask.onclick = i_IgnEvent;
	
	oDivMbox = document.createElement('div');
	oDivMbox.className = 'iMbxDiv';
	oDivMbox.style.visibility = 'hidden';

	oDivMbox.innerHTML = sHtml;
	
	oDivMbox.style.position='absolute';
	if (oDiv)
		oDivMbox.style.zIndex = 20;
	else
		oDivMbox.style.zIndex = 10;

	oDivMbox.style.left = '0px';
	oDivMbox.style.top = '0px';
	
	if (sAlign) oDivMbox.in_align = sAlign;
	
	i_AddNode(oDivMbox);

	if (!oDiv)
	{	oDiv = i_Id('pb_Bar');
		if (oDiv)
		{	nBarMax = oDiv.offsetWidth;
			nBarCur = 0;
			oDiv.style.width = '1px';
			nBarSts = 0;
		}
	}
	
	
	setTimeout('iNmd_MbxSize('+nFocus+');',20);
	if (nTimer)
	{	nMbxTimer = nTimer;
		idMbxTimer = setInterval(iNmd_MbxTime,1000);
	}
}

function iNmd_MbxSize(nFocus)
{	if ((oDivMbox.offsetWidth / oDivMask.offsetWidth) > .75)
	{	if (oDivMask.offsetWidth > 500) 
			oDivMbox.style.width = Math.floor(oDivMask.offsetWidth * .75) + 'px';
	}
	else
	if (oDivMbox.offsetWidth < 200) 
		oDivMbox.style.width = '200px';
	
	var nTop = (oDivMask.offsetHeight - oDivMbox.offsetHeight) / 2;
	var nLeft = (oDivMask.offsetWidth - oDivMbox.offsetWidth) / 2;
	
	if (oDivMbox.in_align)
	{	if (oDivMbox.in_align.indexOf("T") != -1)
			nTop = 5;
		else
		if (oDivMbox.in_align.indexOf("B") != -1)
			nTop = oDivMask.offsetHeight - oDivMbox.offsetHeight - 5;
		
		if (oDivMbox.in_align.indexOf("L") != -1)
			nLeft = 5;
		else
		if (oDivMbox.in_align.indexOf("R") != -1)
			nLeft = oDivMask.offsetWidth - oDivMbox.offsetWidth - 5;
	}
	
	var nTop = Math.max(5,iNmd_Top(oDivMask) + nTop);
	var nLeft = Math.max(5, iNmd_Left(oDivMask) + nLeft);
		
	oDivMbox.style.top = nTop + 'px';
	oDivMbox.style.left = nLeft + 'px';
	
	oDivMbox.style.visibility = 'visible';

	i_AddEvent(oDivMbox, 'mousedown', iNmd_MbxMseDwn, true);

	var oBtn = i_Id('mb_' + nFocus);
	if (oBtn) oBtn.focus();
}

function iNmd_MbxMseDwn(e)
{	if (window.event) e = window.event;

	var oDiv = (e.target ? e.target : e.srcElement);
	if (oDiv.id) return;
	oMse = oDivMbox;
	return iNmd_MveStrt(e);
}

function iNmd_Mve(e, sId)
{	if (window.event) e = window.event;
	var oDiv = (e.target ? e.target : e.srcElement);
	if (oDiv.id && (oDiv.id == 'id_3Lines')) return;

	oMse = i_Id(sId);
	if (!oMse) return;

	if (oMseOnTop) oMseOnTop.style.zIndex = oMseOnTop.in_z;
	oMseOnTop = oMse;
	
	oMse.in_z = oMse.style.zIndex;
	oMse.style.zIndex = 100;
	
	return iNmd_MveStrt(e);
}

var bMbxMse = false;
function iNmd_MveStrt(e)
{	i_AddEvent(window, 'mousemove', iNmd_MbxMseMove, true);
	i_AddEvent(window, 'mouseup', iNmd_MbxMseUp, true);
	bMbxMse = true;
	
	iNmd_MseXY(e);
	nMseDwnX = nMseX; /* - iNmd_Left(oMse); */
	nMseDwnY = nMseY; /*  - iNmd_Top(oMse); */
	nOrigX = parseInt(oMse.style.left,10);
	nOrigY = parseInt(oMse.style.top,10);

	if (e.stopPropagation) e.stopPropagation();
	if (e.preventDefault) e.preventDefault();
	return e.returnValue = false;
}

function iNmd_MbxMseUp(e)
{	if (window.event) e = window.event;

	i_RmvEvent(window, 'mousemove', iNmd_MbxMseMove, true);
	i_RmvEvent(window, 'mouseup', iNmd_MbxMseUp, true);
	bMbxMse = false;
	
	oMse.style.zIndex = oMse.in_z;
	
	if (oMse.id) 
	{	rcMse = oMse.getBoundingClientRect();
		if (rcMain)
		{	if (oMse.getAttribute('data-child'))
			{	var rcWdw = i_Id('ch_' + sWdwObj).getBoundingClientRect();
				iNmd_Signal(oMse.id.substr(3), 'Mve:' + (rcMse.left - rcWdw.left) + ',' + (rcMse.top - rcWdw.top) + ',Child');
			}
			else				
			{	iNmd_Signal(oMse.id.substr(3), 'Mve:' + (rcMse.left - rcMain.left) + ',' + (rcMse.top - rcMain.top));
			}
		}
		else
		{	var oPnl = i_Id('id_Root');
			iNmd_Signal(oMse.id.substr(3), 'Mve:' + (iNmd_Left(oMse) - iNmd_Left(oPnl)) + ',' + (iNmd_Top(oMse) - iNmd_Top(oPnl)));
		}
	}
	
	oMse = null;
}

function iNmd_MbxMseMove(e)
{	if (window.event) e = window.event;
	if (!oMse) return false;

	iNmd_MseXY(e);

	oMse.style.left = (nMseX - nMseDwnX) + nOrigX + 'px';
	oMse.style.top  = (nMseY - nMseDwnY) + nOrigY + 'px';

	if (e.stopPropagation) e.stopPropagation();
	if (e.preventDefault) e.preventDefault();
	return e.returnValue = false;
}

oSizeDiv = null;

function iNmd_Sze(e, sId)
{	if (window.event) e = window.event;
	oMse = i_Id(sId);
	if (!oMse) return;
	
	i_AddEvent(window, 'mousemove', iNmd_SzeMove, true);
	i_AddEvent(window, 'mouseup', iNmd_SzeUp, true);

	nMinX = nMinY = 0;
	
	var sMin = oMse.getAttribute('data-minHi');
	if (sMin) nMinY = parseInt(sMin, 10) + i_Id('iTitle').offsetHeight;
	
	sMin = oMse.getAttribute('data-minWd');
	if (sMin) nMinX = parseInt(sMin, 10);

	oSizeDiv =  document.createElement('div');
	oSizeDiv.id = 'iSizeDiv';
	oSizeDiv.style.width = oMse.offsetWidth + 'px';
	oSizeDiv.style.height = oMse.offsetHeight + 'px';
	
	i_AddNode(oSizeDiv, oMse);
	i_AddNode(i_Id('iSizeDrag'), oSizeDiv);
	
	iNmd_MseXY(e);

	nMseDwnX = iNmd_Left(oMse);
	nMseDwnY = iNmd_Top(oMse);

	if (e.stopPropagation) e.stopPropagation();
	if (e.preventDefault) e.preventDefault();
	return e.returnValue = false;
}

function iNmd_SzeUp(e)
{	if (window.event) e = window.event;

	i_RmvEvent(window, 'mousemove', iNmd_SzeMove, true);
	i_RmvEvent(window, 'mouseup', iNmd_SzeUp, true);

	var wd = oSizeDiv.offsetWidth;
	var hi = oSizeDiv.offsetHeight;
	oMse.style.width = wd + 'px';
	oMse.style.height = hi + 'px';

	i_AddNode(i_Id('iSizeDrag'), oMse);
	i_RmvNode(oSizeDiv);
	oSizeDiv = null;

	if (infoIframe)
	{	var rcPanel = i_Id('ch_' + sWdwObj).getBoundingClientRect();
		hi = hi + ',Pos,' + (rcPanel.left - rcMain.left) + ',' + (rcPanel.top - rcMain.top);
	}
		
	iNmd_Signal(oMse.id.substr(3), 'Sze:' + wd + ',' + hi);
	oMse = null;
}

function iNmd_SzeMove(e)
{	if (window.event) e = window.event;
	if (!oMse) return false;

	iNmd_MseXY(e);

	oSizeDiv.style.width = Math.max(50, nMinX, (nMseX - nMseDwnX)) + 'px';
	oSizeDiv.style.height  = Math.max(20, nMinY, (nMseY - nMseDwnY)) + 'px';

	if (e.stopPropagation) e.stopPropagation();
	if (e.preventDefault) e.preventDefault();
	return e.returnValue = false;
}

function iNmd_MbxTime()
{	nMbxTimer--;
	if (nMbxTimer <= 0)
	{	iNmd_MbxDrop();
		AjxSend('C0,0',0);
		return;
	}
	
	var oText = i_Id('mb_timer');
	
	if (oText) 
	{	var nMn;
		var nSec;
		nSec = nMbxTimer % 60;
		nMn = (nMbxTimer - nSec) / 60;
		
		oText.innerHTML = nMn.toString(10) + ':' + (nSec + 100).toString(10).substr(1);
	}
}		

function iNmd_MbxClk(e)
{	var	oBtn = e.target ? e.target :  e.srcElement;
    var sBtn = oBtn.id.substr(3);
    
    oMbxBtn = null;
    oMbxFcs = false;
    
	if (oDivMbox)
	{	iNmd_MbxDrop();
		AjxSend('C' + sBtn + ',0',0);
	}
	else
	{	iNmd_Submit(sBtn);
	}
	return true;
/*	e.returnValue = false;			
	return false;
*/
}

function iNmd_MbxDrop()
{	oMbxBtn = null;
    oMbxFcs = false;
    
	if (oDivMbox)
	{	i_RmvEvent(oDivMbox, 'mousedown', iNmd_MbxMseDwn, true);
	
		if (bMbxMse)
		{	i_RmvEvent(window, 'mousemove', iNmd_MbxMseMove, true);
			i_RmvEvent(window, 'mouseup', iNmd_MbxMseUp, true);
			bMbxMse = false;
		}
		
		oDivMbox.innerHTML = "";
		
		oDivMbox.parentNode.removeChild(oDivMbox);
		oDivMbox = null;

		if (idMbxTimer)
		{	clearInterval(idMbxTimer);
			idMbxTimer = null;
		}
	}
			
	iNmd_UnMask();
}

function iNmd_MbxFcs(e)
{	oMbxBtn = e.target ? e.target : e.srcElement;
	oMbxFcs = true;
	return;
}
function iNmd_MbxBlr(e)
{	oMbxFcs = false;
	setTimeout(iNmd_MbxChkFcs, 100);
}
function iNmd_MbxChkFcs()
{	if (oDivMbox)
	{	if (!oMbxFcs && !oMbxFcsIgn)
		{	try
			{	oMbxBtn.focus(); 
				setTimeout(iNmd_MbxChkFcs, 500);
			}
			catch(err) { } 
		}
	}
}

function iNmd_PrgBar(sText, nPct)
{	if (nPct < -1) 
	{	iNmd_MbxDrop();
		return;
	}
	
	var oText = i_Id('pb_Text');
	if (oText) oText.innerHTML = sText;
	
	var oDiv = i_Id('pb_Bar');
	if (oDiv)
	{	if (nPct == -1) 
		{	nPct = nBarCur + 5;
			if (nPct > 100) nPct = 5;
		}
		nBarCur = Math.min(100,nPct);
		nPct = ((nBarCur * nBarMax) / 100);
		oDiv.style.width = nPct + 'px';
	}
	
	AjxSend('C' + nBarSts + ',0', -1);
	return;
}

function iNmd_PbrClk(e)
{	nBarSts = 1;
	if (window.event) e.returnValue = false;
	return false;
}

function iNmd_MaskScrn()
{	var oDiv = document.createElement('div');

	oDiv.i_next = oDivMask;
	oDiv.i_mbox = oDivMbox;

	oDivMbox = null;
	oDivMask = oDiv;
	
	oDivMask.style.position='absolute';

	oDivMask.style.left = 0;
	oDivMask.style.top = 0;

	iNmd_GetSize()
		
	oDivMask.style.width = '100%';
	oDivMask.style.height = '100%';

	oDivMask.className = 'iCmnMask';
	
	i_AddNode(oDivMask);

	oDivMask.innerHTML = "<a class='iCmnVal' id='id_Dead' href='#' onkeydown='i_IgnEvent(event);' onkeyup='i_IgnEvent(event);'>&nbsp;</a>";	
	i_Id('id_Dead').focus();
	
	setTimeout(function ()
	{	if (!oDivMask) return;
		
		var nWd = oDivMask.offsetWidth;
		var nHi = oDivMask.offsetHeight;
		var oRoot = i_Id('id_Root');
		if (oRoot)
		{	var n = iNmd_Left(oRoot) + oRoot.offsetWidth;
			if (nWd < n) nWd = n;
			n = iNmd_Top(oRoot) + oRoot.offsetHeight;
			if (nHi < n) nHi = n;
		}
		oDivMask.style.width = nWd + 'px';
		oDivMask.style.height = nHi + 'px';
	}, 20);
	
	return;
}

function iNmd_UnMask()
{	if (oDivMask)
	{	oDivMbox = oDivMask.i_mbox;
		
		var oFrm = oDivMask.i_frme;
		if (oFrm) oFrm.parentNode.removeChild(oFrm);
		
		var oDiv = oDivMask.i_next;

		oDivMask.parentNode.removeChild(oDivMask);
		oDivMask = oDiv;

		if (oFcs && !oDivMask)
		{	bIgnoreFcs = 1;
			if (oFcs.focus)
			{	try { iFocus(oFcs); }
				catch(err) { bIgnoreFcs = 0; } 
			}
		}
		if (!oDiv && bMaskResize)
		{	bMaskResize = false;
			iNmd_Resize();
		}
	}
}

function i_IgnEvent(e)
{	if (window.event) e = window.event;
	if (e.stopPropagation) e.stopPropagation();
	if (e.preventDefault) e.preventDefault();
	e.cancelBubble = true;
    e.cancel = true;
	e.returnValue = false;
	return false;
}

/* Calculator */

var oDivCalc = null;

var oVal = null;

function iClc_Pop(sId)
{	var oObj = i_Id(sId);
	if (oObj) iClc_do(oObj);
}

function iClc_do(oQry)
{	var sId = oQry.id;
	var oObj;
	var sVal;
	
	if (sId.substr(0,2) == 'gc')
	{	oObj = oQry;
		sVal = i_Text(oObj);
	}
	else
	{	oObj = i_Id('id_' + sId.substr(3));
		sVal = oObj.value;
	}
	
	if (window.event) window.event.returnValue = false;
	if (!oObj) return false;
	if (oObj.disabled) return false;
	
	var nTop = iNmd_Top(oObj) + oObj.offsetHeight;
	var nLeft = iNmd_Left(oObj);
	
	iNmd_MaskScrn();
	oDivMask.onclick = iClc_Exit;
	
	oDivCalc = document.createElement('div');
	oDivCalc.className = 'iClcDiv';

	oDivCalc.innerHTML =
		"<table class='iClcFrame'><tr><td>" +
		"<table class='iClcBtns'>" +
		"<tr><td colspan='4'><input id='ic_Val' class='iClcInp' type='text' name='Val'></div></td>" +
		"<td id='ic_Rtrn' class='iClcBtn' onclick='iClc_Rtrn();'>&nbsp;</td>" +
		"<td id='ic_Exit' class='iClcBtn' onclick='iClc_Exit();'>&nbsp;</td></tr>" +
		"<tr><td class='iClcBtn' onclick='iClc_Dig(\"1\");'>1</td>" +
		"<td class='iClcBtn' onclick='iClc_Dig(\"2\");'>2</td>" +
		"<td class='iClcBtn' onclick='iClc_Dig(\"3\");'>3</td>" +
		"<td>&nbsp</td>" +
		"<td class='iClcBtn' onclick='iClc_Opr(\"+\");'>+</td>" +
		"<td class='iClcBtn' onclick='iClc_Fnc(\"1/\");'>1/x</td></tr>" +
		"<tr><td class='iClcBtn' onclick='iClc_Dig(\"4\");'>4</td>" +
		"<td class='iClcBtn' onclick='iClc_Dig(\"5\");'>5</td>" +
		"<td class='iClcBtn' onclick='iClc_Dig(\"6\");'>6</td>" +
		"<td>&nbsp</td>" +
		"<td class='iClcBtn' onclick='iClc_Opr(\"-\");'>-</td>" +
		"<td class='iClcBtn' onclick='iClc_Fnc(\"0-\");'>+/-</td></tr>" +
		"<tr><td class='iClcBtn' onclick='iClc_Dig(\"7\");'>7</td>" +
		"<td class='iClcBtn' onclick='iClc_Dig(\"8\");'>8</td>" +
		"<td class='iClcBtn' onclick='iClc_Dig(\"9\");'>9</td>" +
		"<td>&nbsp</td>" +
		"<td class='iClcBtn' onclick='iClc_Opr(\"*\");'>x</td>" +
		"<td class='iClcBtn' onclick='iClc_Fnc(\"Math.sqrt\");'>&radic;</td></tr>" +
		"<tr><td class='iClcBtn' onclick='iClc_Clr();'>c</td>" +
		"<td class='iClcBtn' onclick='iClc_Dig(\"0\");'>0</td>" +
		"<td class='iClcBtn' onclick='iClc_Dig(\".\");'>.</td>" +
		"<td>&nbsp</td>" +
		"<td class='iClcBtn' onclick='iClc_Opr(\"/\");'>/</td>" +
		"<td class='iClcBtn' onclick='iClc_Fnc(\"\");'>=</td></tr></table>" +
		"</td></tr></table>";
		
	oDivCalc.style.position='absolute';
	oDivCalc.style.top = nTop + 'px';
	oDivCalc.style.left = nLeft + 'px';
	
	i_AddNode(oDivCalc);
	
	oDivCalc.in_obj = oObj;

	oVal = i_Id('ic_Val');
	
	if (sVal)
	{	var cVal;
		for (var n = 0; n < sVal.length; n++)
		{	cVal = sVal.substr(n,1);
			if ('0123456789.-+'.indexOf(cVal) != -1) oVal.value += cVal;
		}
	}
	
	oVal.in_sts = 1;
	oVal.onkeypress = iClcEvt;
	oVal.onkeydown = iClcEvt;
	
	iClc_Fcs(oVal);
	
	return false;
}

function iClcEvt(e)
{	var cKey;
	
	if (window.event) e = window.event;
	if (e.type == 'keypress')
	{	cKey = (!iNmd_is_ie) ? e.which : e.keyCode;
		
		if (cKey == 13) 
		{	if (oVal.in_sts)
				iClc_Rtrn();
			else
				iClc_Fnc('');
		}
		else
		if (cKey == 27)
			iClc_Exit();
		else
		if (cKey != 9)
		{	oVal.in_sts = 0;
			 return true;
		}
	}
	
	if (e.type == 'keydown')
	{	cKey = (!iNmd_is_ie) ? e.which : e.keyCode;
		if (cKey != 9) return true;
	}
	
	if (e.stopPropagation) e.stopPropagation();
	if (e.preventDefault) e.preventDefault();
	e.cancelBubble = true;
    e.cancel = true;
	e.returnValue = false;
	return false;
}


function iClc_Dig(sDig)
{	if (oVal.in_sts) iClc_Clr();

	oVal.in_sts = 0;
	oVal.value += sDig;
		
	iClc_Fcs(oVal);
	if (iNmd_is_ie) 
	{	window.event.srcElement.ondblclick = Function('iClc_Dig("' + sDig + '");');
	}
}

function iClc_Clr()
{	oVal.value = '';
	oVal.className = 'iClcInp';
	oVal.in_sts = 0;
		
	iClc_Fcs(oVal);
}

function iClc_Opr(sOpr)
{	if (oVal.className != 'iClcInp') return;
 
 	oVal.in_sts = 0;
	oVal.value += ' '+ sOpr + ' ';
	iClc_Fcs(oVal);
}

function iClc_Fnc(sOpr)
{	if (oVal.value.toUpperCase() != oVal.value.toLowerCase())
	{	oVal.className = 'iClcErr';
	}
	else	
	try
	{	oVal.value = eval( sOpr + '(' + oVal.value + ')');

		if (isFinite(oVal.value))
			oVal.className = 'iClcInp';	
		else
			oVal.className = 'iClcErr';
	}
	catch(err)
	{	oVal.className = 'iClcErr';
	}
	
	oVal.in_sts = 1;
	iClc_Fcs(oVal);
}

function iClc_Fcs(oObj)
{	oObj.focus();
	
	var nLen = oObj.value.length;
	if (nLen == 0) return;
	
	if ('selectionStart' in oObj)
	{	oObj.selectionStart = nLen;
		oObj.selectionEnd = nLen;
	}
	else
	if (document.selection)
	{	var oRng = document.selection.createRange();
		if (oRng)
		{	oRng.moveStart("character", nLen);
			oRng.moveEnd("character", nLen);
			oRng.select();
		}
	}

	return;
}
function iClc_Rtrn()
{	iClc_Fnc('');
	if (oVal.className != 'iClcInp') return;
	
	var oObj = oDivCalc.in_obj;
	var sVal = oVal.value;
	
	iClc_Exit();
	
	if (oObj.id.substr(0,2) == 'gc')
		AjxSend('S' + oObj.id.substr(3,5) + ',Chg:0,' + sVal, 0);
	else
	{	oObj.value = sVal;
		AjxSend('C' + oObj.id.substr(3) + ',0:' + sVal, 0);
	}
}

function iClc_Exit()
{	oVal = null;
	oDivCalc.parentNode.removeChild(oDivCalc);
	oDivCalc = null;
			
	iNmd_UnMask();
}

/* Date/Calendar */

var oDivDate = null;
var nMo, nYr, nDy;
var mxDy = 31;

function iDte_do(oQry, sfmt)
{	if (window.event) window.event.returnValue = false;
	if (!oQry) oQry = oFcs;
	iDte_Pop('id_' + oQry.id.substr(3), sfmt);
	return false;
}

function iDte_Pop(sId, sDteFmt)
{	var oObj = i_Id(sId);
	if (!oObj) { alert('Cannot find ' + sId); return; }

	if (oObj.disabled) return;

	if (oFcs != oObj) oObj.focus();
	
	var nTop = iNmd_Top(oObj) + oObj.offsetHeight;
	var nLeft = iNmd_Left(oObj);

	iNmd_MaskScrn();

	oDivMask.onclick = iDte_Exit;
	oDivMask.innerHTML = "<input id='id_Dead' class='iCmnVal' type='text' onkeydown='iDte_Evt(event);' onkeyup='iDte_Evt(event);'>";
	
	oDivDate = document.createElement('div');
	oDivDate.className = 'iDteDiv';

	if (!sDteFmt) sDteFmt = 'CYMD';

	if (sId.substr(0,2) == 'gc')
		iDte_Load(i_Text(oObj), oObj, sDteFmt);
	else
		iDte_Load(oObj.value, oObj, sDteFmt);
		
	oDivDate.innerHTML = iDte_Html(nYr, nMo, nDy);

	oDivDate.style.position='absolute';
	oDivDate.style.top = nTop + 'px';
	oDivDate.style.left = nLeft + 'px';
	
	i_AddNode(oDivDate);
	
	oDivDate.in_obj = oObj;
	oDivDate.in_dead = i_Id('id_Dead');
	iDteDead();
	
	oDivDate.in_fmt = sDteFmt;
	return;
}

function iDteDead()
{	if (oDivDate) oDivDate.in_dead.focus();
	return false;
}

function iDte_Evt(e)
{	if (window.event) e = window.event;

	if (e.type != 'keydown') { iDteDead(); return i_IgnEvent(e); }
	var cKey = (!iNmd_is_ie) ? e.which : e.keyCode;

	switch(cKey)
	{	case 40:	/* Down arrow */
			if ((e.ctrlKey || e.shiftKey))
			{	nYr++;
				break;
			}
			nDy += 6;
		case 39:	/* Rght arrow */
			nDy++;
			if (nDy <= mxDy) break;
			nDy -= mxDy;
		case 33:	/* Page up */
			if (nMo >= 12) 
			{	nMo = 1; nYr++; }
			else
			{	nMo++; }
			break;

		case 38:	/* Up arrow */
			if ((e.ctrlKey || e.shiftKey))
			{	nYr--;
				break;
			}
			nDy -= 6;
		case 37:	/* Back arrow */
			nDy--;
			if (nDy > 0) break;

		case 34:	/* Page dn */
			if (nMo <= 1) 
			{	nMo = 12; nYr--; }
			else
			{	nMo--; }
			break;
			
		case 27:	/* Escape */
			iDte_Exit();
			return;

		case 13:	/* Return */
			iDteClk(0);
			return true;

		default:
			return;
	}
	oDivDate.innerHTML = iDte_Html(nYr, nMo, nDy);

	return i_IgnEvent(e);
}

function iDte_Html(nwYr, nwMo, nwDy)
{	nYr = nwYr;
	nMo = nwMo;

	if ((nwMo == 1) || (nwMo == 3) || (nwMo == 5) || (nwMo == 7) ||(nwMo == 8) || (nwMo == 10) || (nwMo == 12))
		mxDy = 31;
	else
	if (nwMo != 2)
		mxDy = 30;
	else
	if ((nwYr%4) != 0)
		mxDy = 28;
	else
		mxDy = 29;
	
	if (nwDy <= 0)
		nwDy = mxDy + nwDy;
	else
	if (nwDy > mxDy)
		nwDy = mxDy;

	nDy = nwDy;
	
	nwMo--;
	
	var oDt = new Date(nwYr, nwMo, 1);
	oDt.setHours(2);			/* Force 2AM to avoid Daylight Savings issues */
	oDt.setTime(oDt.getTime() - (86400000 * oDt.getDay()));

	var sHtml = "<table class='iDteTbl'>";
	sHtml += "<tr class='iDteHdr'><td class='iDteDay'><div class='iDteArw' onclick='iDtePrv();'>&laquo;<div></td>";
	sHtml += "<td colspan='5' class='iDteMon'>" + 
		"<span onclick='iDteMo(event);'>" + window.in_mths[nwMo] + "</span> " +
		"<span onclick='iDteYr(event);'>" + nYr+"</span></td>";
	sHtml += "<td class='iDteDay'><div class='iDteArw' onclick='iDteNxt();'>&raquo;</div></td></tr>";
	
	var oToday = new Date();
	var nToday = -1;
	
	if ((oToday.getMonth() == nwMo) && (oToday.getFullYear() == nwYr))
		nToday = oToday.getDate();

	var sWrk = '<tr>';
	var d;
	var n;
		
	for (n=0; n<7; n++)
	{	sWrk += "<th class='iDteDay' onclick='iDteDead();'><div class='iDteOky'>"+window.in_wkdy.charAt(n)+"</div></th>";
	}
	sHtml += sWrk + '</tr>';
	
	for (var nLin=6; nLin>0; nLin--)
	{	sHtml+="<tr>";
	
		for (n=7; n>0; n--)
		{	d = oDt.getDate();
		
			if (oDt.getMonth() != nwMo)
				sWrk = "<div class='iDteBad' onclick='iDteDead();'>" + d + "</div>";
			else
			{	if (d == nwDy)
					sWrk = "iDteSel";
				else
				if (d == nToday)
					sWrk = "iDteNow";
				else
					sWrk = "iDteOky";
				
				sWrk = "<div class='" + sWrk + "' onclick='iDteClk(" + d + ");'>" + d + "</div>";
			
			}
			sHtml +=  "<td class='iDteDay'>" + sWrk + "</td>";
			oDt.setDate(d + 1);

		}
		sHtml+="</tr>"
	}
	return sHtml+"</table>";
}

var oDteDiv = null;

function iDteMo(e)
{	if (window.event) e = window.event;

	var sHtml = "";
	var n = nMo - 1;
	for (var i = 0; i < 12; i++)
	{	sHtml += "<option" + ((i == n) ? " selected='yes' " : "") + " value='" + i + "'>" + window.in_mths[i] + "</option>";
	}
	iDteDrp(e, sHtml);
	return;
}

function iDteYr(e)
{	if (window.event) e = window.event;

	var sHtml = "";
	for (var i = nYr - 50; i < (nYr + 50); i++)
	{	sHtml += "<option" + ((i == nYr) ? " selected='yes' " : "") + " value='" + i + "'>" + i + "</option>";
	}
	iDteDrp(e, sHtml);
	return;
}

function iDteDrp(e, sHtml)
{	if (oDteDiv)
	{	oDteDiv = i_RmvNode(oDteDiv);
		return;	
	}
	
	var oSpan = e.target ? e.target : e.srcElement;
	var oDteDiv = document.createElement('div');
	
	oDteDiv.className = 'iGridDrop';

	oDteDiv.style.position='absolute';
	oDteDiv.style.zIndex = 10;

	oDteDiv.style.top = iNmd_Top(oSpan) - iNmd_Top(oDivDate) + 'px';
	oDteDiv.style.left = iNmd_Left(oSpan) - iNmd_Left(oDivDate) + 'px';

	sHtml = "<select id='dt_list' size='7' class='iGridList'" +
			" onclick='iDteDrpExit();' " +
			" onblur='iDteDrpExit();'>" + 
			sHtml + "</select>"; 
	
	oDteDiv.innerHTML = sHtml;

	i_AddNode(oDteDiv, oDivDate);
	
	var oLst = i_Id('dt_list');
	oLst.focus();
	oLst.scrollTop = (oLst.selectedIndex * (1 + oLst.scrollHeight)) / oLst.length;
}

function iDteDrpExit(e)
{	var n = parseInt(i_Id('dt_list').value,10);
	if (n < 12) 
		nMo = n + 1;
	else
		nYr = n;

	oDivDate.in_dead.focus();
	oDivDate.innerHTML = iDte_Html(nYr, nMo, nDy);

	oDteDiv = i_RmvNode(oDteDiv);
	return;
}

function iDtePrv()
{	nMo--;
	if (nMo == 0)
	{	nYr--;
		nMo = 12;
	}

	oDivDate.innerHTML = iDte_Html(nYr, nMo, nDy);
	if (iNmd_is_ie) window.event.srcElement.ondblclick = Function('iDtePrv();');
	oDivDate.in_dead.focus();
}

function iDteNxt()
{	nMo++;
	if (nMo > 12)
	{	nYr++;
		nMo = 1;
	}

	oDivDate.innerHTML = iDte_Html(nYr, nMo, nDy);
	if (iNmd_is_ie) window.event.srcElement.ondblclick = Function('iDteNxt();');
	oDivDate.in_dead.focus();
}

function iDteClk(nwDy)
{	if (nwDy != 0) nDy = nwDy;

	var oObj = oDivDate.in_obj;
	var sFmt = oDivDate.in_fmt;

	nMo += 100;
	nDy += 100;

	var sYr = nYr.toString(10);
	var sMo = nMo.toString(10);
	var sDy = nDy.toString(10);
	
	sVal = '';
	for (var n = 0; n < sFmt.length; n++)
	{	var cFmt = sFmt.substr(n,1);
		if (cFmt == 'C')
			sVal += sYr.substr(0,2);
		else
		if (cFmt == 'Y')
			sVal += sYr.substr(2,2);
		else
		if (cFmt == 'M')
			sVal += sMo.substr(1);
		else
		if (cFmt == 'D')
			sVal += sDy.substr(1);
		else
			sVal += cFmt;
	}

	if (typeof user_DateOut == 'function') sVal = user_DateOut(sVal);
	
	iDte_Exit();
	
	if (oObj.id.substr(0,2) == 'gc')
		AjxSend('S' + oObj.id.substr(3,5) + ',Chg:13,' + sVal, 0);
	else
	{	oObj.value = sVal;
		oObj.in_oldval = iNmd_Val(oObj);

		AjxSend('C' + oObj.id.substr(3) + ',13:' + sVal, 0);
	}
}

function iDte_Exit()
{	var oObj = oDivDate.in_obj;

	oDivDate.parentNode.removeChild(oDivDate);
	oDivDate = null;
		
	iNmd_UnMask();
	oObj.focus();
}

function iDte_Load(sVal, oObj, sDteFmt)
{	nMo = nYr = nDy = -1;

	var nOfst;
	var sFld = "";
	var cFld;
	var sType;
	var nFld;

	var oDt = new Date();
	var n = 0;

	var nOfsMo, nOfsDy, nOfsYr;

	nOfsMo = sDteFmt.indexOf('M');
	nOfsDy = sDteFmt.indexOf('D');
	nOfsYr = sDteFmt.indexOf('Y');
	if ((nOfsMo == -1) || (nOfsDy == -1) || (nOfsYr == -1)) 
	{	nOfsYr = 1;
		nOfsMo = 2;
		nOfsDy = 3;
	}

	if (typeof user_DateIn == 'function')
	{	var sVal2 = user_DateIn(sVal);
		if (sVal2)
		{	nYr = parseInt(sVal2.substr(0,4));
			nMo = parseInt(sVal2.substr(4,2));
			nDy = parseInt(sVal2,substr(6,2));
			return;
		}
	}
	
	for (var f=0; f < 3; f++)
	{	if (n >= sVal.length) break;
	
		sFld = "";
		sType = "";
		
		for (; n < sVal.length; n++)
		{	cFld = sVal.charAt(n);
		
			if ((cFld >= '0') && (cFld <= '9'))
			{	if (sType != 'S')
				{	sFld += cFld;
					sType = 'N';
					continue;
				}
				break;
			}
			else
			if (sType == 'N') break;
			
			cFld = cFld.toUpperCase();

			if ((cFld >= 'A') && (cFld <= 'Z'))
			{	if (sType != 'N')
				{	if (sFld.length < 3) sFld += cFld;
					sType = 'S';
					continue;
				}
				break;
			}
			else
			if (sType == 'S') break;
			
		}
		
		if (sType == 'S')
		{	if (sFld.length != 3) break;
			if (nMo != -1)
			{	if (nDy == -1)
					nDy = nMo;
				else
				if (nYr == -1)
					nYr = nMo;
				else
					break;
			}
				
			for (nMo = 11; nMo >= 0; nMo--)
			{	if (sFld == window.in_mths[nMo].substr(0,3).toUpperCase()) 
				{	nMo++;
					break;
				}
			}
			continue;
		}
		
		if (f == 0)
		{	if (sFld.length == 6)
			{	nFld = parseInt(sFld.substr(0,2),10);		/* First field */
				if (nOfsDy == Math.min(nOfsDy, nOfsMo, nOfsYr))
					nDy = nFld;
				else
				if (nOfsMo == Math.min(nOfsDy, nOfsMo, nOfsYr))
					nMo = nFld;
				else
					nYr = nFld;
	
				nFld = parseInt(sFld.substr(4,2),10);		/* Last field */
				if (nOfsDy == Math.max(nOfsDy, nOfsMo, nOfsYr))
					nDy = nFld;
				else
				if (nOfsMo == Math.max(nOfsDy, nOfsMo, nOfsYr))
					nMo = nFld;
				else
					nYr = nFld;

				nFld = parseInt(sFld.substr(2,2),10);		/* Middle */
				if (nDy == -1)
					nDy = nFld;
				else
				if (nMo == -1)
					nMo = nFld;
				else
					nYr = nFld;

				break;
			}

			if (sFld.length == 8)
			{	if (nOfsYr == Math.min(nOfsDy, nOfsMo, nOfsYr))
				{	nYr = parseInt(sFld.substr(0,4), 10);
					nMo = parseInt(sFld.substr(4,2),10);
					nDy = parseInt(sFld.substr(6,2), 10);
				}
				else
				{	nMo = parseInt(sFld.substr(0,2), 10);
					nDy = parseInt(sFld.substr(2,2),10);
					nYr = parseInt(sFld.substr(4,4), 10);
				}
				if (nOfsDy < nOfsMo)
				{	nFld = nDy;
					nDy = nMo;
					nMo = nFld;
				}
				break;
			}
		}
				
		nFld = parseInt(sFld,10);
		
		if ((nFld > 31) && (nFld < 9999))
		{	nYr = nFld;
			continue;
		}
		
		if ((nDy == -1) && (nFld > 12))
		{	nDy = nFld;
			continue;
		}
		
		if (nDy == -1)
		{	if ((nMo == -1) && (nOfsMo < nOfsDy))
				nMo = nFld;
			else
				nDy = nFld;
		}
		else
		if (nMo == -1)
			nMo = nFld;
		else
			nYr = nFld;	
	}
	
	if (nYr == -1)
	{	nYr = oDt.getFullYear();
	}
	else
	if (nYr < 100)
	{	if (oObj.in_century)
		{	nYr +=  oObj.in_century;
		}
		else
		{	n = oDt.getFullYear();
			nYr += n - (n % 100);
			if (n2YrMax)
			{	if (nYr > (n + n2YrMax)) nYr -= 100;
			}
		}
	}
	
	if (nMo == -1) nMo = oDt.getMonth() + 1;
	if (nDy == -1) nDy = oDt.getDate();
	
	if ((nYr >= 1600) && (nYr <=3000) && (nMo >= 1) && (nMo <=12) && (nDy >= 1) && (nDy <= 31)) return;
	
	nYr = oDt.getFullYear();
	nMo = oDt.getMonth() + 1;
	nDy = oDt.getDate();
	
	return;
}
	
/* Ajax logic interfaces */

var AjxSts = 0;
var AjxSeq = 0;

function AjxSend(cmd, waitInd)
{	var xmlHttp;
	var bAsync;
	var idTimer;
	var bPend;
	var bSent;

	if (bIdleReqd)
	{	bIdleReqd = false;
		AjxSend('I', 1);
	}
	
	if ((cmd != '*') && (cmd != 'I') && (cmd.substr(0,1) != 'S'))
	{	curTimer = 0;
	if (idInputTmr)
		{	clearTimeout(idInputTmr);
			LOG("Clear timer for:" + cmd);
			idInputTmr = null;
		}
	}
	
	LOG(cmd, 'Send');
/*
	if (oDivMbox && (waitInd >= 0)) return true;
*/	
	if (AjxSts == -1) return false;
	if (nSubmit > 0)
	{	nSubmit--;
		return true;
	}
	
	if ((bSafari) && (waitInd == 0)) waitInd = 1;
	if ((bFireFox) && (waitInd == 0)) waitInd = 1;
	if (waitInd == 0) waitInd = 1;

	if (sFcsPend != '')
	{	cmd = '[' + sFcsPend + ']' + cmd;
		sFcsPend = '';
	} 
	else
	if (cmd == '') return true;
	
	try
	{	xmlHttp=new XMLHttpRequest();
	}
	catch (e)
	{	try
		{	xmlHttp=new ActiveXObject("Msxml2.XMLHTTP");
		}
		catch (e)
		{	xmlHttp=new ActiveXObject("Microsoft.XMLHTTP");
		}
	}

	if (xmlHttp == null) 
	{	alert("AJax NEW failed");
		AjxSts = -1;
		return false;
	}

	idTimer = 0;
	bSent = false;

	xmlHttp.onreadystatechange = function()
	{	if (xmlHttp.readyState == 4)
		{	if (bPend || bAsync)
			{	bPend = false;
				if (idTimer)
				{	clearTimeout(idTimer);
					idTimer = 0;
				}
				AjxDo(xmlHttp);
			}
		}
	}
	
	if (waitInd > 0)
	{	bAsync = false;
		idTimer = setTimeout(function() { AjxBusy = false; xmlHttp.abort(); idTimer = 0;}, 30000);
		bPend = true;
	}
	else
	{	bAsync = true;
		bPend = false;
	}
	
	++AjxSeq;

	xmlHttp.open('POST', window.location.pathname + 
				'?_session=' + document.inomads._session.value + 
				'&_seq=Ajax&_x=' + document.inomads._seq.value + '&_ajx=' + AjxSeq + 
				'&_rnd=' + Math.random() , bAsync);
		
	var postInf = '_dta=' + encodeURIComponent(cmd);

	xmlHttp.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	xmlHttp.send(postInf);

	if (bPend) 
	{	if (idTimer)
		{	clearTimeout(idTimer);
			idTimer = 0;
		}
		AjxDo(xmlHttp);
	}

	if (nTimeout && (cmd != '*') && (cmd != 'I')) TimeOut(nTimeout);
	return true; 
}

function AjxDo(xmlHttp)
{	nPoll = 0;
	bAjxDmp = false;
	
	if (bRefocus)
	{	bRefocus = false;
		if (oFcs) oFcs.focus();
	}

	if (xmlHttp.status != 200) 
	{	if (xmlHttp.status == 0) 
		{	LOG("Ajax sts=0: resp len=" + xmlHttp.responseText.length);
		}
		else
		{	if (xmlHttp.responseText.length > 0)
			{	var wNew = window.open('','','height=600,width=800,titlebar=yes,toolbar=no,	status=no,menubar=no,scrollbars=yes,resizable=yes,location=no');
				wNew.document.writeln(xmlHttp.responseText);
				wNew.document.close();
			}
			else
			{	alert('Data transmission to the server failed (sts=' + xmlHttp.status + ')');
			}
			return;
		}
	}
	if (xmlHttp.responseText.length > 0) 
	{	var sResp = xmlHttp.responseText;
		LOG(sResp, 'Recv');
		
		if (sResp.substr(0,3) == 'Do:')
		{	var fncDo = new Function(sResp.substr(3));
			fncDo();
		}
		else
		if ((sResp.substr(0,6) == '<html>') || (sResp.substr(0,9) == '<!DOCTYPE'))
		{   window.onunload = null;
			window.onbeforeunload = null;
			bIgnUnload = true;
			
			oFcs = 0;

			document.open();
			document.write(sResp);
			document.close();
		}
		else
		if (sResp.substr(0,3) != 'Ign')
		{	bIgnoreFcs = true;
			alert("Invalid Ajax resp=='" + sResp + "==");
		}
	}
	else
	{	LOG('** sts:' + xmlHttp.status + ' **', '*Err*');
	}
}

function LOG(s, k)
{	if (!k) k = '';
	sLogKey[nLogIdx] = k;
	sLogTxt[nLogIdx] = s;
	nLogIdx++;
	if (nLogIdx >= nLogMax) nLogIdx = 0;
	return;
}

var bAjxDmp = false;
 
function AjxDump()
{	bAjxDmp = true;
	var wNew = window.open('','','height=600,width=800,toolbar=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=yes,location=no');
	
	wNew.document.writeln('<html><body>');
	wNew.document.writeln('<div style="white-space: normal;">')
	wNew.document.writeln(sRev + '<br />');
	wNew.document.writeln('Mouse x/y:' + nMseX + '/' + nMseY + '<br />');
	
	var sLn = 'Focus on:';
	
	if (oFcs)
	{	sLn += oFcs.id + ' name=' + oFcs.name;
		if (oChg) sLn += ' ** Change id=' + oChg.id + ' **';
	}
	else
	{	sLn += 'none';
	}
	
	wNew.document.writeln(sLn + '<br>');
	
	iNmd_GetSize();
	wNew.document.writeln('<br>Wdw: w/h=' + wdwWd + '/' + wdwHi +
			' Body: w/h=' + bdyWd + '/' + bdyHi +
			' Div: w/h=' + divWd + '/' + divHi +
			' Panel: w/h=' + pnlWd + '/' + pnlHi + '<br />');
			

	for (var n=0; n < aryDrags.length; n++)
	{	wNew.document.writeln('<br>Drag ' + aryDrags[n].idDrag + ' onto ' + aryDrags[n].idDrop + ' fires ' + aryDrags[n].nCtl);
	}
	
	if (oCellEdit) wNew.document.writeln('<br>oCelledit active');
	
	wNew.document.writeln('<br><table border="1" cellspacing="0">');
	
	var nIdx = nLogIdx;

	for (var n=sLogTxt.length; n>0; n--)
	{	if (nIdx == sLogTxt.length) nIdx = 0;
		wNew.document.writeln('<tr style="background-color: #' + ((nIdx & 1) ? 'EEE' : 'DDD') + ';"><td>' + sLogKey[nIdx] + '</td><td>' + iNmd_HTML(sLogTxt[nIdx]) + '</td><tr>');
		nIdx++;
	}
	wNew.document.writeln('</table><br>');
	
	if (nSubmit)
		wNew.document.writeln('Submit has been sent. Code: ' + sSubmit + ' [' + nSubmit + ']');
	
	wNew.document.writeln('</div></body></html>');
	wNew.document.close();
	return false;
}

function AjxWrite(oWdw, sText)
{	var sHtml = iNmd_HTML(sText);
	if (sHtml == '') sHtml = '{no data}';
	oWdw.document.writeln(sHtml);
}

function iNmd_HTML(sText)
{	var sHtml = sText.replace(/&/g, '&amp;');
	sHtml = sHtml.replace(/</g, '&lt;');
	sHtml = sHtml.replace(/>/g, '&gt;');
	sHtml = sHtml.replace(/ /g, '&nbsp;');
	return sHtml;
}

function AjxCtl(nCtl)
{ 	if (AjxSend('C' + nCtl + ',0', 0)) return false;
	iNmd_Submit(nCtl.toString(10));
	return false;
}

function AjxIdle(nMs)
{	bIdleReqd = true;
	if (nMs) 
		setTimeout(AjxIdle2, nMs);
	else
		setTimeout(AjxIdle2, 50);
}

function AjxIdle2()
{	if (bIdleReqd)
	{	bIdleReqd = false;
		AjxSend('I',1);
	}
}

function iNmd_MseXY(e)
{	if (e.changedTouches && (e.changedTouches.length > 0))
	{	nMseX = e.changedTouches[0].pageX;
		nMseY = e.changedTouches[0].pageY;
	}
	else
	if (e.pageX)
	{	nMseX = e.pageX
		nMseY = e.pageY
	}  
	else
	if (e.clientX)
	{	nMseX = e.clientX;
		nMseY = e.clientY;
		if (iNmd_is_ie)
		{	nMseX += document.body.scrollLeft; // -document.body.clientLeft;
			nMseY += document.body.scrollTop;// -document.body.clientTop;
		}
	}
}

var aryDrags = new Array();
var oDragMsk = null;
var oDragDiv = null;
var oDrag = null;
var oDrop = null;
var nDropX = 0;
var nDropY = 0;
var nDropCtl = 0;

function iNmd_DragDrop(idDrag, idDrop, nCtl)
{	for (var i = 0; i < aryDrags.length; i++)
	{	if ((aryDrags[i].idDrag == idDrag) & (aryDrags[i].idDrop == idDrop))
		{	if (nCtl != 0)
			{	aryDrags.nCtl = nCtl;
			}
			else
			{	aryDrags.splice(i,1);
				if (argDrags.length == 0) i_RmvEvent(window, 'mousedown', iNmd_MseDwn, true);
				var oFky_dd = document.getElementById('fk_dd');
				if (oFky_dd) oFky_dd.style.display = 'none';
			}
			return;
		}
	}
	
	if (nCtl == 0) return;
	
	if (aryDrags.length == 0)
	{	i_AddEvent(window, 'mousedown', iNmd_MseDwn, true);
		var oFky_dd = document.getElementById('fk_dd');
		if (oFky_dd) oFky_dd.style.display = 'inline';
	}
		
	aryDrags.push({idDrag:idDrag, idDrop:idDrop, idDiv:'', nCtl:nCtl, top:0, left:0, width:-1, height:-1});
	return;
}

function iNmd_MseDwn(e)
{	if (bHdrResize) return;
	if (window.event) e = window.event;
	if (e.ctrlKey || e.shiftKey) return;
	if (e.button > 1) return;
	
	if (oDragDiv)
	{	oDrag = oDrop = null;
		iNmd_MseUp(e);
		return;
	}
	
	oDrag = null;
	
	var oOver = e.target ? e.target : e.srcElement;
	if (oOver.disabled) return;
	
	while (oOver)
	{	if (oOver.id) break;
		oOver = oOver.parentNode;
	}
	if (!oOver) return;
	if (oOver.nodeName == 'A') return;
	if (oOver.id.substr(0,3) == 'gf_') return;
	if (oOver.id.substr(0,3) == 'gb_') return;
	if (oOver.id.substr(0,3) == 'hw_') return;
	if (oOver.id.substr(0,3) == 'hh_') return;
	
	if ((oOver.id.substr(0,3) == 'gc_') && (oOver.id.indexOf('N') == -1)) return;
	
	if (oOver.type)
	{	if (oOver.type == 'text')
		{	if ('selectionStart' in oOver)
			{	if (oOver.selectionEnd > oOver.selectionStart) return;	
			}
			else
			if (document.selection)
			{	if (document.selection.createRange().text.length != 0) return;
			}
		}
		else
		if (oOver.options)
		{	iNmd_MseXY(e);		/* Avoid Lbx scrollbar */
			if (nMseX > (iNmd_Left(oOver) + oOver.offsetWidth - 20)) return;
		}
	}
	
	idDrag = oOver.id;
	if ((idDrag.substr(0,1) == 's') || (idDrag.substr(0,1) == 'd') || (idDrag.substr(0,1) == 'v')) return;
			
	idDrag = idDrag.substr(3);
	
	var nOfs = idDrag.indexOf('_');
	var rwDrag = null;
	if (nOfs > 0)
	{	rwDrag = idDrag.substr(nOfs + 1);
		idDrag = idDrag.substr(0,nOfs);
		
		nOfs = rwDrag.indexOf('_');
		if (nOfs > 0) rwDrag = rwDrag.substr(0,nOfs);
	}

	for (var i = 0; i < aryDrags.length; i++)
	{	if (aryDrags[i].idDrag == idDrag)
		{	aryDrags[i].left = 1000000;
		
			oDrop = i_Id('id_' + aryDrags[i].idDrop);
			if (!oDrop) continue;
			if (oDrop.disabled) continue;
			
			if ((oDrop.className == 'iCmnVal') || (oDrop.type == 'hidden'))
			{	oDrop = i_Id('dw_' + aryDrags[i].idDrop);
				if (!oDrop) oDrop = i_Id('dv_' + aryDrags[i].idDrop);
				if (!oDrop) continue;
			}

			aryDrags[i].idDiv = oDrop.id;
			aryDrags[i].top = iNmd_Top(oDrop);
			aryDrags[i].left = iNmd_Left(oDrop);
			aryDrags[i].width = oDrop.offsetWidth;
			aryDrags[i].height = oDrop.offsetHeight;

			oDrag = oOver;
		}
	}
	
	oDrop = null;
	if (!oDrag) return;
	
	if (oDrag.id && rwDrag)
	{	if ((oDrag.id.substr(0,3) == 'lf_') || (oDrag.id.substr(0,3) == 'lr_'))
		{	var oLbx = i_Id('id_'+idDrag);
			if (!iNmd_LvuIsOn(oLbx, rwDrag)) 
			{	iNmd_LvuClk(oDrag, e);
				oLbx.in_clkDone = true;
			}
		}
	}
	
	oDrag.focus();

	iNmd_GetSize();
	
	iNmd_MseXY(e);
	nDropX = nMseX;
	nDropY = nMseY;

	i_AddEvent(window, 'mouseup', iNmd_MseUp, true);
	i_AddEvent(window, 'mousemove', iNmd_MseMve, true);		
	return;	
}

function iNmd_MseMve(e)
{	if (window.event) e = window.event;
	if (!oDrag) return;
	
	iNmd_MseXY(e);
	
	if (!oDragMsk)
	{	if (oChg) iNmd_Chg(oChg);
		
		if ((Math.abs(nDropX - nMseX) < 3) && (Math.abs(nDropY - nMseY) < 3)) return;
	
		oDragMsk = document.createElement('div');
		oDragMsk.className = 'iDragMsk';
		oDragMsk.id = 'id_DragMsk';
				
		oDragMsk.style.position = 'absolute';

		oDragMsk.style.left = '0px';
		oDragMsk.style.top = '0px';
		oDragMsk.style.width = '100%';
		oDragMsk.style.height = '100%';

		i_AddNode(oDragMsk);

		oDragDiv = document.createElement('a');
		oDragDiv.className = 'iDragDiv';
		
		oDragDiv.style.position = 'absolute';
		oDragDiv.style.left = nMseX + 5 + 'px';
		oDragDiv.style.top = nMseY + 5 + 'px';
		
		i_AddNode(oDragDiv);

		oDrag.blur();		
		oDragDiv.focus();
		
		setTimeout(iNmd_DrgSet, 50);
		
		if (iNmd_is_ie)
		{	var newEvt = document.createEvent("MouseEvents");
			newEvt.InitEvent("mouseup", true, true);
			oDrag.dispatchEvent(newEvt);
		}
	}
	else
	{	if (!oDragDiv) return;
		oDragDiv.style.left = nMseX + 5 + 'px';
		oDragDiv.style.top = nMseY + 5 + 'px';
	}

	if (e.stopPropagation) e.stopPropagation();
	if (e.preventDefault) e.preventDefault();
	e.cancelBubble = true;
    e.cancel = true;
	e.returnValue = false;

	oDrop = null;
	nDropCtl = 0;

	for (var i = 0; i < aryDrags.length; i++)
	{	if (aryDrags[i].idDrag != idDrag) continue;
	
		nDropX = nMseX - aryDrags[i].left;
		nDropY = nMseY - aryDrags[i].top;
		
		if ((nDropX < 0) || (nDropX > aryDrags[i].width)) continue;
		if ((nDropY < 0) || (nDropY > aryDrags[i].height)) continue;
		
		oDrop = i_Id(aryDrags[i].idDiv);
		nDropCtl = aryDrags[i].nCtl;
		break;

	}
	
	if (oDrop)
	{	if (oDragDiv.className == 'iDragDiv')
		{	oDragDiv.className = 'iDropDiv';
			oDragMsk.style.cursor = 'default';
		}
	}
	else
	{	if (oDragDiv.className == 'iDropDiv')
		{	oDragDiv.className = 'iDragDiv';
			oDragMsk.style.cursor = 'wait';
		}
	}
	return false;
}

function iNmd_MseUp(e)
{	if (window.event) e = window.event;

	i_RmvEvent(window, 'mouseup', iNmd_MseUp, true);
	i_RmvEvent(window, 'mousemove', iNmd_MseMve, true);		

	if (oDrag && oDragDiv && oDrop && oDragMsk)
	{	var sId;
		var oCell = null;

		if (oDrop.id.substr(0,3) == 'dv_')
		{	oCell = iDropTarget(i_Id('dd_' + oDrop.id.substr(3,5)), e.clientX, e.clientY);
		}

		if (oCell)		
			sId = oCell.id;
		else
			sId = iNmd_DrpOn(oDrop);

		AjxSend('D' + oDrag.id + ',' + sId, -1);
	}

	oDrop = oDrag = null;
	
	oDragDiv = i_RmvNode(oDragDiv);
	oDragMsk = i_RmvNode(oDragMsk);
	
	return;
}

function iDropTarget(oDrop, xPt, yPt)
{	if (!oDrop) return oDrop;
	
	var rcObj;
	var oChild = oDrop.firstChild;
	
	while (oChild)
	{	if ((oChild.nodeName == 'DIV'))
		{	rcObj = oChild.getBoundingClientRect();
			if ((xPt >= rcObj.left) && (xPt <= rcObj.right) && (yPt >= rcObj.top) && (yPt <= rcObj.bottom))
			{	oDrop = iDropTarget(oChild, xPt, yPt);
				if (oDrop) return oDrop;
				if (oChild.id) break;
			}
		}
		oChild = oChild.nextSibling;
	}
	return oChild;
}

function iNmd_DrgSet()
{	if (!oDrag) return;

	if (oFcs == oDrag) oChg = oFcs;
	
	if (oChg) iNmd_Chg(oChg, 'U');
	
	var sVal = '';
	var oLbl;

	if (oDrag.type)
	{	if (oDrag.options)	/* Select */
		{	var nCnt = 0;
			for (var i = 0; i < oDrag.length; i++)
			{	if (!oDrag.options[i].selected) continue;
			
				nCnt++;
				if (nCnt > 1)
				{	sVal += '<br>';
				}
				if (nCnt > 4)
				{	sVal += '...';
					break;
				}
				sVal += oDrag.options[i].text;
			}
		}
		else
		{	oLbl = i_Id('lb' + oDrag.id.substr(2));
		
			if (oLbl) sVal = oLbl.innerHTML;
		}
		
	}	
	
	if (oDrag.id.substr(0,3) == 'lf_')
	{	var sId = oDrag.id.substr(3,5);
		var oLbx = i_Id('id_' + sId);
		var sValue = oLbx.value;
		var nFini;
		var nStrt = 0;
		var oLine;
		var nCnt = 0;
		var sHmtl = '';
		
		while (1)
		{	nFini = sValue.indexOf(',', nStrt);
			if (nFini == -1) break; 
		    
		    if (nCnt > 4)
		    {	sVal += "<br>...";
				break;
			}
			
			oLine = i_Id('lr_' + sId + '_' + sValue.substring(nStrt, nFini));
			if (oLine) sVal += (sVal != '' ? '<br>' : '') + oLine.innerHTML;
			nStrt = nFini + 1;
			nCnt++;
		}
	}

	if (oDrag.id.substr(0,3) == 'ch_') sVal = oDrag.textContent;
		
	var oTrue = oDrag;
	if (oDrag.id.substr(0,3) == 'gx_') oTrue = oDrag.parentNode;
	
	if (sVal == '')	sVal = oTrue.innerHTML;

	if (sVal == '')
	{	sVal = oTrue.value;
			
		if (sVal == '')
		{	sVal = oTrue.title;
			if (sVal == '') sVal = 'xxxxx...';
			sVal = '<i>'+sVal+'</i>';
		}
	}
		
	oDragDiv.innerHTML = sVal;
}


function iNmd_DrpOn(oOver)
{	if (!oOver) return;
	if (!oOver.id) return;
	var idOver = oOver.id;
	
	if (oOver.type && (oOver.type.substr(0,6) == 'select'))
	{	if (oOver.size > 1)
		{	var itemHeight = Math.floor(oOver.offsetHeight / oOver.size);
			var itemNo = Math.floor((nMseY - iNmd_Top(oOver) + oOver.scrollTop) / itemHeight);
			if ((itemNo >= 0) && (itemNo < oOver.length)) idOver += '_' + (itemNo + 1);
		}
		return idOver;
	}
	
	if (idOver.substr(0,3) == 'dw_')
	{	var sId = idOver.substr(3,5);
		
		var nScroll = 0;
		var oObj = i_Id('sh_' + sId);
		if (oObj) nScroll = oObj.scrollLeft;
		
		oObj = i_Id('tb_' + sId);
		if (oObj)
		{	idOver = iNmd_DrpItm(oObj, nScroll, idOver);
		}
		else
		{	oObj = i_Id('gh_' + sId);
			if (oObj)
			{	idOver = iNmd_DrpItm(oObj, 0, idOver);
				if (idOver == oOver.id)
				{	oObj = i_Id('gd_' + sId);
					if (oObj) idOver = iNmd_DrpItm(oObj, nScroll, idOver);
					
				}
			}
		}
		return idOver;
	}

	if (idOver.substr(0,3) == 'dv_') idOver = iNmd_DrpTv(oOver, idOver);
	return idOver;
}

function iNmd_DrpTv(oOver, idOver)
{	var sId = idOver.substr(3,5);
	var oSpan;
	var nOfsY;
	var nOfsX;
		
	var allSpans = oOver.getElementsByTagName('span');
	for (var i = 0; i < allSpans.length;)
	{	oSpan = allSpans[i++];
		if (oSpan.id.substr(0,3) != 'tx_') continue;
	
		nOfsY = nMseY - iNmd_Top(oSpan);
		nOfsX = nMseX - iNmd_Left(oSpan);
		
		if ((nOfsY >= 0) && (nOfsY < oSpan.offsetHeight))
		{	if ((nOfsX >= 0) && (nOfsX < oSpan.offsetWidth))
				return oSpan.id;
			break;
		}
	}
	return idOver;
}
	
		
function iNmd_DrpItm(oTbl, nScroll, idOver)
{	var y = nMseY - iNmd_Top(oTbl);
	var x = nMseX - iNmd_Left(oTbl) - nScroll;
	
	if ((y < 0) || (y > oTbl.offsetHeight)) return idOver;
	
	if ((x < 0) || (x > oTbl.offsetWidth)) return idOver;

	var oRow, oCol;

	for (var r = 0; r < oTbl.rows.length; r++)
	{	oRow = oTbl.rows[r];
		y -= oRow.offsetHeight;
		if (y <= 0) break;
	}
	if (y > 0) return idOver;
	
	for (var c = 0; c < oRow.cells.length; c++)
	{	oCol = oRow.cells[c];

		x -= oCol.offsetWidth;
		if (x <= 0) break;
	}
	if (oCol.id) 
		return oCol.id;
	else
		return idOver;
}

function iTch_Vbr(e)
{	if (window.event) e = window.event;
	
	var oObj = e.target ? e.target : e.srcElement;

	var oTm = new Date();
	var nMs = oTm.getTime();

	if (e.type == 'mousedown')
	{	oClick = oObj;
		nClickMS = nMs + 500;
		return false;
	}

	var nScr;

	if (e.type == 'click')
	{	iNmd_MseXY(e);
		if (oObj.id.substr(0,3) == 'vp_') oObj = i_Id('vb_' + oObj.id.substr(3));
				
		nScr = nMseY - iNmd_Top(oObj);
		if (nScr < 8) nScr = 0;				/* Fudge to make top easier to hit */
		nScr = (parseInt(oObj.getAttribute('iHi'), 10) * nScr ) / oObj.offsetHeight;
	}
	else
	{	var oDiv = i_Id('vb_' + oObj.id.substr(3));
	
		if (oObj.id.substr(0,2) == 'vu')
		{	if ((oClick == oObj) && (nClickMS < nMs))
				nScr = 0;
			else
			{	nScr = oDiv.in_ScrollTop - oDiv.offsetHeight + 10;
				if (nScr < 0) nScr = 0;
			}
		}
		else
		{	var nMax = parseInt(oDiv.getAttribute('iHi'), 10);
		
			if ((oClick == oObj) && (nClickMS < nMs))
				nScr = nMax;
			else
			{	nScr = oDiv.in_ScrollTop + oDiv.offsetHeight - 10;
				if (nScr > nMax) nScr = nMax;
			}
		}
	}

	AjxSend('S' + oObj.id.substr(3) + ',Vsc:' + nScr );
	return false;
}

function iTch_Hbr(e)
{	if (window.event) e = window.event;
	
	var oObj = e.target ? e.target : e.srcElement;

	var oTm = new Date();
	var nMs = oTm.getTime();
	
	if (e.type == 'mousedown')
	{	oClick = oObj;
		nClickMS = nMs + 500;
		return false;
	}

	var nScr;
	var sId = oObj.id.substr(3);

	var oBar = i_Id('hb_' + sId);
	if (!oBar) return false;
	
	var oDiv = i_Id('dv_' + sId);
	if (!oDiv) return false;

	var nMax = parseInt(oBar.getAttribute('iWd'), 10) - oDiv.offsetWidth;
	if (nMax <= 0) return false;
	
	if (oBar.in_ScrollLeft) 
		nScr = oBar.in_ScrollLeft;
	else
		nScr = 0;
	
	if (e.type == 'click')
	{	iNmd_MseXY(e);
		nScr = nMseX - iNmd_Left(oBar);

		if (nScr < 8) nScr = 0;	
		nScr = (nMax * nScr) / oBar.offsetWidth;
	}
	else
	{	if (oObj.id.substr(0,2) == 'hl')
		{	if ((oClick == oObj) && (nClickMS < nMs))
				nScr = 0;
			else
				nScr -= 10;
		}
		else
		{	if ((oClick == oObj) && (nClickMS < nMs))
				nScr = nMax;
			else
				nScr += 10;
		}
	}

	if (nScr < 0) nScr = 0;
	if (nScr > nMax) nScr = nMax;
	
	oBar.in_ScrollLeft = nScr;
	
	oDiv.scrollLeft = nScr;
		
	nScr = (nScr * oBar.offsetWidth) / nMax;
	i_Id('hp_' + sId).style.width = nScr + 'px';

	if (oFcs && bIsCommon) oFcs.focus();
	return;
}
/* Utility functions -- cross platform */

function i_AddNode(oNode, oParent)
{	if (!oParent) oParent = document.body;
	oParent.insertBefore(oNode, oParent.childNodes[0]); 
}

function i_RmvNode(oNode)
{ 	if (oNode) oNode.parentNode.removeChild(oNode);
	return null;
}

function i_AddEvent(oObj, sEvent, fCode, fBubble)
{	if (oObj.addEventListener)
	{	oObj.addEventListener(sEvent, fCode, fBubble);
	}
	else
	{	if (oObj == window) oObj = document;
		oObj.attachEvent('on'+sEvent, fCode);
	}
}
function i_RmvEvent(oObj, sEvent, fCode, fBubble)
{	if (oObj.addEventListener)
	{	oObj.removeEventListener(sEvent, fCode, fBubble);
	}
	else
	{	if (oObj == window) oObj = document;
		oObj.detachEvent('on'+sEvent, fCode);
	}
}

function i_DblClk(oObj)
{	var oTm = new Date();
	var nMs = oTm.getTime();

	if ((oClick == oObj) && (nClickMS > nMs))
	{	nClickMS = 0;
		oClick = null;
		return true;
	}
	
	nClickMS = nMs + nDblClkMS;
	oClick = oObj;
	return false;
}

function i_Text(oObj)
{	if (bFireFox) 
		return oObj.textContent;
	else
		return oObj.innerText;
}

function i_Id(sId)
{	if (document.getElementById)
	{	var oObj = document.getElementById(sId);
		return oObj;
	}

	/* Manual hunt -- Needed for Pocket PC */

	for (var f = 0; f < document.forms.length; f++)
	{	var oForm = document.forms[f];
	  	
		for (var i = 0; i < oForm.length ; i++)
		{	if ( oForm.elements[i].id == sId)  return oForm.elements[i];
		}
	}
	alert('Cannot manually find:' + id);
	return null;
}

function iNmd_GetId(sId)
{	var oObj = iNmd_FindId(sId);
	if (oObj) return oObj;
	return document.inomads._seq;	/* Dummy */
}

function iNmd_FindId(sId)	/* Old name */
{	return i_Id(sId);
}

function i_Show(sId, bShow)
{	var oObj = i_Id('d_' + sId);
	if (!oObj)
	{	alert("Cannot find d_"+sId);
		return;
	}
	
	var sClass = ' '+oObj.className+' ';
	
	sClass = sClass.replace( /( iHide )|( iShow )/,' ') + (bShow ? 'iShow' : 'iHide');
	oObj.className = sClass.trim();
	return;
}	
	
/* Upload routines */

function Upload_file(idForm)
{	window.onbeforeunload = null;
	window.onunload = null;
	bIgnUnload = true;

	i_Id(idForm).submit();
}
function Uptab_to(nId)
{	setTimeout("i_Id('mb_" + nId + "').focus();", 10);
}

/* Embed or Object ID */

function i_Obj(sName, sId)
{	if (document.embeds && document.embeds[sName])
		return document.embeds[sName];

	/* If second arg provided and non-null then its the ID else use name for both */
		
	if (sId)
		return i_Id(sId);
	else
		return i_Id(sName);
}

function i_Eval(sValu)
{	try
	{	AjxSend('=' + eval(sValu),-1);
	}
	catch(e)
	{	AjxSend('=<!-- ' + e.message + ' -->',-1);
	}
}

function i_ImgPix(oImg)
{	var newImg;
	for (var i = 1; i < i_ImgPix.arguments.length; i += 2)
	{	newImg = Pixastic.process(oImg, i_ImgPix.arguments[i], i_ImgPix.arguments[i+1]); 
		if (newImg) oImg = newImg;
	}
	return;
}

/* --- Image rotation logic --- */

function i_ImgRot(sId, nDeg, nScl, bDo) 
{	if (!bDo)
	{	setTimeout('i_ImgRot("'+sId+'",'+nDeg.toString()+','+ nScl.toString()+',1)', 100);
		return;
	}
	
	var oImg = i_Id('im_'+sId);
	if (!oImg) oImg = i_Id('id_'+sId);
	if (!oImg) return;

	var oCvs = i_Id('cv_'+sId);
	if (!oCvs) return;

	nDeg = (nDeg + 720) % 360;

	if (oCvs.getContext)  
	{	/* Canvas supported */

		if ((nDeg%360)  == 0)
		{	oImg.style.display = 'block';
			oCvs.style.display = 'none';
			return;
		}

		oImg.style.display = 'none';
		oCvs.style.display = 'block';

		var oDraw = oCvs.getContext('2d');
		var nRot = nDeg * Math.PI / 180;

		switch(nDeg)
		{	default :
			case 0 :
				oCvs.setAttribute('width', oImg.naturalWidth * nScl);
				oCvs.setAttribute('height', oImg.naturalHeight * nScl);
				oDraw.rotate(0);
				if (nScl != 1) oDraw.scale(nScl, nScl);
				oDraw.drawImage(oImg, 0, 0);
				break;
				
			case 90 :
				oCvs.setAttribute('width', oImg.naturalHeight * nScl);
				oCvs.setAttribute('height', oImg.naturalWidth * nScl);
				oDraw.rotate(nRot);
				if (nScl != 1) oDraw.scale(nScl, nScl);
				oDraw.drawImage(oImg, 0, -oImg.naturalHeight);
				break;

			case 180 :
				oCvs.setAttribute('width', oImg.naturalWidth * nScl);
				oCvs.setAttribute('height', oImg.naturalHeight * nScl);
				oDraw.rotate(nRot);
				if (nScl != 1) oDraw.scale(nScl, nScl);
				oDraw.drawImage(oImg, -oImg.naturalWidth, -oImg.naturalHeight);
				break;

			case 270 :
				oCvs.setAttribute('width', oImg.naturalHeight * nScl);
				oCvs.setAttribute('height', oImg.naturalWidth * nScl);
				oDraw.rotate(nRot);
				if (nScl != 1) oDraw.scale(nScl, nScl);
				oDraw.drawImage(oImg, -oImg.naturalWidth, 0);
				break;
		}
		return;		
	}
	nDeg = nDeg / 90;
	oImg.style.filter = 'progid:DXImageTransform.Microsoft.BasicImage(rotation=' + nDeg.toFixed().toString() + ')';
}

function TimeOut(nSec)
{	if (idTimeout)
	{	clearTimeout(idTimeout);
		idTimeout = null;
		nTimeout = 0;
	}
	
	if (nSec)
	{	if (!oChild) idTimeout = setTimeout("AjxSend('C-1900',0);", nSec * 1000);
		nTimeout = nSec;
	}
}

var nMnuCnt = 0;
var oMnuCur = null;
var nMnuNotOver = 0;
var nMnuTmr = 0;

var oMnuOver = null;
var idMnuOverTmr = null;

function mnuClick(sUrl)
{	var		oMnuNew = null;
	var		oMnu;
	var		oMse = null;	
	
	nMnuCnt++;
	mnuOverClear();

	if (sUrl.substr(0,5) == 'menu:')
	{	oMse = i_Id(sMseId);
		if (!oMse) return;
	
		oMnuNew = i_Id('mnu_'+sUrl.substr(5));
		if (!oMnuNew) { alert("Unable to find "+sUrl); return; }
		
		if (oMnuNew)
		{	sMseId = '';
			if (oMse.nodeParent == oMnuNew) return;
			if (oMnuNew.nodeParent != oMse) oMse.appendChild(oMnuNew);

			oMnu = oMnuNew;
			while(oMnu)
			{	oMnu.nMnuCnt = nMnuCnt;
				oMnu = oMnu.parentNode;
			}
		}
	}
	else
	if (sUrl.substr(0,5) == 'txid:')
	{	window.open(window.location.pathname + 'txid=' + sUrl.substr(5));
	}
	else
	if (sUrl.substr(0,6) == 'mailto')
	{	var wId = window.open(sUrl);
		if (wId && wId.open && !wId.closed) setTimeout(function () { wId.close(); }, 1000);
	}
	else
	if (sUrl != '')
	{	if ((sUrl.substr(0,4) == 'http') || (sUrl.substr(0,3) == 'ftp') || (sUrl.indexOf(":") == -1)) 
		{	window.open(sUrl);
		}
		else
		{	var wId = window.open(sUrl);
			if (wId && wId.open && !wId.closed) setTimeout(function () { wId.close(); }, 2000);
		}
	}

	/* Reset all prior menus to original state */
		
	oMnu = oMnuCur;
	while (oMnu)
	{	if (oMnu.nMnuCnt == nMnuCnt) break;
		if (oMnu.svDisplay) oMnu.style.display = oMnu.svDisplay;
		oMnu = oMnu.parentNode;
	}
	
	oMnuCur = oMnuNew;
	
	if (oMnuCur)
	{	oMnu = oMnuCur.parentNode;			/* Position relative clicked on object */

		if (oMnu.style.display.substr(0,6) == 'inline')
		{	oMnuNew.style.top = oMnu.offsetHeight + 'px';
			oMnuNew.style.left = '0px';
		}
		else
		{	oMnuNew.style.top = '0px';
			oMnuNew.style.left = (2 + oMnu.offsetWidth) + 'px';
		}
		
		oMnuNew.style.position = 'absolute';
		
		if (!oMnuNew.svDisplay) oMnuNew.svDisplay = oMnuNew.style.display;
		oMnuNew.style.display = 'block';
		oMnuNew.style.zIndex = 100;

		nMnuNotOver = 0;
		if (nMnuTmr == 0)
		{	setTimeout(mnuTmr, 500);
			nMnuTmr++;
		}
	}
	return false;
	
}

function mnuOverClear()
{	if (!oMnuOver) return;
	i_RmvEvent(oMnuOver, 'mouseleave', mnuLeave, true);
	clearTimeout(idMnuOverTmr);
	oMnuOver = null;
	idMnuOverTmr = null;
}	


function mnuLeave()
{	mnuOverClear();
}

function mnuOverTmr()
{	var mnuOnClick = oMnuOver.getAttribute('onclick');
	mnuOverClear();
	eval(mnuOnClick);
	return;
}

function mnuOver(e, nMs)
{	if (window.event) e = window.event;
	mnuOverClear();

	oMnuOver = (e.target ? e.target : e.srcElement);
	i_AddEvent(oMnuOver, 'mouseleave', mnuLeave, true);
	idMnuOverTmr = setTimeout(mnuOverTmr, nMs);
	return;
}

function mnuTmr()
{	nMnuTmr--;

	if ((sMseId.substr(0,3) == 'mnu') || (sMseId.substr(0,3) == 'lnk'))
	{	nMnuNotOver = 0;
	}
	else
	{	nMnuNotOver++;
		if (nMnuNotOver >= 4) mnuClick('');
	}
	
	if (oMnuCur) 
	{	nMnuTmr++;
		setTimeout(mnuTmr, 500);
	}
	return;
}

var oSound = null;
function iNmd_Play(sSoundUrl)
{	if (!oSound)
	{	var oSound = document.createElement('div');
		oSound.style.position = 'absolute';
		oSound.style.zIndex = -1;
		oSound.style.left = '0';
		oSound.style.top = '0';
		i_AddNode(oSound);
	}
	
	oSound.innerHTML = '<embed src="'+sSoundUrl+'" width=1 height=1 loop="false" enablejavascript="true" />';
}

function iNmd_SigCap(sId)
{	var oCanvas = i_Id(sId);
	if (oCanvas)
	{	oCanvas.i_ctx = oCanvas.getContext('2d');
		oCanvas.i_ctx.strokeStyle = 'Black';
		oCanvas.i_ctx.fillStyle = 'White';
		oCanvas.i_ctx.lineWidth = 1;

		oCanvas.width = oCanvas.parentNode.offsetWidth;
		oCanvas.height = oCanvas.parentNode.offsetHeight;
		oCanvas.i_curX = oCanvas.i_curY = 0;
		
		if ("ontouchstart" in document.documentElement)
			i_AddEvent(oCanvas, 'touchstart', iNmd_SigCapStrt, true);
		else
			i_AddEvent(oCanvas, 'mousedown', iNmd_SigCapStrt, true);
	}
	else
		alert('Cannot find canvas:'+ sId);
}

function iNmd_SigCapStrt(e)
{	if (window.event) e = window.event;
	var oCanvas = (e.target ? e.target : e.srcElement);

	iNmd_MseXY(e);

	oCanvas.i_curX = nMseX - iNmd_Left(oCanvas);
	oCanvas.i_curY = nMseY - iNmd_Top(oCanvas);

	if ("ontouchstart" in document.documentElement)
	{	i_AddEvent(oCanvas, 'touchmove', iNmd_SigCapMove, true);
		i_AddEvent(oCanvas, 'touchend', iNmd_SigCapFini, true);
	}
	else
	{	i_AddEvent(oCanvas, 'mousemove', iNmd_SigCapMove, true);
		i_AddEvent(oCanvas, 'mouseup', iNmd_SigCapFini, true);
	}
	return false;
}

function iNmd_SigCapMove(e)
{	if (window.event) e = window.event;
	var oCanvas = (e.target ? e.target : e.srcElement);

	iNmd_MseXY(e);

	oCanvas.i_ctx.beginPath();
	oCanvas.i_ctx.moveTo(oCanvas.i_curX, oCanvas.i_curY);

	oCanvas.i_curX = nMseX - iNmd_Left(oCanvas);
	oCanvas.i_curY = nMseY - iNmd_Top(oCanvas);

	oCanvas.i_ctx.lineTo(oCanvas.i_curX, oCanvas.i_curY);
	oCanvas.i_ctx.stroke();
	
	bDrawn = true;
	
	return i_IgnEvent(e);
}

function iNmd_SigCapFini(e)
{	if (window.event) e = window.event;
	var oCanvas = (e.target ? e.target : e.srcElement);

	if ("ontouchstart" in document.documentElement)
	{	i_RmvEvent(oCanvas, 'touchmove', iNmd_SigCapMove, true);
		i_RmvEvent(oCanvas, 'touchend', iNmd_SigCapFini, true);
	}
	else
	{	i_RmvEvent(oCanvas, 'mousemove', iNmd_SigCapMove, true);
		i_RmvEvent(oCanvas, 'mouseup', iNmd_SigCapFini, true);
	}
}

function iNmd_SigCapClear(sId)
{	var oCanvas = i_Id(sId);
	bDrawn = false;
	
	if (oCanvas)
		oCanvas.i_ctx.clearRect( 0, 0, oCanvas.width, oCanvas.height );
	else
		alert('Cannot find canvas:'+ sId);
}

function iNmd_OnLoad(sId, nCtl, bDo)
{	var oList = i_Id(sId);
	if (bDo)
	{	oList.i_onloadtmr = null;
		AjxCtl(nCtl);
	}
	else
	{	if (oList.i_onloadtmr) clearTimeout(oList.i_onloadtmr);
		oList.i_onloadtmr = setTimeout(function (){ iNmd_OnLoad(sId, nCtl, 1); }, 500);
	}
	return;
}

function iNmdFky(e)
{	if (window.event) e = window.event;
	var oFld = (e.target ? e.target : e.srcElement);
	while (oFld)
	{	if (oFld.id) break;
		oFld = oFld.parentNode;
	}
	
	if (oFld)
	{	if (oFld.id == 'iFkyBtn')
		{	oFld = i_Id('iFkyDrp');
			if (oFld.style.display == 'block')
				oFld.style.display = 'none';
			else
			{	i_Id('fk_C').className = i_Id('fk_S').className = 'iFkyKey';
				oFld.style.display = 'block';
			}
		}
		else
		if (oFld.id == 'rc_btn')
		{	i_RClk(oFld);
		}
		else
		if (oFld.id == 'rc_scan')
		{	AjxSend('KSCAN',0);
		}
		else
		if (oFld.className == 'iFkyKey')
		{	oFld.className = 'iFkyKeyOn';
		}
		else
		if (oFld.className == 'iFkyKeyOn')
		{	oFld.className = 'iFkyKey';
		}
		else
		if (oFld.className == 'iFkyCol')
		{	var sCtl;
			sCtl = oFld.id.substr(3);
			if (i_Id('fk_C').className == 'iFkyKeyOn')
			{	sCtl = 'C' + sCtl;
				i_Id('fk_C').className = 'iFkyKey';
			}
			if (i_Id('fk_S').className == 'iFkyKeyOn')
			{	sCtl = 'S' + sCtl;
				i_Id('fk_S').className = 'iFkyKey';
			}

			i_Id('iFkyDrp').style.display = 'none';
			AjxSend('K'+sCtl,0);
		}
	}
	
	return i_IgnEvent(e);
}

function i_RClk(oFld)
{	if (oFld)
		oRClick = oFld;
	else
	{	if (!bRClick) return;
		oFld = oRClick;
	}

	var oWdw = i_Id('id_Main');
	if (bRClick)
	{	bRClick = false;
		oFld.className = oFld.i_className;
		i_RmvEvent(oWdw, 'click', i_RMseClk, true);
	}
	else
	{	bRClick = true;
		oFld.i_className = oFld.className;
		oFld.className += 'On';
		i_AddEvent(oWdw, 'click', i_RMseClk, true);
	}
}

var sGeoSid = null;

function iGeoErr(oErr)
{	var	sErr;
	if (!oErr)
		sErr = 'Unsupported';
	else
	if (oErr.code == 1)
		sErr = 'Denied';
	else
	if (oErr.code == 2)
		sErr = 'Unavailable';
	else
	if (oErr.code == 1)
		sErr = 'Timeout';
		
	AjxSend('C' + oGeo.id.substr(3) + ',13:{ "error":"' + sErr+'" }');
}

function iGeoSts(oPos)
{	oGeo.value = '{ "latitude":' + oPos.coords.latitude + ', "longitude":' + oPos.coords.longitude+' }';
	AjxSend('C' + oGeo.id.substr(3) + ',13:' + oGeo.value, 0);	
}

function iGeoLoc(sId)
{	oGeo = i_Id(sId);
	if ((typeof(navigator) == undefined) ||
		(typeof(navigator.geolocation) == undefined) ||
		(typeof(navigator.geolocation.getCurrentPosition) == undefined))
		{	setTimeout(iGeoErr(null), 500);
			return;
		}
			
	navigator.geolocation.getCurrentPosition(iGeoSts, iGeoErr);
}

function iGdInit(oObj)
{	iLvInit(oObj);
}

function iLvInit(oObj)
{	var sId = oObj.id.substr(3);
	if (oObj.id.substr(0,3) != 'dv_')
	{	oObj = i_Id('dv_'+sId);
		if (!oObj) return;
	}

	if (oObj.i_init) iLvFree(oObj);

	iLvSetup(oObj);
	
	oObj.i_init = true;
	
	oObj.i_dd = i_Id('dd_'+sId);
	oObj.i_ds = i_Id('ds_'+sId);
	
	oObj.i_tl = i_Id('tl_'+sId);
	oObj.i_tr = i_Id('tr_'+sId);
	oObj.i_bl = i_Id('bl_'+sId);
	oObj.i_br = i_Id('br_'+sId);

	if (oObj.i_ds)
	{	var oDs = oObj.i_ds;

		if (oObj.i_dd)
		{	oObj.i_dd.style.width = oObj.i_ds.clientWidth + 'px';
			oObj.i_dd.style.height = oObj.i_ds.clientHeight + 'px';
		}

		oDs.iOldLeft = oDs.scrollLeft;
		oDs.iOldTop = oDs.scrollTop;
		aScrolls.push(oDs);				/* Add to list to monitor */
				
		if (bTouchScrn)
		{	oObj.i_TouchY = oObj.i_TouchX = 0;
			i_AddEvent(oObj, "touchstart", function(event)
			{	this.i_TouchY = this.i_ds.scrollTop+event.touches[0].pageY;
				this.i_TouchX = this.i_ds.scrollLeft+event.touches[0].pageX;
			},false);
 
			i_AddEvent(oObj, "touchmove", function(event)
				{	if (event.touches.length == 1)
					{	var savTop = this.i_ds.scrollTop;
						var savLeft = this.i_ds.scrollLeft;
						this.i_ds.scrollTop  = this.i_TouchY-event.touches[0].pageY;
						this.i_ds.scrollLeft = this.i_TouchX-event.touches[0].pageX;

						if (this.i_ds.scrollTop != savTop || this.i_ds.scrollLeft != savLeft) event.preventDefault();
					}
				},false);
		}
	}

	i_AddEvent(oObj.i_dd.parentNode, "mousedown", iLvMseEvent, true);
	i_AddEvent(oObj.i_dd.parentNode, "mouseup", iLvMseEvent, true);
	i_AddEvent(oObj.i_dd.parentNode, (bFireFox ? "DOMMouseScroll" : "mousewheel") , iLvMseWheel, true);

}

function iLvFree(oObj)
{	var	n = aScrolls.indexOf(oObj.i_ds);
	if (n >= 0) aScrolls.splice(n,1);

	if (oObj.i_init)
	{	i_RmvEvent(oObj.i_dd.parentNode, "mousedown", iLvMseEvent, true);
		i_RmvEvent(oObj.i_dd.parentNode, "mouseup", iLvMseEvent, true);
		i_RmvEvent(oObj.i_dd.parentNode, (bFireFox ? "DOMMouseScroll" : "mousewheel") , iLvMseWheel, true);
	}
	
	oObj.i_dd = oObj.i_ds = oObj.i_tl = oObj.i_tr = oObj.i_bl = oObj.i_br = null;

	oObj.i_init = false;
}

function iLvSetup(oObj)
{	var sId = oObj.id.substr(3);
	var oHdr = i_Id('tr_'+sId);
	if (!oHdr) return;

	var nCol = oHdr.getAttribute('data-lvu');
	if (!nCol) return;
	nCol = parseInt(nCol, 10);
	if (nCol <= 0) return;
	
	var oCol, oRow;
	var widths = new Array();
	var ids = new Array();
	
	nCol = 0;
	oCol = oHdr.firstChild.firstChild;

	while (oCol)
	{	if (oCol.nodeName == 'DIV')
		{	widths[nCol] = oCol.offsetWidth + 'px';
			ids[nCol] = oCol.id.substr(2+1+5+1+2+1);
			nCol++;
		}
		oCol = oCol.nextSibling;
	}
	
	oHdr = i_Id('br_' + sId);
	if (!oHdr) return;
	
	oRow = oHdr.firstChild;
	while (oRow)
	{	nCol = 0;
		oCol = oRow.firstChild;

		while(oCol)
		{	if (oCol.nodeName == 'DIV')
			{	if (!oCol.id) 
				{	oCol.id = 'lf_' + oRow.id.substr(3) + '_' + ids[nCol];
					if (oCol.className)
						oCol.className = 'iLvCol ' + oCol.className;
					else
						oCol.className = 'iLvCol';

					oCol.style.width = widths[nCol];	
				}

				nCol++;
			}
			oCol = oCol.nextSibling;
		}
		
		oRow = oRow.nextSibling;
	}
	return;
}
	

function iLvMseWheel(event)
{	if (window.event) event = window.event;
	var oObj = (event.target ? event.target : event.srcElement);
	var delta=event.detail ? event.detail*(-120) : event.wheelDelta;
	
	while (oObj)
	{	if (oObj.id) break;
		oObj = oObj.parentNode;
	}
	
	var oDs = i_Id('ds_' + oObj.id.substr(3,5));
	if (oDs) 
	{	oDs.scrollTop -= delta / 5;
	}

	return i_IgnEvent(event);
}

var nScrollCnt = 0;

function iLvScrl(event)
{	return true;			/* No used anymore but leave in case */
}

function iLvScrlUpd(oObj)
{	var oDiv = oObj.parentNode;
	var left = oObj.scrollLeft;
	var top = oObj.scrollTop;
	
	oObj.iOldLeft = left;
	oObj.iOldTop = top;

	if (!left) left = "0px"; else left = (0 - left) + 'px';
	if (!top) top = "0px"; else top = (0 - top) + 'px'; 

	if (oDiv.i_br)
	{	oDiv.i_br.style.top = top;
		oDiv.i_br.style.left = left;
		oDiv.i_br.style.position = 'relative';
	}
	if (oDiv.i_tr)
	{	oDiv.i_tr.style.left = left;
		oDiv.i_tr.style.position = 'relative';
	}
	if (oDiv.i_bl) 
	{	oDiv.i_bl.style.top = top;
		oDiv.i_bl.style.position = 'relative';
	}

	var sText = 'S' + oDiv.id.substr(3) + ',Scrl:' + oObj.scrollTop + ',' + oObj.scrollLeft;
	AjxSend(sText, 1);
	return;
}

var todMouseUp = 0;

function iLvMseEvent(event)
{	if (window.event) event = window.event;

	if ((event.button > 1) || (bRClick) || (event.altKey)) return;
	var oDiv = (event.target ? event.target : event.srcElement);
	var bDblClk = 0;

	if (event.type == 'mouseup')
	{	var date = new Date();
		var tod = date.getTime();
		if ((tod - todMouseUp) < 500)
		{	bDblClk = 1;
			tod = 0;
		}

		todMouseUp = tod;
	}

	iNmd_MseXY(event)

	if (oDiv.id && (oDiv.id.substr(0, 3) == 'gx_') && (oCellEdit == oDiv))
	{	if (oCellEdit.parentNode.getAttribute("data-dclk"))
		{	if (bDblClk)
			{	var v, oCell;
				oCell = oDiv;
				while (oCell.id)
				{	oCell = oCell.nextSibling;
				}
				v = oCell.getAttribute("data-v");
				if (v == null)
					v = "";
				else
					v = decodeURIComponent(v);

				oCellEdit.in_Chged = false;
				oCellEdit.parentNode.setAttribute("data-sts","F");

				oCellEdit.value = '';
				AjxSend('S' + oDiv.id.substr(3,5)+",Chg:2," + v);
			}

			return i_IgnEvent(event);
		}

		if (oCellEdit.parentNode.getAttribute("data-sts") == "E") return true;
	}
	
	var oMse = null;
	var rcObj;
	
	while (oDiv)
	{	if (oDiv.id && (oDiv.id.substr(0,3) != 'gx_')) break;
		oDiv = oDiv.parentNode;
	}

	oMse = iFindClk(oDiv, oDiv, event);

	if (event.type == 'mouseup')
	{	var date = new Date();
		todMouseUp = date.getTime();

		if (oMse.id.substr(0,3) == 'lf_') return iNmd_LvuClk(oMse, event);
		if (oMse.id.substr(0,3) == 'dd_') return iNmd_LvuClk(oMse, event);

		if (oMse.id.substr(0,3) == 'gb_') return iNmd_GrdBtn(oMse, event);
		if (oMse.id.substr(0,3) == 'gl_') return iGdDbxMse(oMse, event);
		if ((oMse.id.substr(0,3) == 'gc_') || (oMse.id.substr(0,3) == 'ch_'))  return iGd_CellMseUp(oMse, event.shiftKey);
	}
	else
	{	//if (oMse.id.substr(0,3) == 'lf_') return iNmd_LvuClk(oMse, event);
		if (oMse.id.substr(0,3) == 'hw_') return iLvHdrSz(oMse, event, true);
		if (oMse.id.substr(0,3) == 'hh_') return iLvHdrSz(oMse, event, false);
		
		if (oMse.id.substr(0,3) == 'gl_') return iGdDbxMse(oMse, event);
		if (oMse.id.substr(0,3) == 'gc_') return iGd_CellMseDown(oMse);
	}
	return false;
}

function iFindClk(oDiv, oMse, event)
{	var rcObj;

	var X = event.clientX;
	var Y = event.clientY;

	oDiv = oDiv.firstChild;
	while (oDiv)
	{	if (oDiv.id && (oDiv.id.substr(0,3) != 'gx_'))
		{	rcObj = oDiv.getBoundingClientRect();
			
			if ((X >= rcObj.left) && (X <= rcObj.right) && (Y >= rcObj.top) && (Y <= rcObj.bottom))
			{ 	oMse = oDiv;
			}
		}
		
		oDiv = oDiv.nextSibling;
	}
	
	return oMse;
}

function iLvHdrSz(oHdr, event, bChgWide)
{	if (oDivSize) return;
	
	iNmd_MseXY(event);
	nMseDownX = nMseX;
	nMseDownY = nMseY;

	oHdr = i_Id('ch_' + oHdr.id.substr(3));
	var rcHdr = oHdr.getBoundingClientRect();

	var sId = oHdr.id.substr(3);
	var nOfs = sId.indexOf('_');
	if (nOfs) sId = sId.substr(0,nOfs);
	
	var oDiv = i_Id('dd_' + sId);
	var rcDiv = oDiv.getBoundingClientRect();
	
	oDivSize = document.createElement('div');
	oDivSize.i_RszW = bChgWide;
	oDivSize.i_RszObj = oHdr;
	oDivSize.style.position='absolute';
	
	if (bChgWide)
	{	oDivSize.style.top = '0px';
		oDivSize.style.left = (rcHdr.left - rcDiv.left) + 'px';
		oDivSize.style.height = oDiv.offsetHeight + 'px';
		oDivSize.style.width = (rcHdr.right - rcHdr.left) + 'px';
	}
	else
	{	oDivSize.style.top = (rcHdr.top - rcDiv.top) + 'px';
		oDivSize.style.left = '0px';
		oDivSize.style.height = (rcHdr.bottom - rcHdr.top) + 'px';
		oDivSize.style.width = oDiv.offsetWidth + 'px';
	}
	
	oDivSize.className = 'iCmnSizeH';

	i_AddNode(oDivSize, oDiv);
	
	i_AddEvent(window, 'mouseup', iLvHdrSzEnd, true);
	i_AddEvent(window, 'mousemove', iLvHdrSzChg, true);

	if (window.event) event.returnValue = false;
	return false;
}

function iLvHdrSzChg(event)
{	if (!oDivSize) return;
	if (window.event) event = window.event;

	var nSize;

	iNmd_MseXY(event);
	if (oDivSize.i_RszW)
	{	nSize = oDivSize.i_RszObj.offsetWidth + nMseX - nMseDownX;
		if (nSize < 1) nSize = 1;
		oDivSize.style.width = nSize + 'px';
	}
	else
	{	nSize = oDivSize.i_RszObj.offsetHeight + nMseY - nMseDownY;
		if (nSize < 1) nSize = 1;
		oDivSize.style.height = nSize + 'px';
	}

	if (window.event)
		window.event.cancelBubble = true;
	else
		event.stopPropagation();

	return false;
}

function iLvHdrSzEnd(event)
{	i_RmvEvent(window, 'mouseup', iLvHdrSzEnd, true);
	i_RmvEvent(window, 'mousemove', iLvHdrSzChg, true);

	var sId = oDivSize.i_RszObj.id;
	var nOfs = sId.indexOf('_');
	sId = sId.substr(nOfs+1);	
	
	nOfs = sId.indexOf('_');
	var sCtl = sId.substr(0,nOfs);
	
	sId = sId.substr(nOfs+1);
	nOfs = sId.indexOf('_');
	var sRow = sId.substr(0,nOfs);
	var sCol = sId.substr(nOfs+1);
	
	if (sRow.substr(0,1) == 'N') sRow = '-' + sRow.substr(1);
	if (sCol.substr(0,1) == 'N') sCol = '-' + sCol.substr(1);

	if (oDivSize.i_RszW)
		var sAdj = 'Wide:' + oDivSize.offsetWidth + ',' + sCol;
	else
		var sAdj = 'High:' + oDivSize.offsetHeight + ',' + sRow;

	if (oDivSize) i_RmvNode(oDivSize);
	oDivSize = null;
	
	AjxSend('S' + sCtl + ',' + sAdj, 0); 

	if (oFcs && oFcs.focus) oFcs.focus();

	if (window.event)
		window.event.cancelBubble = true;
	else
		event.stopPropagation();
	return false;
}

function iFocus(oInp)
{	if (!oInp) return;
	if (oInp.focus)
	{	try { oInp.focus(); } catch(err) {}
	}
}

function iChkInid(sInid, bCheck)
{	var sCurInid = localStorage.getItem("inid");

	if (!sCurInid)
	{	localStorage.setItem("inid", sInid);
		document.cookie = 'inid=' + sInid + "; path=/";
		return;
	}

	if (!bCheck) return;
	if (sCurInid == sInid) return;

	window.onbeforeunload = null;
	window.onunload = null;
	bIgnUnload = true;
	
	location.replace("/syshtml/sys_security.htm");
	return;
}

function getCookie(cname)
{	var name = cname + "=";
	var ca = document.cookie.split(';');
	for(var i=0; i<ca.length; i++)
	{	var c = ca[i];
		while (c.charAt(0)==' ') c = c.substring(1);
		if (c.indexOf(name) == 0) return c.substring(name.length,c.length);
	}
	return "";
}

/* iTip = Process tip */
function iTip(oCtl, sTip)
{	var oTip = i_Id('iTip');
	if (!oTip)
	{	oCtl.setAttribute('title', sTip);
		return;
	}
	
	if (!oTip.bInit)
	{	oTip.bInit = true;
		i_AddEvent(oTip, 'mouseenter', iTipOn, true);
		i_AddEvent(oTip, 'mouseleave', iTipOff, false);
	}
	
	oTip.style.display = 'none';
	i_Id('iTipTxt').innerHTML = sTip;
	
	oTip.style.left = (iNmd_Left(oCtl) + oCtl.offsetWidth) + 'px';
	oTip.style.top = (iNmd_Top(oCtl) - 10) + 'px';

	oTip.iShow = true;
	setTimeout(iTipShow, 1000);
	
	i_AddEvent(oCtl, 'mouseleave', iTipOff, false);
	oTip.iCtl = oCtl;
	return;
}

function iTipOff()
{	var oTip = i_Id('iTip');
	if (oTip)
	{	oTip.iShow = false;
		setTimeout(iTipShow, 2000);

		if (oTip.iCtl)
		{	i_RmvEvent(oTip.iCtl, 'mouseleave', iTipOff, false);
			oTip.oCtl = null;
		}
	}
}

function iTipOn()
{	i_Id('iTip').iShow = true;
}

function iTipShow()
{	var oTip = i_Id('iTip');
	if (oTip)
	{	if (oTip.iShow)
			oTip.style.display = 'block';
		else
			oTip.style.display = 'none';
	}
	return;
}

function iInpTmr(nSec)
{	if (idInputTmr) clearTimeout(idInputTmr);
	idInputTmr = setTimeout(function(){ AjxCtl(-1000); }, nSec * 1000);
}

var nPnlX = 0;
var nPnlY = 0;
var tmPnlUpd = 0;
var bPnlDown = false;
	
function iPnlDwn(e)
{	if (window.event) e = window.event;
	if (e.button > 1) return;
	
	var oTarget = (e.target ? e.target : e.srcElement);	
	var oParent;
	if (!oTarget) return;

	while (oTarget)
	{	oParent = oTarget.parentNode;
		if (oTarget.id)
		{	if ((oTarget.id == 'id_Panel') || (oTarget.id == 'id_Folder')) break;
			if (oParent.id)
			{	if ((oParent.id == 'id_Panel') || (oParent.id == 'id_Folder'))
				{	if (oTarget.style.zIndex) return;
					break;
				}
			}
		}
		oTarget = oParent;
	}
	
	if (!oTarget) return;
	if (bPnlDown) return;
	
	var oInp = i_Id('id_0');
	if (oInp) oInp.focus();
	
	i_AddEvent(window, 'mousemove', iPnlUpd, true);
	i_AddEvent(window, 'mouseup', iPnlRls, true);
	bPnlDown = true;
	iPnlUpd(e);
}

function iPnlRls(e)
{	i_RmvEvent(window, 'mousemove', iPnlUpd, true);
	i_RmvEvent(window, 'mouseup', iPnlRls, true);
	bPnlDown = false;

	var oInp = i_Id('id_0');
	if (oInp) oInp.focus();
	iPnlUpd(e);
}

function iPnlUpd(e)
{	if (window.event) e = window.event;
	iNmd_MseXY(e);
	
	var tmNow = Date.now;
	if (e.type != "mouseup")
	{	if ((Math.abs(nMseX - nPnlX) + Math.abs(nMseY - nPnlY) < 4) && (tmNow-tmPnlUpd < 100))	
		{	alert("skip");
			return i_IgnEvent(e);
		}
	}
	
	nPnlX = Math.floor(nMseX);
	nPnlY = Math.floor(nMseY);
	tmPnlUpd = tmNow;
	
	var oPanel = i_Id('id_Panel');
	var rcDiv = oPanel.getBoundingClientRect();

	iNmd_Signal(sWdwObj, e.type + ":" + (nPnlY - rcDiv.top)+ "," + (nPnlX - rcDiv.left));
}

function i_Del(sId)
{	var oDiv = i_Id(sId);
	if (!oDiv) return;
	if (sFcsId == oDiv.id.substr(3)) oFcs.in_blur = null;
	i_RmvNode(oDiv);
	return;
}
function i_Add(idParent,sHTML)
{	var oParent = i_Id(idParent);
	if (!oParent) return;
	var oTmp = i_Id('TmpDiv');
	if (!oTmp) return;
	oTmp.innerHTML = sHTML;
	var oChild;
	
	while (oTmp.firstChild)
	{	oChild = oTmp.firstChild;
		oParent.appendChild(oChild);

		if (oChild.className == 'iLv') iLvInit(oChild);	
	}
	return;
}
function i_Chg(idHTML,sHTML)
{	var oDiv = i_Id(idHTML);
	if (!oDiv) return;
	var oTmp = i_Id('TmpDiv');
	if (!oTmp) return;
	oTmp.innerHTML = sHTML;

	var oChild = oTmp.firstChild;
	oDiv.parentNode.insertBefore(oChild, oDiv);
	i_RmvNode(oDiv);
	oDiv = null;

	if (oChild.className == 'iLv')iLvInit(oChild);
	oChild = oChild.firstChild;
	if (oChild.className == 'iLv')iLvInit(oChild);

	oTmp.innerHTML = '';
}

/* Pie hover logic .. Cannot use simple CSS as we want a custom tip */

function iPieOver(oSlice, bOver)
{	var idTip = oSlice.getAttribute('data-tip');
	if (!idTip) return;
	
	var oTip = i_Id(idTip);
	if (oTip) oTip.style.display = (bOver ? 'block' : 'none');

	var sId = oSlice.id;
	var nOfs = sId.indexOf('.',0);
	sId = sId.substring(0, nOfs + 1);

	nOfs = 0;
	while (true)
	{	nOfs++;

		oSlice = i_Id(sId + nOfs);
		if (!oSlice) break;

		if (oSlice.getAttribute('data-tip') != idTip) continue;
		if (bOver)
			oSlice.setAttribute('data-over','1');
		else
			oSlice.removeAttribute('data-over');
	}
	event.stopPropagation();	
	return;
}